/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicBasket;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;

public class BlockModelBasket<T extends BlockLogicBasket>
extends BlockModelStandard<T> {
    protected IconCoordinate fillTexture = TextureRegistry.getTexture("minecraft:block/basket/fill");

    public BlockModelBasket(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        AABBd bounds = new AABBd(this.block.getBounds());
        float onePix = 0.0625f;
        float basketHeight = 1.0f;
        bounds.setMin(0.0, 0.0, 0.0).setMax(1.0, 0.0625, 1.0);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        renderBlocks.setRenderSide(Side.EAST, false);
        renderBlocks.setRenderSide(Side.WEST, false);
        renderBlocks.setRenderSide(Side.BOTTOM, false);
        bounds.setMin(0.0, 0.0, 0.0).setMax(1.0, 1.0, 0.0625);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        bounds.setMin(0.0, 0.0, 0.9375).setMax(1.0, 1.0, 1.0);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        BlockModelBasket.renderBlocks.renderBitMask = 0;
        renderBlocks.setRenderSide(Side.NORTH, false);
        renderBlocks.setRenderSide(Side.SOUTH, false);
        renderBlocks.setRenderSide(Side.BOTTOM, false);
        bounds.setMin(0.0, 0.0, 0.0).setMax(0.0625, 1.0, 1.0);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        bounds.setMin(0.9375, 0.0, 0.0).setMax(1.0, 1.0, 1.0);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        bounds.setMin(0.0, 0.0, 0.0).setMax(1.0, 1.0, 1.0);
        BlockModelBasket.renderBlocks.renderBitMask = 0;
        int height = ((BlockLogicBasket)this.block.getLogic()).getFillLevel(worldSource, tilePos);
        if (height > 0) {
            renderBlocks.renderTopFace(tessellator, bounds, tilePos.x(), (float)(tilePos.y() - 1) + 0.0625f + 0.0625f * (float)height, tilePos.z(), this.fillTexture);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

