/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLadder;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockModelLadder<T extends BlockLogicLadder>
extends BlockModelStandard<T> {
    public BlockModelLadder(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        int data = worldSource.getBlockData(tilePos);
        IconCoordinate tex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, data);
        if (BlockModelLadder.renderBlocks.overrideBlockTexture != null) {
            tex = BlockModelLadder.renderBlocks.overrideBlockTexture;
        }
        tessellator.setLightmapCoord1i(this.block.getLightmapCoord(worldSource, tilePos));
        double uMin = tex.getIconUMin();
        double uMax = tex.getIconUMax();
        double vMin = tex.getIconVMin();
        double vMax = tex.getIconVMax();
        float f1 = 0.0f;
        float f2 = 0.05f;
        switch (((BlockLogicLadder)this.block.getLogic()).getSideFromMeta(data)) {
            case EAST: {
                tessellator.addVertexWithUV((float)tilePos.x() + f2, (float)(tilePos.y() + 1) + f1, (float)(tilePos.z() + 1) + f1, uMin, vMin);
                tessellator.addVertexWithUV((float)tilePos.x() + f2, (float)tilePos.y() - f1, (float)(tilePos.z() + 1) + f1, uMin, vMax);
                tessellator.addVertexWithUV((float)tilePos.x() + f2, (float)tilePos.y() - f1, (float)tilePos.z() - f1, uMax, vMax);
                tessellator.addVertexWithUV((float)tilePos.x() + f2, (float)(tilePos.y() + 1) + f1, (float)tilePos.z() - f1, uMax, vMin);
                break;
            }
            case WEST: {
                tessellator.addVertexWithUV((float)(tilePos.x() + 1) - f2, (float)tilePos.y() - f1, (float)(tilePos.z() + 1) + f1, uMax, vMax);
                tessellator.addVertexWithUV((float)(tilePos.x() + 1) - f2, (float)(tilePos.y() + 1) + f1, (float)(tilePos.z() + 1) + f1, uMax, vMin);
                tessellator.addVertexWithUV((float)(tilePos.x() + 1) - f2, (float)(tilePos.y() + 1) + f1, (float)tilePos.z() - f1, uMin, vMin);
                tessellator.addVertexWithUV((float)(tilePos.x() + 1) - f2, (float)tilePos.y() - f1, (float)tilePos.z() - f1, uMin, vMax);
                break;
            }
            case SOUTH: {
                tessellator.addVertexWithUV((float)(tilePos.x() + 1) + f1, (float)tilePos.y() - f1, (float)tilePos.z() + f2, uMax, vMax);
                tessellator.addVertexWithUV((float)(tilePos.x() + 1) + f1, (float)(tilePos.y() + 1) + f1, (float)tilePos.z() + f2, uMax, vMin);
                tessellator.addVertexWithUV((float)tilePos.x() - f1, (float)(tilePos.y() + 1) + f1, (float)tilePos.z() + f2, uMin, vMin);
                tessellator.addVertexWithUV((float)tilePos.x() - f1, (float)tilePos.y() - f1, (float)tilePos.z() + f2, uMin, vMax);
                break;
            }
            case NORTH: {
                tessellator.addVertexWithUV((float)(tilePos.x() + 1) + f1, (float)(tilePos.y() + 1) + f1, (float)(tilePos.z() + 1) - f2, uMin, vMin);
                tessellator.addVertexWithUV((float)(tilePos.x() + 1) + f1, (float)tilePos.y() - f1, (float)(tilePos.z() + 1) - f2, uMin, vMax);
                tessellator.addVertexWithUV((float)tilePos.x() - f1, (float)tilePos.y() - f1, (float)(tilePos.z() + 1) - f2, uMax, vMax);
                tessellator.addVertexWithUV((float)tilePos.x() - f1, (float)(tilePos.y() + 1) + f1, (float)(tilePos.z() + 1) - f2, uMax, vMin);
            }
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

