/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicSpikes;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;

public class BlockModelSpikes<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelSpikes(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        int metaData = worldSource.getBlockData(tilePos);
        IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.EAST, metaData);
        if (BlockModelSpikes.renderBlocks.overrideBlockTexture != null) {
            texture = BlockModelSpikes.renderBlocks.overrideBlockTexture;
        }
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, new AABBd(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0), tilePos);
        if (BlockLogicSpikes.isSpikesUp(metaData)) {
            tessellator.setLightmapCoord1i(this.block.getLightmapCoord(worldSource, tilePos));
            double uMin = texture.getIconUMin();
            double uMax = texture.getIconUMax();
            double vMin = texture.getIconVMin();
            double vMax = texture.getIconVMax();
            int x = tilePos.x();
            int y = tilePos.y();
            int z = tilePos.z();
            double d7 = (double)x + 0.5 - 0.25;
            double d8 = (double)x + 0.5 + 0.25;
            double d9 = (double)z + 0.5 - 0.5;
            double d10 = (double)z + 0.5 + 0.5;
            double mid = 0.25;
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d9, uMin, vMin);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d9, uMin, vMax);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d10, uMax, vMax);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d10, uMax, vMin);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d10, uMin, vMin);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d10, uMin, vMax);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 0.0, d9, uMax, vMax);
            tessellator.addVertexWithUV(d7 - 0.0625, (double)y + 1.0, d9, uMax, vMin);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d9, uMin, vMin);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d9, uMin, vMax);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d10, uMax, vMax);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d10, uMax, vMin);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d10, uMin, vMin);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d10, uMin, vMax);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 0.0, d9, uMax, vMax);
            tessellator.addVertexWithUV(d7 + mid, (double)y + 1.0, d9, uMax, vMin);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d10, uMin, vMin);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d10, uMin, vMax);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d9, uMax, vMax);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d9, uMax, vMin);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d9, uMin, vMin);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d9, uMin, vMax);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 0.0, d10, uMax, vMax);
            tessellator.addVertexWithUV(d8 + 0.0625, (double)y + 1.0, d10, uMax, vMin);
            d7 = (double)x + 0.5 - 0.5;
            d8 = (double)x + 0.5 + 0.5;
            d9 = (double)z + 0.5 - 0.25;
            d10 = (double)z + 0.5 + 0.25;
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 - 0.0625, uMin, vMin);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 - 0.0625, uMin, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 - 0.0625, uMax, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 - 0.0625, uMax, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 - 0.0625, uMin, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 - 0.0625, uMin, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 - 0.0625, uMax, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 - 0.0625, uMax, vMin);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 + mid, uMin, vMin);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 + mid, uMin, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 + mid, uMax, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 + mid, uMax, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d9 + mid, uMin, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d9 + mid, uMin, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d9 + mid, uMax, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d9 + mid, uMax, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d10 + 0.0625, uMin, vMin);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d10 + 0.0625, uMin, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d10 + 0.0625, uMax, vMax);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d10 + 0.0625, uMax, vMin);
            tessellator.addVertexWithUV(d7, (double)y + 1.0, d10 + 0.0625, uMin, vMin);
            tessellator.addVertexWithUV(d7, (double)y + 0.0, d10 + 0.0625, uMin, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 0.0, d10 + 0.0625, uMax, vMax);
            tessellator.addVertexWithUV(d8, (double)y + 1.0, d10 + 0.0625, uMax, vMin);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

