/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentTypeString;
import com.mojang.brigadier.builder.ArgumentBuilderLiteral;
import com.mojang.brigadier.builder.ArgumentBuilderRequired;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.command.arguments.ArgumentTypeEntity;
import net.minecraft.core.net.command.helpers.EntitySelector;

public class CommandMessage
implements CommandManager.CommandRegistry {
    @Override
    public void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralCommandNode<CommandSource> command = dispatcher.register((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("message").then(ArgumentBuilderRequired.argument("targets", ArgumentTypeEntity.usernames()).then(ArgumentBuilderRequired.argument("message", ArgumentTypeString.greedyString()).executes(c -> {
            CommandSource source = (CommandSource)c.getSource();
            EntitySelector entitySelector = c.getArgument("targets", EntitySelector.class);
            String message = c.getArgument("message", String.class);
            if (source.getSender() == null) {
                return 0;
            }
            String senderName = source.getSender().getDisplayName();
            List<? extends Entity> players = entitySelector.get(source);
            for (Entity entity : players) {
                source.sendMessage(TextFormatting.LIGHT_GRAY.toString() + TextFormatting.ITALIC.toString() + I18n.getInstance().translateKeyAndFormat("command.commands.message.outgoing", TextFormatting.removeAllFormatting(((Player)entity).getDisplayName()), message));
                source.sendMessage((Player)entity, String.valueOf(TextFormatting.LIGHT_GRAY) + String.valueOf(TextFormatting.ITALIC) + I18n.getInstance().translateKeyAndFormat("command.commands.message.incoming", TextFormatting.removeAllFormatting(senderName), message));
            }
            return 1;
        }))));
        dispatcher.register((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("msg").redirect(command));
        dispatcher.register((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("whisper").redirect(command));
        dispatcher.register((ArgumentBuilderLiteral)ArgumentBuilderLiteral.literal("tell").redirect(command));
    }
}

