/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.models.block.mojang;

import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightingCache;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.useless.dragonfly.DisplayPos;
import org.useless.dragonfly.data.block.mojang.BlockModelMojangData;
import org.useless.dragonfly.data.block.mojang.CompiledBlockModelMojangData;
import org.useless.dragonfly.models.block.StaticBlockModel;

public class StaticBlockModelMojang
implements StaticBlockModel {
    protected static final Minecraft MC = Minecraft.getMinecraft();
    protected static final LightingCache LIGHTING_CACHE = new LightingCache();
    protected static final byte[] V_TOP_X = new byte[]{0, 0, -1, 0, 0, 0};
    protected static final byte[] V_TOP_Y = new byte[]{0, 0, 0, 1, 0, 0};
    protected static final byte[] V_TOP_Z = new byte[]{1, 1, 0, 0, 1, 1};
    protected static final byte[] V_LEF_X = new byte[]{-1, 1, 0, -1, 0, 0};
    protected static final byte[] V_LEF_Y = new byte[]{0, 0, 1, 0, 1, -1};
    protected static final byte[] V_LEF_Z = new byte[]{0, 0, 0, 0, 0, 0};
    protected final CompiledBlockModelMojangData compiled;

    public StaticBlockModelMojang(BlockModelMojangData data) {
        this.compiled = new CompiledBlockModelMojangData(data);
    }

    @Override
    public boolean renderStandalone(@NotNull BlockModel<? extends BlockLogic> sourceModel, @NotNull TessellatorGeneral tessellator, double x, double y, double z, int metadata, @NotNull BlockColor color) {
        if (this.compiled.elements.length == 0) {
            return false;
        }
        GLRenderer.pushFrame();
        for (int i = 0; i < this.compiled.elements.length; ++i) {
            CompiledBlockModelMojangData.C_Element element = this.compiled.elements[i];
            GLRenderer.globalSetLightEnabled(element.shade);
            tessellator.startDrawingQuads();
            for (int face = 0; face < element.faces; ++face) {
                IconCoordinate coordinate = this.compiled.textures.getOrDefault(element.textures[face], BlockModelStandard.BLOCK_TEXTURE_UNASSIGNED);
                GLRenderer.setLightmapCoord2i(15, 15);
                if (element.tintIndices[face] >= 0) {
                    tessellator.setColor1i(color.getFallbackColor(metadata, element.tintIndices[face]));
                }
                int offset = face * 4 * 5;
                for (int v = 0; v < 4; ++v) {
                    tessellator.setNormal(element.normalData[face * 3 + 0], element.normalData[face * 3 + 1], element.normalData[face * 3 + 2]);
                    tessellator.addVertexWithUV(element.vertexData[offset + v * 5 + 0] - 0.5f, element.vertexData[offset + v * 5 + 1] - 0.5f, element.vertexData[offset + v * 5 + 2] - 0.5f, coordinate.getSubIconU(element.vertexData[offset + v * 5 + 3]), coordinate.getSubIconV(element.vertexData[offset + v * 5 + 4]));
                }
            }
            tessellator.draw();
        }
        GLRenderer.popFrame();
        return true;
    }

    @Override
    public boolean renderAttached(@NotNull BlockModel<? extends BlockLogic> sourceModel, @NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, int x, int y, int z, double xOff, double yOff, double zOff, boolean cullFaces, @Nullable IconCoordinate overrideTexture) {
        if (this.compiled.elements.length == 0) {
            return false;
        }
        boolean didRender = false;
        LIGHTING_CACHE.setupCache(sourceModel.block, worldSource, x, y, z);
        BlockColor color = (BlockColor)BlockColorDispatcher.getInstance().getDispatch(sourceModel.block);
        for (int i = 0; i < this.compiled.elements.length; ++i) {
            CompiledBlockModelMojangData.C_Element element = this.compiled.elements[i];
            for (int face = 0; face < element.faces; ++face) {
                float colorBlueBottomLeft;
                float colorGreenBottomLeft;
                float colorRedBottomLeft;
                float lightBL;
                float lightBR;
                float lightTR;
                float lightTL;
                int lightmapCoordBottomRight;
                int lightmapCoordBottomLeft;
                int lightmapCoordTopRight;
                int lightmapCoordTopLeft;
                boolean lefT;
                float b;
                float g;
                float r;
                boolean isFullCube;
                float lefP;
                float botP;
                float topP;
                float depth;
                if (cullFaces && this.cullSide(worldSource, x, y, z, element.cullfaces[face])) continue;
                IconCoordinate coordinate = overrideTexture == null ? this.compiled.textures.getOrDefault(element.textures[face], BlockModelStandard.BLOCK_TEXTURE_UNASSIGNED) : overrideTexture;
                Direction direction = element.directions[face];
                float minBrightness = (float)element.lightEmission / 15.0f;
                byte topX = V_TOP_X[direction.getId()];
                byte topY = V_TOP_Y[direction.getId()];
                byte topZ = V_TOP_Z[direction.getId()];
                byte lefX = V_LEF_X[direction.getId()];
                byte lefY = V_LEF_Y[direction.getId()];
                byte lefZ = V_LEF_Z[direction.getId()];
                float rigP = switch (direction) {
                    case Direction.DOWN -> {
                        depth = 0.0f + element.minY;
                        topP = element.maxZ;
                        botP = element.minZ;
                        lefP = 1.0f - element.minX;
                        yield 1.0f - element.maxX;
                    }
                    case Direction.UP -> {
                        depth = 1.0f - element.maxY;
                        topP = element.maxZ;
                        botP = element.minZ;
                        lefP = element.maxX;
                        yield element.minX;
                    }
                    case Direction.NORTH -> {
                        depth = 0.0f + element.minZ;
                        topP = 1.0f - element.minX;
                        botP = 1.0f - element.maxX;
                        lefP = element.maxY;
                        yield element.minY;
                    }
                    case Direction.SOUTH -> {
                        depth = 1.0f - element.maxZ;
                        topP = element.maxY;
                        botP = element.minY;
                        lefP = 1.0f - element.minX;
                        yield 1.0f - element.maxX;
                    }
                    case Direction.WEST -> {
                        depth = 0.0f + element.minX;
                        topP = element.maxZ;
                        botP = element.minZ;
                        lefP = element.maxY;
                        yield element.minY;
                    }
                    default -> {
                        depth = 1.0f - element.maxX;
                        topP = element.maxZ;
                        botP = element.minZ;
                        lefP = 1.0f - element.minY;
                        yield 1.0f - element.maxY;
                    }
                };
                boolean useAO = this.compiled.data.ambientOcclusion && MC.isAmbientOcclusionEnabled() && element.shade;
                boolean bl = isFullCube = depth <= 0.0625f && element.shade;
                if (element.tintIndices[face] >= 0) {
                    int c = color.getWorldColor(worldSource, x, y, z, element.tintIndices[face]);
                    r = (float)Color.redFromInt(c) / 255.0f;
                    g = (float)Color.greenFromInt(c) / 255.0f;
                    b = (float)Color.blueFromInt(c) / 255.0f;
                } else {
                    r = 1.0f;
                    g = 1.0f;
                    b = 1.0f;
                }
                int dirX = direction.getOffsetX();
                int dirY = direction.getOffsetY();
                int dirZ = direction.getOffsetZ();
                if (useAO) {
                    int lmcTopRig;
                    int lmcBotLef;
                    int lmcTopLef;
                    int lmcRig;
                    int dirZ2;
                    int dirY2;
                    int dirX2;
                    if (!isFullCube) {
                        dirX2 = 0;
                        dirY2 = 0;
                        dirZ2 = 0;
                    } else {
                        dirX2 = dirX;
                        dirY2 = dirY;
                        dirZ2 = dirZ;
                    }
                    boolean topT = LIGHTING_CACHE.getOpacity(dirX2 + topX, dirY2 + topY, dirZ2 + topZ);
                    boolean botT = LIGHTING_CACHE.getOpacity(dirX2 - topX, dirY2 - topY, dirZ2 - topZ);
                    lefT = LIGHTING_CACHE.getOpacity(dirX2 + lefX, dirY2 + lefY, dirZ2 + lefZ);
                    boolean rigT = LIGHTING_CACHE.getOpacity(dirX2 - lefX, dirY2 - lefY, dirZ2 - lefZ);
                    boolean topLefT = LIGHTING_CACHE.getOpacity(dirX2 + topX + lefX, dirY2 + topY + lefY, dirZ2 + topZ + lefZ);
                    boolean topRigT = LIGHTING_CACHE.getOpacity(dirX2 + topX - lefX, dirY2 + topY - lefY, dirZ2 + topZ - lefZ);
                    boolean botLefT = LIGHTING_CACHE.getOpacity(dirX2 - topX + lefX, dirY2 - topY + lefY, dirZ2 - topZ + lefZ);
                    boolean botRigT = LIGHTING_CACHE.getOpacity(dirX2 - topX - lefX, dirY2 - topY - lefY, dirZ2 - topZ - lefZ);
                    int lmcCen = this.getLightmap(dirX2, dirY2, dirZ2, element.lightEmission);
                    int lmcTop = topT ? lmcCen : this.getLightmap(dirX2 + topX, dirY2 + topY, dirZ2 + topZ, element.lightEmission);
                    int lmcBot = botT ? lmcCen : this.getLightmap(dirX2 - topX, dirY2 - topY, dirZ2 - topZ, element.lightEmission);
                    int lmcLef = lefT ? lmcCen : this.getLightmap(dirX2 + lefX, dirY2 + lefY, dirZ2 + lefZ, element.lightEmission);
                    int n = lmcRig = rigT ? lmcCen : this.getLightmap(dirX2 - lefX, dirY2 - lefY, dirZ2 - lefZ, element.lightEmission);
                    int n2 = topT && lefT ? lmcLef : (lmcTopLef = topLefT ? lmcCen : this.getLightmap(dirX2 + topX + lefX, dirY2 + topY + lefY, dirZ2 + topZ + lefZ, element.lightEmission));
                    int n3 = botT && lefT ? lmcLef : (lmcBotLef = botLefT ? lmcCen : this.getLightmap(dirX2 - topX + lefX, dirY2 - topY + lefY, dirZ2 - topZ + lefZ, element.lightEmission));
                    int n4 = topT && rigT ? lmcRig : (lmcTopRig = topRigT ? lmcCen : this.getLightmap(dirX2 + topX - lefX, dirY2 + topY - lefY, dirZ2 + topZ - lefZ, element.lightEmission));
                    int lmcBotRig = botT && rigT ? lmcRig : (botRigT ? lmcCen : this.getLightmap(dirX2 - topX - lefX, dirY2 - topY - lefY, dirZ2 - topZ - lefZ, element.lightEmission));
                    lightmapCoordTopLeft = LightmapHelper.avg(lmcCen, lmcLef, lmcTop, lmcTopLef);
                    lightmapCoordTopRight = LightmapHelper.avg(lmcCen, lmcRig, lmcTop, lmcTopRig);
                    lightmapCoordBottomLeft = LightmapHelper.avg(lmcCen, lmcLef, lmcBot, lmcBotLef);
                    lightmapCoordBottomRight = LightmapHelper.avg(lmcCen, lmcRig, lmcBot, lmcBotRig);
                } else {
                    int lmc = !isFullCube ? this.getLightmap(0, 0, 0, element.lightEmission) : this.getLightmap(dirX, dirY, dirZ, element.lightEmission);
                    lightmapCoordBottomRight = lightmapCoordTopRight = lmc;
                    lightmapCoordBottomLeft = lightmapCoordTopRight;
                    lightmapCoordTopLeft = lightmapCoordTopRight;
                }
                if (useAO) {
                    float dirB = this.getBrightness(dirX, dirY, dirZ, minBrightness);
                    lefT = LIGHTING_CACHE.getOpacity(dirX + lefX, dirY + lefY, dirZ + lefZ);
                    boolean botT = LIGHTING_CACHE.getOpacity(dirX - topX, dirY - topY, dirZ - topZ);
                    boolean topT = LIGHTING_CACHE.getOpacity(dirX + topX, dirY + topY, dirZ + topZ);
                    boolean rigT = LIGHTING_CACHE.getOpacity(dirX - lefX, dirY - lefY, dirZ - lefZ);
                    float lB = this.getBrightness(dirX + lefX, dirY + lefY, dirZ + lefZ, minBrightness);
                    float bB = this.getBrightness(dirX - topX, dirY - topY, dirZ - topZ, minBrightness);
                    float tB = this.getBrightness(dirX + topX, dirY + topY, dirZ + topZ, minBrightness);
                    float rB = this.getBrightness(dirX - lefX, dirY - lefY, dirZ - lefZ, minBrightness);
                    float blB = botT && lefT ? lB : this.getBrightness(dirX + lefX - topX, dirY + lefY - topY, dirZ + lefZ - topZ, minBrightness);
                    float tlB = topT && lefT ? lB : this.getBrightness(dirX + lefX + topX, dirY + lefY + topY, dirZ + lefZ + topZ, minBrightness);
                    float brB = botT && rigT ? rB : this.getBrightness(dirX - lefX - topX, dirY - lefY - topY, dirZ - lefZ - topZ, minBrightness);
                    float trB = topT && rigT ? rB : this.getBrightness(dirX - lefX + topX, dirY - lefY + topY, dirZ - lefZ + topZ, minBrightness);
                    lightTL = (tlB + lB + tB + dirB) / 4.0f;
                    lightTR = (tB + dirB + trB + rB) / 4.0f;
                    lightBR = (dirB + bB + rB + brB) / 4.0f;
                    lightBL = (lB + blB + dirB + bB) / 4.0f;
                    if (!isFullCube) {
                        dirB = this.getBrightness(0, 0, 0, minBrightness);
                        lefT = LIGHTING_CACHE.getOpacity(lefX, lefY, lefZ);
                        botT = LIGHTING_CACHE.getOpacity(-topX, -topY, -topZ);
                        topT = LIGHTING_CACHE.getOpacity(topX, topY, topZ);
                        rigT = LIGHTING_CACHE.getOpacity(-lefX, -lefY, -lefZ);
                        lB = this.getBrightness(lefX, lefY, lefZ, minBrightness);
                        bB = this.getBrightness(-topX, -topY, -topZ, minBrightness);
                        tB = this.getBrightness(topX, topY, topZ, minBrightness);
                        rB = this.getBrightness(-lefX, -lefY, -lefZ, minBrightness);
                        blB = botT && lefT ? lB : this.getBrightness(lefX - topX, lefY - topY, lefZ - topZ, minBrightness);
                        tlB = topT && lefT ? lB : this.getBrightness(lefX + topX, lefY + topY, lefZ + topZ, minBrightness);
                        brB = botT && rigT ? rB : this.getBrightness(-lefX - topX, -lefY - topY, -lefZ - topZ, minBrightness);
                        trB = topT && rigT ? rB : this.getBrightness(-lefX + topX, -lefY + topY, -lefZ + topZ, minBrightness);
                        lightTL = (tlB + lB + tB + dirB) / 4.0f * depth + lightTL * (1.0f - depth);
                        lightTR = (tB + dirB + trB + rB) / 4.0f * depth + lightTR * (1.0f - depth);
                        lightBR = (dirB + bB + rB + brB) / 4.0f * depth + lightBR * (1.0f - depth);
                        lightBL = (lB + blB + dirB + bB) / 4.0f * depth + lightBL * (1.0f - depth);
                    }
                } else {
                    int dirZ2;
                    int dirY2;
                    int dirX2;
                    if (!isFullCube) {
                        dirX2 = 0;
                        dirY2 = 0;
                        dirZ2 = 0;
                    } else {
                        dirX2 = dirX;
                        dirY2 = dirY;
                        dirZ2 = dirZ;
                    }
                    lightBR = lightTR = this.getBrightness(dirX2, dirY2, dirZ2, minBrightness);
                    lightBL = lightTR;
                    lightTL = lightTR;
                }
                float sideLight = element.shade && BlockModel.ENABLE_DIRECTIONAL_LIGHTING ? BlockModel.SIDE_LIGHT_MULTIPLIER[direction.getId()] : 1.0f;
                float colorRedBottomRight = colorRedBottomLeft = r * sideLight;
                float colorRedTopRight = colorRedBottomLeft;
                float colorRedTopLeft = colorRedBottomLeft;
                float colorGreenBottomRight = colorGreenBottomLeft = g * sideLight;
                float colorGreenTopRight = colorGreenBottomLeft;
                float colorGreenTopLeft = colorGreenBottomLeft;
                float colorBlueBottomRight = colorBlueBottomLeft = b * sideLight;
                float colorBlueTopRight = colorBlueBottomLeft;
                float colorBlueTopLeft = colorBlueBottomLeft;
                float tl = topP * lightTL + (1.0f - topP) * lightBL;
                float tr = topP * lightTR + (1.0f - topP) * lightBR;
                float bl2 = botP * lightTL + (1.0f - botP) * lightBL;
                float br = botP * lightTR + (1.0f - botP) * lightBR;
                float ltl = lefP * tl + (1.0f - lefP) * tr;
                float lbl = lefP * bl2 + (1.0f - lefP) * br;
                float lbr = rigP * bl2 + (1.0f - rigP) * br;
                float ltr = rigP * tl + (1.0f - rigP) * tr;
                colorRedTopLeft *= ltl;
                colorGreenTopLeft *= ltl;
                colorBlueTopLeft *= ltl;
                colorRedBottomLeft *= lbl;
                colorGreenBottomLeft *= lbl;
                colorBlueBottomLeft *= lbl;
                colorRedBottomRight *= lbr;
                colorGreenBottomRight *= lbr;
                colorBlueBottomRight *= lbr;
                colorRedTopRight *= ltr;
                colorGreenTopRight *= ltr;
                colorBlueTopRight *= ltr;
                int offset = face * 4 * 5;
                tessellator.setColorOpaque3f(colorRedTopLeft, colorGreenTopLeft, colorBlueTopLeft);
                tessellator.setLightmapCoord1i(lightmapCoordTopLeft);
                tessellator.addVertexWithUV((double)(element.vertexData[offset + 0] + (float)x) + xOff, (double)(element.vertexData[offset + 1] + (float)y) + yOff, (double)(element.vertexData[offset + 2] + (float)z) + zOff, coordinate.getSubIconU(element.vertexData[offset + 3]), coordinate.getSubIconV(element.vertexData[offset + 4]));
                tessellator.setColorOpaque3f(colorRedBottomLeft, colorGreenBottomLeft, colorBlueBottomLeft);
                tessellator.setLightmapCoord1i(lightmapCoordBottomLeft);
                tessellator.addVertexWithUV((double)(element.vertexData[offset + 5 + 0] + (float)x) + xOff, (double)(element.vertexData[offset + 5 + 1] + (float)y) + yOff, (double)(element.vertexData[offset + 5 + 2] + (float)z) + zOff, coordinate.getSubIconU(element.vertexData[offset + 5 + 3]), coordinate.getSubIconV(element.vertexData[offset + 5 + 4]));
                tessellator.setColorOpaque3f(colorRedBottomRight, colorGreenBottomRight, colorBlueBottomRight);
                tessellator.setLightmapCoord1i(lightmapCoordBottomRight);
                tessellator.addVertexWithUV((double)(element.vertexData[offset + 10 + 0] + (float)x) + xOff, (double)(element.vertexData[offset + 10 + 1] + (float)y) + yOff, (double)(element.vertexData[offset + 10 + 2] + (float)z) + zOff, coordinate.getSubIconU(element.vertexData[offset + 10 + 3]), coordinate.getSubIconV(element.vertexData[offset + 10 + 4]));
                tessellator.setColorOpaque3f(colorRedTopRight, colorGreenTopRight, colorBlueTopRight);
                tessellator.setLightmapCoord1i(lightmapCoordTopRight);
                tessellator.addVertexWithUV((double)(element.vertexData[offset + 15 + 0] + (float)x) + xOff, (double)(element.vertexData[offset + 15 + 1] + (float)y) + yOff, (double)(element.vertexData[offset + 15 + 2] + (float)z) + zOff, coordinate.getSubIconU(element.vertexData[offset + 15 + 3]), coordinate.getSubIconV(element.vertexData[offset + 15 + 4]));
                didRender = true;
            }
        }
        return didRender;
    }

    @Override
    @Nullable
    public IconCoordinate getOverlay() {
        return this.compiled.textures.get("#overlay");
    }

    @Override
    @Nullable
    public IconCoordinate getParticle(@NotNull Side side) {
        return this.compiled.textures.get("#particle_" + side.getDirection().name().toLowerCase(Locale.ROOT));
    }

    @Override
    public int particleColorIndex(@NotNull Side side) {
        return this.compiled.particleIndices[side.getId()];
    }

    @Override
    public int renderLayer() {
        return this.compiled.renderLayer;
    }

    @Override
    @NotNull
    public DisplayPos getItemDisplayPos(@NotNull String id) {
        return this.compiled.displayPosMap.getOrDefault(id, DisplayPos.DEFAULT_DISPLAY_POS);
    }

    protected boolean cullSide(WorldSource worldSource, int x, int y, int z, @Nullable Direction direction) {
        return direction != null && worldSource.isBlockOpaqueCube(x + direction.getOffsetX(), y + direction.getOffsetY(), z + direction.getOffsetZ());
    }

    protected float getBrightness(int relX, int relY, int relZ, float min) {
        return Math.max(LIGHTING_CACHE.getBrightness(relX, relY, relZ), min);
    }

    protected int getLightmap(int relX, int relY, int relZ, int min) {
        int coord = LIGHTING_CACHE.getLightmapCoord(relX, relY, relZ);
        int block = LightmapHelper.getBlockLightFromCoord(coord);
        if (block < min) {
            coord = LightmapHelper.setBlocklightValue(coord, min);
        }
        return coord;
    }
}

