/*
 * Decompiled with CFR 0.152.
 */
package org.useless.dragonfly.models.entity.mojang;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Map;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;
import org.useless.dragonfly.data.entity.mojang.Bone;
import org.useless.dragonfly.data.entity.mojang.Cube;
import org.useless.dragonfly.data.entity.mojang.EntityGeometryMojangData;
import org.useless.dragonfly.data.entity.mojang.Face;
import org.useless.dragonfly.models.entity.BoneTransform;
import org.useless.dragonfly.models.entity.StaticEntityModel;

public class StaticEntityModelMojang
implements StaticEntityModel {
    private static final BoneTransform DUMMY_TRANSFORM = new BoneTransform();
    private static final TessellatorEntity entityTessellator = new TessellatorEntity(2048);
    @NotNull
    public final @NotNull Map<@NotNull String, @NotNull BoneTransform> transformMap = new Object2ObjectOpenHashMap<String, BoneTransform>();
    @NotNull
    public final @NotNull BoneTransform @NotNull [] transforms;
    @NotNull
    public final @NotNull Bone @NotNull [] bones;
    public final EntityGeometryMojangData data;
    public final double inflation;
    @NotNull
    protected final AABBd visBounds;
    private final FloatBuffer mat4fBuf = BufferUtils.createFloatBuffer(16);
    private final double[] uvsBuffer = new double[8];

    public StaticEntityModelMojang(@NotNull EntityGeometryMojangData data, double inflation) {
        this.data = data;
        this.transforms = new BoneTransform[this.data.bones.size()];
        this.bones = new Bone[this.data.bones.size()];
        this.inflation = inflation;
        int i = 0;
        for (Map.Entry<String, Bone> entry : this.data.bones.entrySet()) {
            BoneTransform transform = new BoneTransform();
            this.transformMap.put(entry.getKey(), transform);
            this.transforms[i] = transform;
            this.bones[i] = entry.getValue();
            ++i;
        }
        this.visBounds = new AABBd(this.data.vBoundsOffset[0] - this.data.vBoundsWidth / 2.0, this.data.vBoundsOffset[1] - this.data.vBoundsHeight / 2.0, this.data.vBoundsOffset[2] - this.data.vBoundsWidth / 2.0, this.data.vBoundsOffset[0] + this.data.vBoundsWidth / 2.0, this.data.vBoundsOffset[1] + this.data.vBoundsHeight / 2.0, this.data.vBoundsOffset[2] + this.data.vBoundsWidth / 2.0);
    }

    @Override
    public void resetBones() {
        for (int i = 0; i < this.transforms.length; ++i) {
            this.transforms[i].reset();
        }
    }

    @Override
    @NotNull
    public BoneTransform getTransform(@NotNull String boneId) {
        return this.transformMap.getOrDefault(boneId, DUMMY_TRANSFORM);
    }

    @Override
    @NotNull
    public AABBdc visibleBounds() {
        return this.visBounds;
    }

    @Override
    public void translateToBone(@NotNull String boneId) {
        Bone bone = this.data.bones.get(boneId);
        if (bone == null) {
            return;
        }
        this.boneTransform(bone);
        GLRenderer.modelM4f().translate((float)bone.pivot[0], (float)bone.pivot[1], (float)bone.pivot[2]);
    }

    @Override
    public void render() {
        GLRenderer.getShader().bind();
        GLRenderer.globalSetUniforms(GLRenderer.getShader());
        for (int i = 0; i < this.bones.length; ++i) {
            Bone bone = this.bones[i];
            GLRenderer.pushFrame();
            if (!this.boneTransform(bone)) {
                GL41.glUniformMatrix4fv(GLRenderer.getShader().getUniform("model"), false, GLRenderer.modelM4f().get(this.mat4fBuf));
                this.renderBone(entityTessellator, bone);
            }
            GLRenderer.popFrame();
        }
    }

    protected boolean boneTransform(@NotNull Bone bone) {
        Bone parent;
        boolean hidden = false;
        Bone bone2 = parent = bone.parent != null ? this.data.bones.get(bone.parent) : null;
        if (parent != null) {
            hidden |= this.boneTransform(parent);
        }
        BoneTransform transform = this.transformMap.get(bone.name);
        hidden |= !transform.visible;
        GLRenderer.modelM4f().translate((float)bone.pivot[0], (float)bone.pivot[1], (float)bone.pivot[2]);
        GLRenderer.modelM4f().translate((float)transform.posX, (float)transform.posY, (float)transform.posZ);
        GLRenderer.modelM4f().rotateZ((float)(-transform.rotZ - Math.toRadians(bone.rotation[2])));
        GLRenderer.modelM4f().rotateY((float)(transform.rotY + Math.toRadians(bone.rotation[1])));
        GLRenderer.modelM4f().rotateX((float)(-transform.rotX - Math.toRadians(bone.rotation[0])));
        GLRenderer.modelM4f().translate((float)(-bone.pivot[0]), (float)(-bone.pivot[1]), (float)(-bone.pivot[2]));
        GLRenderer.modelM4f().scale((float)transform.scaleX, (float)transform.scaleY, (float)transform.scaleZ);
        return hidden;
    }

    protected void renderBone(@NotNull TessellatorEntity tessellator, @NotNull Bone bone) {
        tessellator.startDrawingQuads();
        for (Cube cube : bone.cubes) {
            double vMax;
            double vMin;
            double uMax;
            double uMin;
            Face face;
            double minX = cube.origin[0] - (cube.inflate + bone.inflate + this.inflation);
            double minY = cube.origin[1] - (cube.inflate + bone.inflate + this.inflation);
            double minZ = cube.origin[2] - (cube.inflate + bone.inflate + this.inflation);
            double maxX = minX + cube.size[0] + (cube.inflate + bone.inflate + this.inflation) * 2.0;
            double maxY = minY + cube.size[1] + (cube.inflate + bone.inflate + this.inflation) * 2.0;
            double maxZ = minZ + cube.size[2] + (cube.inflate + bone.inflate + this.inflation) * 2.0;
            if (cube.rotation == null) {
                face = cube.faces[Direction.UP.getId()];
                if (face != null) {
                    uMin = face.uv[0] / (double)this.data.textureWidth;
                    uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                    vMin = face.uv[1] / (double)this.data.textureHeight;
                    vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                    this.uvsBuffer[0] = uMin;
                    this.uvsBuffer[2] = uMin;
                    this.uvsBuffer[4] = uMax;
                    this.uvsBuffer[6] = uMax;
                    this.uvsBuffer[1] = vMin;
                    this.uvsBuffer[3] = vMax;
                    this.uvsBuffer[5] = vMax;
                    this.uvsBuffer[7] = vMin;
                    tessellator.setNormal(0.0, 1.0, 0.0);
                    tessellator.addVertexWithUV(minX, maxY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(minX, maxY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                }
                if ((face = cube.faces[Direction.DOWN.getId()]) != null) {
                    uMin = face.uv[0] / (double)this.data.textureWidth;
                    uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                    vMin = face.uv[1] / (double)this.data.textureHeight;
                    vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                    this.uvsBuffer[0] = uMin;
                    this.uvsBuffer[2] = uMax;
                    this.uvsBuffer[4] = uMax;
                    this.uvsBuffer[6] = uMin;
                    this.uvsBuffer[1] = vMax;
                    this.uvsBuffer[3] = vMax;
                    this.uvsBuffer[5] = vMin;
                    this.uvsBuffer[7] = vMin;
                    tessellator.setNormal(0.0, -1.0, 0.0);
                    tessellator.addVertexWithUV(minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, minY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, minY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(minX, minY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                }
                if ((face = cube.faces[Direction.NORTH.getId()]) != null) {
                    uMin = face.uv[0] / (double)this.data.textureWidth;
                    uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                    vMin = face.uv[1] / (double)this.data.textureHeight;
                    vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                    this.uvsBuffer[0] = uMin;
                    this.uvsBuffer[2] = uMax;
                    this.uvsBuffer[4] = uMax;
                    this.uvsBuffer[6] = uMin;
                    this.uvsBuffer[1] = vMax;
                    this.uvsBuffer[3] = vMax;
                    this.uvsBuffer[5] = vMin;
                    this.uvsBuffer[7] = vMin;
                    tessellator.setNormal(0.0, 0.0, -1.0);
                    tessellator.addVertexWithUV(minX, minY, minZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, minY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(minX, maxY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                }
                if ((face = cube.faces[Direction.SOUTH.getId()]) != null) {
                    uMin = face.uv[0] / (double)this.data.textureWidth;
                    uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                    vMin = face.uv[1] / (double)this.data.textureHeight;
                    vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                    this.uvsBuffer[0] = uMax;
                    this.uvsBuffer[2] = uMax;
                    this.uvsBuffer[4] = uMin;
                    this.uvsBuffer[6] = uMin;
                    this.uvsBuffer[1] = vMax;
                    this.uvsBuffer[3] = vMin;
                    this.uvsBuffer[5] = vMin;
                    this.uvsBuffer[7] = vMax;
                    tessellator.setNormal(0.0, 0.0, 1.0);
                    tessellator.addVertexWithUV(minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(minX, maxY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, maxZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, minY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                }
                if ((face = cube.faces[Direction.WEST.getId()]) != null) {
                    uMin = face.uv[0] / (double)this.data.textureWidth;
                    uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                    vMin = face.uv[1] / (double)this.data.textureHeight;
                    vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                    this.uvsBuffer[0] = uMax;
                    this.uvsBuffer[2] = uMax;
                    this.uvsBuffer[4] = uMin;
                    this.uvsBuffer[6] = uMin;
                    this.uvsBuffer[1] = vMax;
                    this.uvsBuffer[3] = vMin;
                    this.uvsBuffer[5] = vMin;
                    this.uvsBuffer[7] = vMax;
                    tessellator.setNormal(1.0, 0.0, 0.0);
                    tessellator.addVertexWithUV(maxX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                    tessellator.addVertexWithUV(maxX, minY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                }
                if ((face = cube.faces[Direction.EAST.getId()]) == null) continue;
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMin;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMax;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMax;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMin;
                tessellator.setNormal(-1.0, 0.0, 0.0);
                tessellator.addVertexWithUV(minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8]);
                tessellator.addVertexWithUV(minX, minY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8]);
                tessellator.addVertexWithUV(minX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8]);
                tessellator.addVertexWithUV(minX, maxY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8]);
                continue;
            }
            face = cube.faces[Direction.UP.getId()];
            if (face != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMin;
                this.uvsBuffer[2] = uMin;
                this.uvsBuffer[4] = uMax;
                this.uvsBuffer[6] = uMax;
                this.uvsBuffer[1] = vMin;
                this.uvsBuffer[3] = vMax;
                this.uvsBuffer[5] = vMax;
                this.uvsBuffer[7] = vMin;
                tessellator.setNormal(0.0, 1.0, 0.0);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.DOWN.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMin;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMax;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMax;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMin;
                tessellator.setNormal(0.0, -1.0, 0.0);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.NORTH.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMin;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMax;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMax;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMin;
                tessellator.setNormal(0.0, 0.0, -1.0);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, minZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.SOUTH.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMax;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMin;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMin;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMax;
                tessellator.setNormal(0.0, 0.0, 1.0);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, maxZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.WEST.getId()]) != null) {
                uMin = face.uv[0] / (double)this.data.textureWidth;
                uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
                vMin = face.uv[1] / (double)this.data.textureHeight;
                vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
                this.uvsBuffer[0] = uMax;
                this.uvsBuffer[2] = uMax;
                this.uvsBuffer[4] = uMin;
                this.uvsBuffer[6] = uMin;
                this.uvsBuffer[1] = vMax;
                this.uvsBuffer[3] = vMin;
                this.uvsBuffer[5] = vMin;
                this.uvsBuffer[7] = vMax;
                tessellator.setNormal(1.0, 0.0, 0.0);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, maxZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
                StaticEntityModelMojang.addRotatedVertex(tessellator, maxX, minY, minZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            }
            if ((face = cube.faces[Direction.EAST.getId()]) == null) continue;
            uMin = face.uv[0] / (double)this.data.textureWidth;
            uMax = (face.uv[0] + face.uv_size[0]) / (double)this.data.textureWidth;
            vMin = face.uv[1] / (double)this.data.textureHeight;
            vMax = (face.uv[1] + face.uv_size[1]) / (double)this.data.textureHeight;
            this.uvsBuffer[0] = uMin;
            this.uvsBuffer[2] = uMax;
            this.uvsBuffer[4] = uMax;
            this.uvsBuffer[6] = uMin;
            this.uvsBuffer[1] = vMax;
            this.uvsBuffer[3] = vMax;
            this.uvsBuffer[5] = vMin;
            this.uvsBuffer[7] = vMin;
            tessellator.setNormal(-1.0, 0.0, 0.0);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, maxZ, this.uvsBuffer[face.uv_rotation * 2 % 8], this.uvsBuffer[(1 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, minY, minZ, this.uvsBuffer[(2 + face.uv_rotation * 2) % 8], this.uvsBuffer[(3 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, minZ, this.uvsBuffer[(4 + face.uv_rotation * 2) % 8], this.uvsBuffer[(5 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
            StaticEntityModelMojang.addRotatedVertex(tessellator, minX, maxY, maxZ, this.uvsBuffer[(6 + face.uv_rotation * 2) % 8], this.uvsBuffer[(7 + face.uv_rotation * 2) % 8], cube.pivot, cube.rotation);
        }
        tessellator.draw();
    }

    protected static void addRotatedVertex(@NotNull TessellatorEntity tessellator, double x, double y, double z, double u, double v, double @NotNull [] pivot, double @NotNull [] rotation) {
        double _x = x - pivot[0];
        double _y = y - pivot[1];
        double _z = z - pivot[2];
        float sin = MathHelper.sin((float)(-rotation[0] * (double)MathHelper.DEG_TO_RAD));
        float cos = MathHelper.cos((float)(-rotation[0] * (double)MathHelper.DEG_TO_RAD));
        double nx = _x;
        double ny = _y * (double)cos - _z * (double)sin;
        double nz = _z * (double)cos + _y * (double)sin;
        _x = nx;
        _y = ny;
        _z = nz;
        sin = MathHelper.sin((float)(-rotation[1] * (double)MathHelper.DEG_TO_RAD));
        cos = MathHelper.cos((float)(-rotation[1] * (double)MathHelper.DEG_TO_RAD));
        nx = _x * (double)cos - _z * (double)sin;
        ny = _y;
        nz = _z * (double)cos + _x * (double)sin;
        _x = nx;
        _y = ny;
        _z = nz;
        sin = MathHelper.sin((float)(-rotation[2] * (double)MathHelper.DEG_TO_RAD));
        cos = MathHelper.cos((float)(-rotation[2] * (double)MathHelper.DEG_TO_RAD));
        nx = _x * (double)cos - _y * (double)sin;
        ny = _y * (double)cos + _x * (double)sin;
        nz = _z;
        _x = nx;
        _y = ny;
        _z = nz;
        tessellator.addVertexWithUV(_x + pivot[0], _y + pivot[1], _z + pivot[2], u, v);
    }

    public static class TessellatorEntity {
        private static final Logger LOGGER = LogUtils.getLogger();
        private static final int VERT_SIZE = 23;
        public ByteBuffer data;
        public boolean drawing;
        public byte normalX = 0;
        public byte normalY = (byte)-128;
        public byte normalZ = 0;
        public final int vao;
        public final int vbo;
        public int vertexCount = 0;
        private int quadVertCount = 0;

        public TessellatorEntity(int capacity) {
            this.data = BufferUtils.createByteBuffer(capacity);
            this.vao = GL41.glGenVertexArrays();
            this.vbo = GL41.glGenBuffers();
            GL41.glBindVertexArray(this.vao);
            GL41.glBindBuffer(34962, this.vbo);
            GL41.glVertexAttribPointer(0, 3, 5126, false, 23, 0L);
            GL41.glVertexAttrib4f(1, 1.0f, 1.0f, 1.0f, 1.0f);
            GL41.glVertexAttribPointer(2, 2, 5126, false, 23, 12L);
            GL41.glVertexAttrib2f(3, 0.96875f, 0.96875f);
            GL41.glVertexAttribPointer(4, 3, 5120, true, 23, 20L);
            GL41.glEnableVertexAttribArray(0);
            GL41.glEnableVertexAttribArray(2);
            GL41.glEnableVertexAttribArray(4);
        }

        public void startDrawingQuads() {
            if (this.drawing) {
                this.drawing = false;
                throw new IllegalStateException("Entity Tessellator already drawing!");
            }
            this.normalX = 0;
            this.normalY = (byte)-128;
            this.normalZ = 0;
            this.vertexCount = 0;
            this.quadVertCount = 0;
            this.drawing = true;
            this.data.clear();
        }

        public void addVertexWithUV(double x, double y, double z, double u, double v) {
            if (!this.drawing) {
                throw new IllegalStateException("Entity Tessellator already drawing!");
            }
            this.checkCanFit(64);
            this.data.putFloat((float)x).putFloat((float)y).putFloat((float)z);
            this.data.putFloat((float)u).putFloat((float)v);
            this.data.put(this.normalX).put(this.normalY).put(this.normalZ);
            ++this.vertexCount;
            if (this.quadVertCount % 4 == 2) {
                this.checkCanFit(128);
                this.data.put(this.data.position(), this.data, this.data.position() - 69, 23);
                this.data.put(this.data.position() + 23, this.data, this.data.position() - 23, 23);
                this.data.position(this.data.position() + 46);
                this.vertexCount += 2;
            }
            ++this.quadVertCount;
        }

        public void checkCanFit(int size) {
            if (this.data.capacity() < this.data.position() + size) {
                int newSize = this.data.capacity() * 2;
                LOGGER.info("Expanding {} Buffer ({} -> {})", "Entity Tessellator", this.data.capacity(), newSize);
                ByteBuffer newBuffer = BufferUtils.createByteBuffer(newSize);
                this.data.flip();
                newBuffer.put(this.data);
                this.data = newBuffer;
            }
        }

        public void setNormal(double x, double y, double z) {
            if (!this.drawing) {
                throw new IllegalStateException("Entity Tessellator already drawing!");
            }
            this.normalX = (byte)(x * 127.0);
            this.normalY = (byte)(y * 127.0);
            this.normalZ = (byte)(z * 127.0);
        }

        public void draw() {
            if (!this.drawing) {
                throw new IllegalStateException("Entity Tessellator already drawing!");
            }
            this.drawing = false;
            if (this.vertexCount == 0) {
                return;
            }
            GL41.glBindVertexArray(this.vao);
            GL41.glVertexAttrib2f(3, GLRenderer.getLightmapBlock(), GLRenderer.getLightmapSky());
            GL41.glBindBuffer(34962, this.vbo);
            GL41.glBufferData(34962, this.data.flip(), 35040);
            GL41.glDrawArrays(DrawMode.TRIANGLES.cap, 0, this.vertexCount);
            GL41.glBindVertexArray(0);
        }
    }
}

