/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class ClientCommandSource
implements CommandSource {
    private final Minecraft mc;

    public ClientCommandSource(Minecraft mc) {
        this.mc = mc;
    }

    @Override
    public Collection<String> getPlayerUsernames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Player player : this.mc.currentWorld.players) {
            list.add(player.username);
        }
        return list;
    }

    @Override
    public Collection<String> getPlayerNicknames() {
        ArrayList<String> list = new ArrayList<String>();
        for (Player player : this.mc.currentWorld.players) {
            list.add(player.nickname);
        }
        return list;
    }

    @Override
    public Collection<String> getEntitySuggestions() {
        ArrayList<String> suggestions = new ArrayList<String>(this.getPlayerUsernames());
        HitResult hitResult = this.mc.objectMouseOver;
        if (hitResult instanceof HitResult.Entity) {
            HitResult.Entity hitEntity = (HitResult.Entity)hitResult;
            suggestions.add("entity." + hitEntity.entity.hashCode());
        }
        return suggestions;
    }

    @Override
    public String toString() {
        return "ClientCommandSource{" + String.valueOf(this.mc) + "}";
    }

    @Override
    @NotNull
    public Player getSender() {
        return this.mc.thePlayer;
    }

    @Override
    public boolean hasAdmin() {
        return this.mc.currentWorld.getLevelData().getCheatsEnabled();
    }

    @Override
    @Nullable
    public Vector3dc getCoordinates(boolean offsetHeight) {
        Vector3dc position = this.getSender().getPosition(1.0f, false);
        if (offsetHeight) {
            return position.add(0.0, -this.getSender().heightOffset, 0.0, new Vector3d());
        }
        return position;
    }

    @Override
    @Nullable
    public TilePosc getBlockCoordinates() {
        HitResult hitResult = this.mc.objectMouseOver;
        if (hitResult instanceof HitResult.Tile) {
            HitResult.Tile hitTile = (HitResult.Tile)hitResult;
            return hitTile.tilePos;
        }
        Vector3dc playerCoordinates = this.getCoordinates(true);
        assert (playerCoordinates != null);
        return new TilePos(playerCoordinates);
    }

    @Override
    public boolean messageMayBeMultiline() {
        return !this.mc.thePlayer.username.equals("pr_ib");
    }

    @Override
    public void sendMessage(String message) {
        if (!this.mc.isMultiplayerWorld()) {
            this.mc.hudIngame.addChatMessage(message);
        }
    }

    @Override
    public void sendMessage(Player player, String message) {
        if (player == this.mc.thePlayer) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessageToAllPlayers(String message) {
        this.mc.thePlayer.sendChatMessage(message);
    }

    @Override
    public void sendPacketToAllPlayers(Supplier<Packet> packetSupplier) {
    }

    @Override
    public World getWorld() {
        return this.mc.currentWorld;
    }

    @Override
    public World getWorld(int dimension) {
        return this.mc.currentWorld.dimension.id == dimension ? this.mc.currentWorld : new World(this.mc.currentWorld, (Dimension)Dimension.getDimensionList().get(dimension));
    }

    @Override
    public void movePlayerToDimension(Player player, int dimension) {
        Dimension lastDim = (Dimension)Dimension.getDimensionList().get(player.dimension);
        Dimension newDim = (Dimension)Dimension.getDimensionList().get(dimension);
        System.out.println("Switching to dimension \"" + newDim.getTranslatedName() + "\"!!");
        player.dimension = dimension;
        this.mc.currentWorld.setEntityDead(player);
        this.mc.thePlayer.removed = false;
        double x = player.x;
        double y = player.y + 64.0;
        double z = player.z;
        player.moveTo(x *= (double)Dimension.getCoordScale(lastDim, newDim), y, z *= (double)Dimension.getCoordScale(lastDim, newDim), player.yRot, player.xRot);
        if (player.isAlive()) {
            this.mc.currentWorld.updateEntityWithOptionalForce(player, false);
        }
        WorldClient world = new WorldClient(this.mc.currentWorld, newDim);
        if (newDim == lastDim.homeDim) {
            this.mc.changeWorld(world, "Leaving " + lastDim.getTranslatedName(), player);
        } else {
            this.mc.changeWorld(world, "Entering " + newDim.getTranslatedName(), player);
        }
        player.world = this.mc.currentWorld;
        if (player.isAlive()) {
            player.moveTo(x, y, z, player.yRot, player.xRot);
            this.mc.currentWorld.updateEntityWithOptionalForce(player, false);
        }
    }

    @Override
    public void teleportPlayerToPos(Player player, double x, double y, double z) {
        player.absMoveTo(x, y, z, player.yRot, player.xRot);
    }

    @Override
    public void teleportPlayerToPosAndRot(Player player, double x, double y, double z, float yaw, float pitch) {
        player.absMoveTo(x, y, z, yaw, pitch);
    }

    @Override
    public String getName() {
        return this.mc.thePlayer.username;
    }
}

