/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Panel;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.canvas.CanvasCrashReport;
import net.minecraft.client.render.canvas.CanvasMojangLogo;
import net.minecraft.core.UnexpectedThrowable;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

public class PanelCrashReport
extends Panel {
    public String getStackTraceString(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    public PanelCrashReport(Minecraft minecraft, UnexpectedThrowable unexpectedThrowable, int cause) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setBackground(new Color(3028036));
        this.setLayout(new BorderLayout());
        String stackTrace = this.getStackTraceString(unexpectedThrowable.exception);
        String vendor = "";
        Object systemProperties = "";
        try {
            systemProperties = (String)systemProperties + "Generated " + new SimpleDateFormat().format(new Date());
            systemProperties = (String)systemProperties + "\nMinecraft: Better than Adventure! " + Minecraft.VERSION;
            systemProperties = (String)systemProperties + "\nOS: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version");
            systemProperties = (String)systemProperties + "\nJava: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor");
            systemProperties = (String)systemProperties + "\nVM: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor");
            systemProperties = (String)systemProperties + "\nLWJGL: " + Sys.getVersion();
            systemProperties = (String)systemProperties + "\nOpenGL: " + GL11.glGetString(7937) + " version " + GL11.glGetString(7938) + ", " + GL11.glGetString(7936);
            vendor = GL11.glGetString(7936);
        }
        catch (Throwable throwable) {
            systemProperties = (String)systemProperties + "\n[failed to get system properties (" + String.valueOf(throwable) + ")]";
        }
        Object finalCrashReport = "";
        if (stackTrace.contains("Pixel format not accelerated")) {
            finalCrashReport = (String)finalCrashReport + "\n";
            finalCrashReport = (String)finalCrashReport + "\n     Bad video card drivers!";
            finalCrashReport = (String)finalCrashReport + "\n     -----------------------";
            finalCrashReport = (String)finalCrashReport + "\n";
            finalCrashReport = (String)finalCrashReport + "\nMinecraft was unable to start because it failed to find an accelerated OpenGL mode.";
            finalCrashReport = (String)finalCrashReport + "\nThis can usually be fixed by updating the video card drivers.";
            if (vendor.toLowerCase().contains("nvidia")) {
                finalCrashReport = (String)finalCrashReport + "\n";
                finalCrashReport = (String)finalCrashReport + "\nYou might be able to find drivers for your video card here:";
                finalCrashReport = (String)finalCrashReport + "\n  http://www.nvidia.com/";
            } else if (vendor.toLowerCase().contains("ati")) {
                finalCrashReport = (String)finalCrashReport + "\n";
                finalCrashReport = (String)finalCrashReport + "\nYou might be able to find drivers for your video card here:";
                finalCrashReport = (String)finalCrashReport + "\n  http://www.amd.com/";
            }
        } else {
            finalCrashReport = (String)finalCrashReport + "\n";
            finalCrashReport = (String)finalCrashReport + "\n     Minecraft has crashed!";
            finalCrashReport = (String)finalCrashReport + "\n     ----------------------";
            finalCrashReport = (String)finalCrashReport + "\n";
            finalCrashReport = (String)finalCrashReport + "\nMinecraft has stopped running because it encountered a problem.";
            finalCrashReport = (String)finalCrashReport + "\n";
            finalCrashReport = (String)finalCrashReport + "\nIf you wish to report this, please copy this entire text and post it on the support portal at https://bugs.betterthanadventure.net/";
            finalCrashReport = (String)finalCrashReport + "\nPlease include a description of what you did when the error occured.";
        }
        finalCrashReport = (String)finalCrashReport + "\n";
        finalCrashReport = (String)finalCrashReport + "\n";
        finalCrashReport = (String)finalCrashReport + "\n     System Information";
        finalCrashReport = (String)finalCrashReport + "\n     ------------------";
        finalCrashReport = (String)finalCrashReport + "\n";
        finalCrashReport = (String)finalCrashReport + "\n" + (String)systemProperties;
        finalCrashReport = (String)finalCrashReport + "\n";
        finalCrashReport = (String)finalCrashReport + "\n";
        finalCrashReport = (String)finalCrashReport + "\n     Error Information";
        finalCrashReport = (String)finalCrashReport + "\n     ------------------";
        finalCrashReport = (String)finalCrashReport + "\n";
        if (cause == 2 && minecraft != null && minecraft.lastCrash != null) {
            finalCrashReport = (String)finalCrashReport + "\nThe following exception caused the crash handler to open:";
            finalCrashReport = (String)finalCrashReport + "\n" + this.getStackTraceString(minecraft.lastCrash.exception);
            finalCrashReport = (String)finalCrashReport + "\n";
            finalCrashReport = (String)finalCrashReport + "\nThe following exception occured while trying to render the crash handler:";
            finalCrashReport = (String)finalCrashReport + "\n" + stackTrace;
        } else {
            finalCrashReport = (String)finalCrashReport + "\n" + stackTrace;
        }
        finalCrashReport = (String)finalCrashReport + "\n";
        finalCrashReport = (String)finalCrashReport + "\n";
        finalCrashReport = (String)finalCrashReport + "\n";
        JTextArea textarea = new JTextArea((String)finalCrashReport);
        textarea.setEditable(false);
        textarea.setFont(new Font("Monospaced", 0, 12));
        this.add((Component)new CanvasMojangLogo(), "North");
        this.add((Component)new CanvasCrashReport(80), "East");
        this.add((Component)new CanvasCrashReport(80), "West");
        this.add((Component)new CanvasCrashReport(100), "South");
        JScrollPane scrollPane = new JScrollPane(textarea, 22, 31);
        this.add((Component)scrollPane, "Center");
    }
}

