/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorTerrain;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.primitives.AABBd;

public class BlockModelLever<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelLever(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorTerrain tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        boolean overrideTexture;
        int data = worldSource.getBlockData(tilePos);
        int rotation = data & 0xF;
        boolean powered = (data & 0x10) != 0;
        boolean bl = overrideTexture = BlockModelLever.renderBlocks.overrideBlockTexture != null;
        if (!overrideTexture) {
            BlockModelLever.renderBlocks.overrideBlockTexture = TextureRegistry.getTexture("minecraft:block/cobbled_stone");
        }
        float f = 0.25f;
        float f1 = 0.1875f;
        float f2 = 0.1875f;
        AABBd bounds = new AABBd(this.block.getBounds());
        switch (rotation) {
            case 7: {
                bounds.setMin(0.5f - f1, 1.0f - f2, 0.5f - f).setMax(0.5f + f1, 1.0, 0.5f + f);
                break;
            }
            case 8: {
                bounds.setMin(0.5f - f, 1.0f - f2, 0.5f - f1).setMax(0.5f + f, 1.0, 0.5f + f1);
                break;
            }
            case 5: {
                bounds.setMin(0.5f - f1, 0.0, 0.5f - f).setMax(0.5f + f1, f2, 0.5f + f);
                break;
            }
            case 6: {
                bounds.setMin(0.5f - f, 0.0, 0.5f - f1).setMax(0.5f + f, f2, 0.5f + f1);
                break;
            }
            case 4: {
                bounds.setMin(0.5f - f1, 0.5f - f, 1.0f - f2).setMax(0.5f + f1, 0.5f + f, 1.0);
                break;
            }
            case 3: {
                bounds.setMin(0.5f - f1, 0.5f - f, 0.0).setMax(0.5f + f1, 0.5f + f, f2);
                break;
            }
            case 2: {
                bounds.setMin(1.0f - f2, 0.5f - f, 0.5f - f1).setMax(1.0, 0.5f + f, 0.5f + f1);
                break;
            }
            case 1: {
                bounds.setMin(0.0, 0.5f - f, 0.5f - f1).setMax(f2, 0.5f + f, 0.5f + f1);
            }
        }
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        if (!overrideTexture) {
            BlockModelLever.renderBlocks.overrideBlockTexture = null;
        }
        tessellator.setLightmapCoord1i(this.block.getLightmapCoord(worldSource, tilePos));
        IconCoordinate texture = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, data);
        if (BlockModelLever.renderBlocks.overrideBlockTexture != null) {
            texture = BlockModelLever.renderBlocks.overrideBlockTexture;
        }
        double f4 = texture.getIconUMin();
        double f5 = texture.getIconUMax();
        double f6 = texture.getIconVMin();
        double f7 = texture.getIconVMax();
        Vector3d[] renderVecs = new Vector3d[8];
        float f8 = 0.0625f;
        float f9 = 0.0625f;
        float f10 = 0.625f;
        renderVecs[0] = new Vector3d(-f8, 0.0, -f9);
        renderVecs[1] = new Vector3d(f8, 0.0, -f9);
        renderVecs[2] = new Vector3d(f8, 0.0, f9);
        renderVecs[3] = new Vector3d(-f8, 0.0, f9);
        renderVecs[4] = new Vector3d(-f8, f10, -f9);
        renderVecs[5] = new Vector3d(f8, f10, -f9);
        renderVecs[6] = new Vector3d(f8, f10, f9);
        renderVecs[7] = new Vector3d(-f8, f10, f9);
        for (int i2 = 0; i2 < 8; ++i2) {
            if (powered) {
                renderVecs[i2].z -= 0.0625;
                renderVecs[i2].rotateX(-0.6981316804885864);
            } else {
                renderVecs[i2].z += 0.0625;
                renderVecs[i2].rotateX(0.6981316804885864);
            }
            if (rotation == 6 || rotation == 8) {
                renderVecs[i2].rotateY(-1.5707963705062866);
            }
            if (rotation < 5) {
                renderVecs[i2].y -= 0.375;
                renderVecs[i2].rotateX(-1.5707963705062866);
                if (rotation == 4) {
                    renderVecs[i2].rotateY(0.0);
                }
                if (rotation == 3) {
                    renderVecs[i2].rotateY(-3.1415927410125732);
                }
                if (rotation == 2) {
                    renderVecs[i2].rotateY(1.5707963705062866);
                }
                if (rotation == 1) {
                    renderVecs[i2].rotateY(-1.5707963705062866);
                }
                renderVecs[i2].x += (double)tilePos.x() + 0.5;
                renderVecs[i2].y += (double)((float)tilePos.y() + 0.5f);
                renderVecs[i2].z += (double)tilePos.z() + 0.5;
                continue;
            }
            if (rotation == 5 || rotation == 6) {
                renderVecs[i2].x += (double)tilePos.x() + 0.5;
                renderVecs[i2].y += (double)((float)tilePos.y() + 0.125f);
                renderVecs[i2].z += (double)tilePos.z() + 0.5;
                continue;
            }
            renderVecs[i2].rotateX(3.1415927410125732);
            renderVecs[i2].x += (double)tilePos.x() + 0.5;
            renderVecs[i2].y += (double)(tilePos.y() + 1) - 0.125;
            renderVecs[i2].z += (double)tilePos.z() + 0.5;
        }
        for (int j2 = 0; j2 < 6; ++j2) {
            Vector3d vec3d3;
            Vector3d vec32;
            Vector3d vec31;
            Vector3d vec3;
            if (j2 == 0) {
                f4 = texture.getSubIconU(0.4375);
                f5 = texture.getSubIconU(0.5625);
                f6 = texture.getSubIconV(0.375);
                f7 = texture.getSubIconV(0.5);
            } else if (j2 == 2) {
                f4 = texture.getSubIconU(0.4375);
                f5 = texture.getSubIconU(0.5625);
                f6 = texture.getSubIconV(0.375);
                f7 = texture.getIconVMax();
            }
            if (j2 == 0) {
                vec3 = renderVecs[0];
                vec31 = renderVecs[1];
                vec32 = renderVecs[2];
                vec3d3 = renderVecs[3];
            } else if (j2 == 1) {
                vec3 = renderVecs[7];
                vec31 = renderVecs[6];
                vec32 = renderVecs[5];
                vec3d3 = renderVecs[4];
            } else if (j2 == 2) {
                vec3 = renderVecs[1];
                vec31 = renderVecs[0];
                vec32 = renderVecs[4];
                vec3d3 = renderVecs[5];
            } else if (j2 == 3) {
                vec3 = renderVecs[2];
                vec31 = renderVecs[1];
                vec32 = renderVecs[5];
                vec3d3 = renderVecs[6];
            } else if (j2 == 4) {
                vec3 = renderVecs[3];
                vec31 = renderVecs[2];
                vec32 = renderVecs[6];
                vec3d3 = renderVecs[7];
            } else {
                vec3 = renderVecs[0];
                vec31 = renderVecs[3];
                vec32 = renderVecs[7];
                vec3d3 = renderVecs[4];
            }
            tessellator.addVertexWithUV(vec3.x, vec3.y, vec3.z, f4, f7);
            tessellator.addVertexWithUV(vec31.x, vec31.y, vec31.z, f5, f7);
            tessellator.addVertexWithUV(vec32.x, vec32.y, vec32.z, f5, f6);
            tessellator.addVertexWithUV(vec3d3.x, vec3d3.y, vec3d3.z, f4, f6);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

