#version 410 core

#define FOG
#define RADIAL_FOG

in vec4 Color;
in vec2 TexCoord;

out vec4 FragColor;

layout (std140) uniform FogState {
	vec4 color;
	int mode;
	float start;
	float end;
	float density;
} fogState;

layout (std140) uniform Matrices {
	mat4 projection;
	mat4 projectionInv;
	mat4 view;
	mat4 viewInv;
} matrices;

uniform int isEyeInLiquid;
uniform vec2 uViewPortSize;

uniform sampler2D texture0;
uniform sampler2D texture1;

float distance() {
	vec4 fragPos = matrices.projectionInv * vec4((gl_FragCoord.xy / uViewPortSize) * 2.0f - 1.0f, gl_FragCoord.z * 2.0f - 1.0f, 1.0f);
	fragPos /= fragPos.w;

	return length(fragPos.xyz);
}

void main() {
	vec4 tex = texture(texture0, TexCoord);
	
	// Alpha test
	if(tex.a < 0.1f) {
		discard;
	}
	
	// Hide clouds when in water or lava
	if(isEyeInLiquid != 0) {
		discard;
	}
	
	vec4 col = Color;

	float fogStrength = 0.0f;

	float end = (fogState.end * 1.5f);
	float start = fogState.start / (fogState.end * 1.5f);

	fogStrength = distance() / end;
	fogStrength -= start;
	fogStrength /= (1.0f - start);
	fogStrength = clamp(fogStrength, 0.0f, 1.0f);
	col.a *= 1.0f - fogStrength;
	
	FragColor = tex * col;
}