/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.culling;

import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.renderer.GLRenderer;
import org.jetbrains.annotations.NotNull;
import org.joml.FrustumIntersection;
import org.joml.Matrix4f;
import org.joml.primitives.AABBdc;

public class CameraFrustum {
    @NotNull
    private final ICamera camera;
    @NotNull
    private static final FrustumIntersection frustum = new FrustumIntersection();
    @NotNull
    private static final Matrix4f matrix4f = new Matrix4f();

    public static void recalcFrustrum() {
        frustum.set(GLRenderer.projectionM4f().mul(GLRenderer.viewM4f(), matrix4f).mul(GLRenderer.modelM4f(), matrix4f));
    }

    @NotNull
    public static FrustumIntersection getFrustum() {
        return frustum;
    }

    public CameraFrustum(@NotNull ICamera camera) {
        this.camera = camera;
    }

    public boolean cubeInFrustum(@NotNull AABBdc aabb, float partialTick) {
        return frustum.testAab((float)(aabb.minX() - this.camera.getX(partialTick)), (float)(aabb.minY() - this.camera.getY(partialTick)), (float)(aabb.minZ() - this.camera.getZ(partialTick)), (float)(aabb.maxX() - this.camera.getX(partialTick)), (float)(aabb.maxY() - this.camera.getY(partialTick)), (float)(aabb.maxZ() - this.camera.getZ(partialTick)));
    }

    public boolean isVisible(@NotNull AABBdc aabb, float partialTick) {
        return this.cubeInFrustum(aabb, partialTick);
    }
}

