/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import com.b100.utils.ImageUtils;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.GLAllocation;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.util.helper.Buffer;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class Textures {
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    public static final BufferedImage missingTexture = new BufferedImage(64, 64, 2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImage(InputStream stream) {
        if (stream == null) {
            return missingTexture;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(stream);
            return bufferedImage;
        }
        catch (Exception e) {
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static BufferedImage readImageUnhandled(InputStream stream) throws IOException {
        if (stream == null) {
            return missingTexture;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(stream);
            return bufferedImage;
        }
        finally {
            stream.close();
        }
    }

    public static ByteBuffer readImageToByteBuffer(BufferedImage image) {
        int[] data = Textures.getImageData(image);
        ByteBuffer buffer = ByteBuffer.allocateDirect(data.length * 4);
        buffer.asIntBuffer().put(data);
        return buffer;
    }

    public static int[] getImageData(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        int[] imageData = new int[w * h];
        image.getRGB(0, 0, w, h, imageData, 0, w);
        return imageData;
    }

    public static int[] getImageData(BufferedImage image, int[] imageData) {
        int w = image.getWidth();
        int h = image.getHeight();
        image.getRGB(0, 0, w, h, imageData, 0, w);
        return imageData;
    }

    public static BufferedImage unwrapImageByColumns(BufferedImage image) {
        int i = image.getWidth() / 16;
        BufferedImage image2 = new BufferedImage(16, image.getHeight() * i, 2);
        Graphics g = image2.getGraphics();
        for (int j = 0; j < i; ++j) {
            g.drawImage(image, -j * 16, j * image.getHeight(), null);
        }
        g.dispose();
        return image2;
    }

    public static void dumpTextures() {
        File[] files;
        File folder = new File("dumpTextures");
        if (folder.exists() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                file.delete();
            }
        }
        OpenGLHelper.checkError("pre texture dump");
        LOGGER.info("Dump Textures...");
        IntList textureList = GLAllocation.textureNames;
        block1: for (int i = 0; i < textureList.size(); ++i) {
            Integer tex = textureList.getInt(i);
            LOGGER.debug("Tex: {}", (Object)tex);
            GL11.glBindTexture(3553, tex);
            int maxLevel = GL11.glGetTexParameteri(3553, 33085);
            LOGGER.debug("Max Level: {}", (Object)maxLevel);
            for (int level = 0; level <= maxLevel; ++level) {
                int w = GL11.glGetTexLevelParameteri(3553, level, 4096);
                int h = GL11.glGetTexLevelParameteri(3553, level, 4097);
                OpenGLHelper.checkError("dump check texture size");
                if (w == 0 || h == 0) continue block1;
                LOGGER.debug("Level {}: {} x {}", level, w, h);
                int size = w * h * 4;
                Buffer.checkBufferSize(size);
                ByteBuffer buffer = Buffer.buffer;
                buffer.position(0).limit(size);
                GL11.glGetTexImage(3553, level, 6408, 5121, buffer);
                if (GL11.glGetError() == 0) {
                    buffer.position(0);
                    ImageUtils.saveExternalImage(Textures.getImage(buffer, w, h, true, false), new File(folder, "tex" + tex + "-level" + level + ".png"));
                    buffer.position(0);
                    ImageUtils.saveExternalImage(Textures.getImage(buffer, w, h, false, false), new File(folder, "tex" + tex + "-level" + level + "-opaque.png"));
                    continue;
                }
                LOGGER.warn("Cannot get pixel data");
            }
        }
        TextureRegistry.dumpTilesToFolder(folder);
        LOGGER.info("Dumped textures into {}", (Object)folder.getAbsolutePath());
        OpenGLHelper.checkError("texture dump");
    }

    public static void saveImage(File file, BufferedImage image) {
        if (image == null) {
            return;
        }
        try {
            file.createNewFile();
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save image to file '{}'!", (Object)file.getPath(), (Object)e);
        }
    }

    public static BufferedImage getTextureAsImage(int texture, boolean alpha, int level) {
        return Textures.getTextureAsImage(texture, alpha, level, false);
    }

    public static BufferedImage getTextureAsImage(int texture, boolean alpha, int level, boolean mirrorVertical) {
        GL11.glBindTexture(3553, texture);
        int w = GL11.glGetTexLevelParameteri(3553, level, 4096);
        int h = GL11.glGetTexLevelParameteri(3553, level, 4097);
        if (w == 0 || h == 0) {
            return null;
        }
        LOGGER.debug("Texture {} Size: {} x {}", texture, w, h);
        Buffer.reset();
        Buffer.checkBufferSize(w * h * 16);
        GL11.glGetTexImage(3553, level, 6408, 5121, Buffer.buffer);
        Buffer.buffer.position(0);
        Buffer.buffer.limit(Buffer.buffer.capacity());
        int[] rgb = new int[w * h];
        for (int i = 0; i < rgb.length; ++i) {
            int c;
            int j = i;
            if (mirrorVertical) {
                int x = i % w;
                int y = i / w;
                y = h - y - 1;
                j = y * w + x;
            }
            int r = Buffer.getInt(j * 4 + 2) & 0xFF;
            int g = Buffer.getInt(j * 4 + 1) & 0xFF;
            int b = Buffer.getInt(j * 4 + 0) & 0xFF;
            int a = Buffer.getInt(j * 4 + 3) & 0xFF;
            if (!alpha) {
                a = 255;
            }
            rgb[i] = c = (r << 0) + (g << 8) + (b << 16) + (a << 24);
        }
        BufferedImage image = new BufferedImage(w, h, alpha ? 2 : 1);
        image.setRGB(0, 0, w, h, rgb, 0, w);
        return image;
    }

    public static BufferedImage getImage(ByteBuffer buffer, int width, int height, boolean transparent, boolean verticalMirror) {
        int type = transparent ? 2 : 1;
        BufferedImage image = new BufferedImage(width, height, type);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int a;
                int b;
                int g;
                int r;
                try {
                    r = buffer.get() & 0xFF;
                    g = buffer.get() & 0xFF;
                    b = buffer.get() & 0xFF;
                    a = buffer.get() & 0xFF;
                }
                catch (Exception e) {
                    throw new RuntimeException("X: " + x + " Y: " + y + " C: " + buffer.capacity() + " L: " + buffer.limit() + " P: " + buffer.position(), e);
                }
                int color = a << 24 | r << 16 | g << 8 | b;
                image.setRGB(x, verticalMirror ? image.getHeight() - y - 1 : y, color);
            }
        }
        return image;
    }

    static {
        Graphics g = missingTexture.getGraphics();
        try {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        catch (Exception exception) {
            // empty catch block
        }
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 64, 64);
        g.setColor(Color.BLACK);
        g.drawString("missingtex", 1, 10);
        g.dispose();
    }
}

