/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome.provider;

import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.noise.PerlinSimplexNoise;
import org.jetbrains.annotations.NotNull;

public class BiomeProviderB173
extends BiomeProvider {
    private static final float ZOOM = 2.0f;
    private static final float TEMP_SCALE = 0.025f;
    private static final float DOWNFALL_SCALE = 0.05f;
    private static final float NOISE_SCALE = 0.25f;
    @NotNull
    private final PerlinSimplexNoise temperatureMap;
    @NotNull
    private final PerlinSimplexNoise downfallMap;
    @NotNull
    private final PerlinSimplexNoise noiseMap;

    public BiomeProviderB173(long seed) {
        this.temperatureMap = new PerlinSimplexNoise(new Random(seed * 9871L), 4);
        this.downfallMap = new PerlinSimplexNoise(new Random(seed * 39811L), 4);
        this.noiseMap = new PerlinSimplexNoise(new Random(seed * 543321L), 2);
    }

    @Override
    public Biome[] getBiomes(Biome[] biomes, double[] temperatures, double[] humidities, double[] varieties, int x, int y, int z, int xSize, int ySize, int zSize) {
        if (biomes == null || biomes.length < xSize * ySize * zSize) {
            biomes = new Biome[xSize * ySize * zSize];
        }
        if (temperatures == null || temperatures.length < xSize * zSize) {
            temperatures = new double[xSize * zSize];
        }
        this.temperatureMap.getRegion(temperatures, x, z, xSize, xSize, 0.025, 0.025, 0.25);
        if (humidities == null || humidities.length < xSize * zSize) {
            humidities = new double[xSize * zSize];
        }
        this.downfallMap.getRegion(humidities, x, z, xSize, xSize, 0.05, 0.05, 0.3333333333333333);
        if (varieties == null || varieties.length < xSize * zSize) {
            varieties = new double[xSize * zSize];
        }
        Arrays.fill(varieties, 0.0);
        double[] noises = this.noiseMap.getRegion(null, x, z, xSize, xSize, 0.25, 0.25, 0.5882352941176471);
        for (int xx = 0; xx < xSize; ++xx) {
            for (int zz = 0; zz < zSize; ++zz) {
                double a = noises[xx * zSize + zz] * 1.1 + 0.5;
                double b = 0.01;
                double c = 1.0 - b;
                double temperature = (temperatures[xx * zSize + zz] * 0.15 + 0.7) * c + a * b;
                b = 0.002;
                c = 1.0 - b;
                double downfall = (humidities[xx * zSize + zz] * 0.15 + 0.5) * c + a * b;
                if ((temperature = 1.0 - (1.0 - temperature) * (1.0 - temperature)) < 0.0) {
                    temperature = 0.0;
                }
                if (temperature > 1.0) {
                    temperature = 1.0;
                }
                if (downfall < 0.0) {
                    downfall = 0.0;
                }
                if (downfall > 1.0) {
                    downfall = 1.0;
                }
                temperatures[xx * zSize + zz] = temperature;
                humidities[xx * zSize + zz] = downfall;
                for (int yy = 0; yy < ySize; ++yy) {
                    biomes[yy * xSize * zSize + zz * xSize + xx] = this.lookupBiome(temperature, downfall, 0.0, 0.0);
                }
            }
        }
        return biomes;
    }

    @Override
    public double[] getTemperatures(double[] temperatures, int x, int z, int xSize, int zSize) {
        if (temperatures == null || temperatures.length < xSize * zSize) {
            temperatures = new double[xSize * zSize];
        }
        this.temperatureMap.getRegion(temperatures, x, z, xSize, xSize, 0.025, 0.025, 0.25);
        double[] noises = this.noiseMap.getRegion(null, x, z, xSize, zSize, 0.25, 0.25, 0.5882352941176471);
        int i = 0;
        for (int xx = 0; xx < xSize; ++xx) {
            for (int zz = 0; zz < zSize; ++zz) {
                double a = noises[i] * 1.1 + 0.5;
                double b = 0.01;
                double c = 0.99;
                double temperature = (temperatures[i] * 0.15 + 0.7) * 0.99 + a * 0.01;
                if ((temperature = 1.0 - (1.0 - temperature) * (1.0 - temperature)) < 0.0) {
                    temperature = 0.0;
                }
                if (temperature > 1.0) {
                    temperature = 1.0;
                }
                temperatures[i++] = temperature;
            }
        }
        return temperatures;
    }

    @Override
    public double[] getHumidities(double[] humidities, int x, int z, int xSize, int zSize) {
        if (humidities == null || humidities.length < xSize * zSize) {
            humidities = new double[xSize * zSize];
        }
        return this.downfallMap.getRegion(humidities, x, z, xSize, zSize, 0.05, 0.05, 0.5);
    }

    @Override
    public double[] getVarieties(double[] varieties, int x, int z, int xSize, int zSize) {
        if (varieties == null || varieties.length < xSize * zSize) {
            varieties = new double[xSize * zSize];
        }
        Arrays.fill(varieties, 0.0);
        return varieties;
    }

    @Override
    public double[] getBiomenesses(double[] biomenesses, int x, int y, int z, int xSize, int ySize, int zSize) {
        if (biomenesses == null || biomenesses.length < xSize * ySize * zSize) {
            biomenesses = new double[xSize * ySize * zSize];
        }
        Arrays.fill(biomenesses, 1.0);
        return biomenesses;
    }

    @Override
    public Biome lookupBiome(double temperature, double humidity, double altitude, double variety) {
        humidity *= temperature;
        if (temperature < 0.1) {
            return Biomes.OVERWORLD_LEGACY_TUNDRA;
        }
        if (humidity < 0.2) {
            if (temperature < 0.5) {
                return Biomes.OVERWORLD_LEGACY_TUNDRA;
            }
            return temperature < 0.95 ? Biomes.OVERWORLD_LEGACY_SAVANNA : Biomes.OVERWORLD_LEGACY_DESERT;
        }
        if (humidity > 0.5 && temperature < 0.7) {
            return Biomes.OVERWORLD_LEGACY_SWAMPLAND;
        }
        if (temperature < 0.5) {
            return Biomes.OVERWORLD_LEGACY_TAIGA;
        }
        if (temperature < 0.97) {
            return humidity < 0.35 ? Biomes.OVERWORLD_LEGACY_SHRUBLAND : Biomes.OVERWORLD_LEGACY_FOREST;
        }
        if (humidity < 0.45) {
            return Biomes.OVERWORLD_LEGACY_PLAINS;
        }
        return humidity < 0.9 ? Biomes.OVERWORLD_LEGACY_SEASONAL_FOREST : Biomes.OVERWORLD_LEGACY_RAINFOREST;
    }
}

