#version 330 core
out vec4 FragColor;

in vec4 Color;
in vec2 TexCoord;
in vec2 Lightmap;

uniform sampler2D colortex;
uniform sampler2D lighttex;

void main() {
    FragColor = texture(colortex, TexCoord) * texture(lighttex, Lightmap) * Color;
    if (FragColor.a < 0.1f) {
        discard;
    }
}