/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.codewaves.codehighlight.core.Highlighter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.console.LogMessage;
import net.minecraft.client.console.LogMessageReceiver;
import net.minecraft.client.console.shell.RuntimeExecutor;
import net.minecraft.client.console.syntax.RendererFactory;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.text.ITextField;
import net.minecraft.client.gui.text.TextFieldEditor;
import net.minecraft.client.render.font.Fonts;
import net.minecraft.client.render.window.CursorShape;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ScreenConsole
extends Screen {
    private static final int LINES_TO_SCROLL = 6;
    private static final int PADDING = 4;
    private static final int LINE_HEIGHT = 12;
    private static int heightLines = 12;
    private boolean dragging = false;
    @NotNull
    private final LogRenderer logRenderer = new LogRenderer();
    @NotNull
    private final InputRenderer inputRenderer = new InputRenderer();

    public ScreenConsole(@Nullable Screen parent) {
        super(parent);
    }

    private int getMaxY() {
        return 4 + (heightLines - this.inputRenderer.getHeightLines()) * 12 + 4 + 4 + this.inputRenderer.getHeightLines() * 12 + 4;
    }

    @Override
    public void tick() {
        super.tick();
        this.inputRenderer.tick();
    }

    @Override
    public void init() {
        if (this.parentScreen != null && (this.parentScreen.width != this.width || this.parentScreen.height != this.height)) {
            this.parentScreen.width = this.width;
            this.parentScreen.height = this.height;
            this.parentScreen.buttons.clear();
            this.parentScreen.init();
        }
        super.init();
        Keyboard.enableRepeatEvents(true);
        this.logRenderer.init(this.mc, this.width - 8);
    }

    @Override
    public void removed() {
        super.removed();
        Keyboard.enableRepeatEvents(false);
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        int dWheel;
        super.render(mx, my, partialTick);
        if (this.parentScreen != null) {
            this.parentScreen.render(-1, -1, partialTick);
        }
        if ((dWheel = Mouse.getDWheel()) != 0) {
            this.logRenderer.scroll(dWheel * 6);
        }
        if (this.dragging) {
            heightLines = Math.max(1, (my - 10) / 12);
        }
        if (this.getMaxY() >= this.height - 1) {
            heightLines = Math.max(1, (this.height - 16) / 12 - 1);
        }
        this.drawRect(0, 0, this.width, this.getMaxY(), -553648128);
        this.logRenderer.render(4, 4, heightLines - this.inputRenderer.getHeightLines());
        int inputRendererHeight = this.inputRenderer.getHeightLines() * 12;
        this.inputRenderer.render(4, this.getMaxY() - 4 - inputRendererHeight);
        this.drawRect(4, this.getMaxY() - (4 + inputRendererHeight + 4) - 2, this.width - 4, this.getMaxY() - (4 + inputRendererHeight + 4) - 1, 0x7F9F9F9F);
        if (this.mouseOverGrabbyRegion(mx, my) || this.dragging) {
            this.setDesiredCursor(CursorShape.VERTICAL_RESIZE);
        } else if (mx > 4 && my >= this.getMaxY() - (4 + inputRendererHeight) && my < this.getMaxY() - 4) {
            this.setDesiredCursor(CursorShape.I_BEAM);
        } else {
            this.setDesiredCursor(CursorShape.ARROW);
        }
        this.drawRect(0, this.getMaxY(), this.width, this.getMaxY() + 1, this.mouseOverGrabbyRegion(mx, my) || this.dragging ? -2105377 : -6316129);
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == this.mc.gameSettings.keyShowConsole.getKeyCode() || eventKey == Keyboard.KEY_ESCAPE) {
            this.mc.displayScreen(this.parentScreen);
        } else {
            if (eventKey == Keyboard.KEY_RETURN) {
                this.logRenderer.setScroll(0);
            }
            this.inputRenderer.handleInput(eventKey, eventCharacter);
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        int inputRendererHeight = this.inputRenderer.getHeightLines() * 12;
        if (buttonNum == 0 && this.mouseOverGrabbyRegion(mx, my)) {
            this.dragging = true;
        } else if (buttonNum == 0 && mx >= 4 && my >= this.getMaxY() - 4 - inputRendererHeight && my <= this.getMaxY() - 4) {
            this.inputRenderer.click(mx - 4, my - (this.getMaxY() - 4 - inputRendererHeight));
        } else if (my > this.getMaxY()) {
            this.mc.displayScreen(this.parentScreen);
        }
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        super.mouseReleased(mx, my, buttonNum);
        if (buttonNum == 0) {
            this.dragging = false;
        }
    }

    private boolean mouseOverGrabbyRegion(int mx, int my) {
        int yMax = this.getMaxY();
        return mx >= 0 && mx < this.width && my >= yMax - 1 && my <= yMax + 2;
    }

    private static final class LogRenderer
    extends Gui {
        private static final int SCROLL_INDICATOR_WIDTH = 3;
        private static final int SCROLL_INDICATOR_HEIGHT = 32;
        @NotNull
        private static final @NotNull List<@NotNull String> WORKED_LINES = new ArrayList<String>();
        private static boolean callbackInitialized = false;
        @NotNull
        private final @NotNull Map<@NotNull LogMessage.Level, @NotNull TextFormatting> preludes = new HashMap<LogMessage.Level, TextFormatting>();
        private int width = 0;
        private int scroll = 0;

        public LogRenderer() {
            this.preludes.put(LogMessage.Level.ERROR, TextFormatting.RED);
            this.preludes.put(LogMessage.Level.WARN, TextFormatting.YELLOW);
            this.preludes.put(LogMessage.Level.INFO, TextFormatting.WHITE);
            this.preludes.put(LogMessage.Level.DEBUG, TextFormatting.LIGHT_BLUE);
            this.preludes.put(LogMessage.Level.TRACE, TextFormatting.GRAY);
        }

        public void init(@NotNull Minecraft mc, int width) {
            this.width = width;
            this.initWorkedLines();
            @NotNull ArrayList<@NotNull E> workedLine = new ArrayList();
            if (!callbackInitialized) {
                LogMessageReceiver.addCallback(message -> {
                    this.formatString((LogMessage)message, workedLine);
                    WORKED_LINES.addAll(workedLine);
                    this.trimWorkedLines();
                });
                callbackInitialized = true;
            }
        }

        public void render(int x, int y, int numLines) {
            if (numLines >= WORKED_LINES.size() - this.scroll) {
                this.scroll = 0;
            }
            int lines = Math.min(heightLines, WORKED_LINES.size() - this.scroll);
            for (int i = lines - 1; i >= 0; --i) {
                @NotNull String line = WORKED_LINES.get(WORKED_LINES.size() - 1 - (i + this.scroll));
                Minecraft.getMinecraft().font.render(line, x, y + this.getHeight(numLines) - 12 - 12 * i).setFont(Fonts.MONOSPACE).setColor(-3158065).call();
            }
            this.renderScrollIndicator(x, y, numLines);
        }

        public int getHeight(int numLines) {
            return 12 * numLines;
        }

        public int getWidth() {
            return this.width;
        }

        public void scroll(int numLines) {
            if (WORKED_LINES.size() <= heightLines) {
                return;
            }
            this.scroll = MathHelper.clamp(this.scroll + numLines, 0, WORKED_LINES.size() - heightLines);
        }

        public void setScroll(int scroll) {
            this.scroll = MathHelper.clamp(scroll, 0, WORKED_LINES.size() - heightLines);
        }

        private void renderScrollIndicator(int x, int y, int numLines) {
            if (numLines * 12 <= 32) {
                this.drawRect(x + this.width - 3, y, x + this.width, y + numLines * 12, -1);
                return;
            }
            float scrollPercentage = 1.0f - this.getScrollPercentage();
            int scrollRegionHeight = numLines * 12 - 32;
            int scrollY = (int)((float)scrollRegionHeight * scrollPercentage);
            this.drawRect(x + this.width - 3, y + scrollY, x + this.width, y + scrollY + 32, -1);
        }

        private float getScrollPercentage() {
            if (WORKED_LINES.size() <= heightLines) {
                return 0.0f;
            }
            return MathHelper.clamp((float)this.scroll / (float)(WORKED_LINES.size() - heightLines), 0.0f, 1.0f);
        }

        private void initWorkedLines() {
            WORKED_LINES.clear();
            @NotNull ArrayList<@NotNull String> formattedLine = new ArrayList<String>();
            for (LogMessage message : LogMessageReceiver.getQueue()) {
                this.formatString(message, formattedLine);
                WORKED_LINES.addAll(formattedLine);
            }
            this.trimWorkedLines();
        }

        private void trimWorkedLines() {
            while (WORKED_LINES.size() > 1000) {
                WORKED_LINES.remove(0);
            }
        }

        private void formatString(@NotNull LogMessage message, @NotNull @NotNull List<@NotNull String> out) {
            out.clear();
            @NotNull String @NotNull [] workedString = message.getMessage().replace("\r\n", "\n").replace("\t", "    ").split("\n");
            @NotNull TextFormatting currentFormat = this.preludes.getOrDefault((Object)message.getLevel(), TextFormatting.WHITE);
            String[] stringArray = workedString;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String line;
                @NotNull String trimmedLine = line = stringArray[i];
                @NotNull StringBuilder sb = new StringBuilder();
                int lineWidth = 0;
                @NotNull TextFormatting nextFormat = currentFormat;
                for (int i2 = 0; i2 < trimmedLine.length(); ++i2) {
                    int cWidth;
                    char c = trimmedLine.charAt(i2);
                    if (c == '\u00a7' && i2 + 1 < trimmedLine.length()) {
                        @Nullable TextFormatting newFormat = TextFormatting.fromChar(trimmedLine.charAt(i2 + 1));
                        if (newFormat != null) {
                            nextFormat = newFormat;
                        }
                        lineWidth -= Fonts.MONOSPACE.charWidth(c) + Fonts.MONOSPACE.charWidth(trimmedLine.charAt(i2 + 1));
                    }
                    if (lineWidth + (cWidth = Fonts.MONOSPACE.charWidth(c)) >= this.width) {
                        out.add(currentFormat.toString() + String.valueOf(sb));
                        sb = new StringBuilder();
                        sb.append(nextFormat);
                        lineWidth = 0;
                    }
                    sb.append(trimmedLine.charAt(i2));
                    lineWidth += cWidth;
                }
                out.add(currentFormat.toString() + String.valueOf(sb));
            }
        }
    }

    private static final class InputRenderer
    extends Gui
    implements ITextField {
        @NotNull
        private static final @NotNull List<@NotNull String> HISTORY = new ArrayList<String>();
        @Nullable
        private static final RuntimeExecutor EXECUTOR = new RuntimeExecutor();
        @NotNull
        private String text = "";
        @NotNull
        private String highlightedText = "";
        @NotNull
        private String originalText = "";
        private int cursorCounter = 0;
        @NotNull
        private final TextFieldEditor editor;
        private int historyIndex = 0;
        private final Highlighter<String> highlighter = new Highlighter<String>(new RendererFactory());

        public InputRenderer() {
            this.editor = new TextFieldEditor(this, true);
        }

        public void tick() {
            ++this.cursorCounter;
        }

        public void render(int x, int y) {
            boolean addedStart = false;
            @NotNull String @NotNull [] splitHighlighted = this.highlightedText.split("\n", -1);
            for (int i = 0; i < splitHighlighted.length; ++i) {
                Minecraft.getMinecraft().font.render((addedStart ? "  " : "> ") + splitHighlighted[i].replace("\n", ""), x, y).setFont(Fonts.MONOSPACE).setZ(this.zLevel).setColor(-2039584).call();
                addedStart = true;
            }
            @NotNull String @NotNull [] split = this.text.split("\n", -1);
            int offsetWidth = MathHelper.ceil(Minecraft.getMinecraft().font.stringWidthDouble("  "));
            int[] cursorPos = this.getCursor();
            int cursorX = cursorPos[0] == split[cursorPos[1]].length() ? MathHelper.ceil(Minecraft.getMinecraft().font.stringWidthDouble(split[cursorPos[1]])) : MathHelper.ceil(Minecraft.getMinecraft().font.stringWidthDouble(split[cursorPos[1]].substring(0, cursorPos[0])));
            if (this.cursorCounter / 6 % 2 == 0) {
                Minecraft.getMinecraft().font.render("\u2588", x + offsetWidth + cursorX, y + cursorPos[1] * 12).setFont(Fonts.MONOSPACE).setZ(this.zLevel).setColor(-1).call();
                if (this.editor.getCursor() < this.text.length() && this.text.charAt(this.editor.getCursor()) != '\n') {
                    Minecraft.getMinecraft().font.render("" + this.text.charAt(this.editor.getCursor()), x + offsetWidth + cursorX, y + cursorPos[1] * 12).setFont(Fonts.MONOSPACE).setZ(this.zLevel).setColor(-16777216).call();
                }
            } else {
                Minecraft.getMinecraft().font.render("_", x + offsetWidth + cursorX, y + cursorPos[1] * 12).setFont(Fonts.MONOSPACE).setZ(this.zLevel).setColor(-1).call();
            }
        }

        public void click(int mx, int my) {
            int oneChar = MathHelper.ceil(Minecraft.getMinecraft().font.stringWidthDouble(" "));
            int cx = (mx - oneChar * 2) / oneChar;
            int cy = my / 12;
            @NotNull String @NotNull [] split = this.text.split("\n");
            int cursor = 0;
            for (int y = 0; y < cy; ++y) {
                cursor += split[y].length() + 1;
            }
            this.editor.setCursor(cursor += MathHelper.clamp(cx, 0, split[cy].length()));
        }

        public void handleInput(int key, char character) {
            boolean isMultiLine = this.text.contains("\n");
            if (key == Keyboard.KEY_TAB) {
                for (int i = 0; i < 4; ++i) {
                    this.editor.handleInput(0, ' ');
                }
            } else if (key == Keyboard.KEY_RETURN) {
                if (this.text.isEmpty()) {
                    return;
                }
                if (Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT)) {
                    this.editor.handleInput(key, '\n');
                } else {
                    @NotNull String line = this.text.trim();
                    @NotNull String @NotNull [] split = this.highlightedText.trim().split("\n");
                    @NotNull StringBuilder sb = new StringBuilder();
                    for (String s : split) {
                        sb.append(TextFormatting.LIGHT_GRAY).append("> ").append(TextFormatting.WHITE).append(s).append("\n");
                    }
                    LogMessageReceiver.append(sb.toString());
                    if (EXECUTOR != null) {
                        @NotNull String message = EXECUTOR.runCode(line);
                        LogMessageReceiver.append(message);
                    }
                    HISTORY.add(line);
                    this.historyIndex = 0;
                    this.editor.setText("");
                }
            } else if (key == Keyboard.KEY_HOME && isMultiLine) {
                int[] cursorPos = this.getCursor();
                int realPos = this.editor.getCursor();
                this.editor.setCursor(realPos -= cursorPos[0]);
            } else if (key == Keyboard.KEY_END && isMultiLine) {
                @NotNull String @NotNull [] split = this.text.split("\n", -1);
                int[] cursorPos = this.getCursor();
                int realPos = this.editor.getCursor();
                realPos -= cursorPos[0];
                this.editor.setCursor(realPos += split[cursorPos[1]].length());
            } else if (key == Keyboard.KEY_UP) {
                if (isMultiLine && !Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) && !Keyboard.isKeyDown(Keyboard.KEY_RSHIFT)) {
                    @NotNull String @NotNull [] split = this.text.split("\n", -1);
                    int[] cursorPos = this.getCursor();
                    if (cursorPos[1] == 0) {
                        return;
                    }
                    int realPos = this.editor.getCursor();
                    realPos -= cursorPos[0];
                    cursorPos[1] = cursorPos[1] - 1;
                    realPos -= split[cursorPos[1]].length() + 1;
                    cursorPos[0] = MathHelper.clamp(cursorPos[0], 0, split[cursorPos[1]].length());
                    this.editor.setCursor(realPos += cursorPos[0]);
                } else if (!HISTORY.isEmpty()) {
                    if (this.historyIndex == 0) {
                        this.originalText = this.getText();
                    }
                    if (this.historyIndex < HISTORY.size()) {
                        ++this.historyIndex;
                        this.setText(HISTORY.get(HISTORY.size() - this.historyIndex));
                    }
                    this.editor.setCursor(10000);
                }
            } else if (key == Keyboard.KEY_DOWN) {
                if (isMultiLine && !Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) && !Keyboard.isKeyDown(Keyboard.KEY_RSHIFT)) {
                    @NotNull String @NotNull [] split = this.text.split("\n", -1);
                    int[] cursorPos = this.getCursor();
                    if (cursorPos[1] == split.length - 1) {
                        return;
                    }
                    int realPos = this.editor.getCursor();
                    realPos -= cursorPos[0];
                    realPos += split[cursorPos[1]].length() + 1;
                    cursorPos[1] = cursorPos[1] + 1;
                    cursorPos[0] = MathHelper.clamp(cursorPos[0], 0, split[cursorPos[1]].length());
                    this.editor.setCursor(realPos += cursorPos[0]);
                } else if (this.historyIndex > 0) {
                    if (this.historyIndex - 1 == 0) {
                        --this.historyIndex;
                        this.setText(this.originalText);
                    } else {
                        --this.historyIndex;
                        this.setText(HISTORY.get(HISTORY.size() - this.historyIndex));
                    }
                    this.editor.setCursor(10000);
                }
            } else if (character != '`') {
                this.editor.handleInput(key, character);
            }
        }

        public int getHeightLines() {
            int c = 1;
            for (int i = 0; i < this.text.length(); ++i) {
                if (this.text.charAt(i) != '\n') continue;
                ++c;
            }
            return c;
        }

        @Override
        public void setText(@NotNull String text) {
            this.text = text;
            this.highlightedText = this.highlighter.highlight("java", text).getResult();
        }

        @Override
        @NotNull
        public String getText() {
            return this.text;
        }

        @Override
        public int maxLength() {
            return 1024;
        }

        private int @NotNull [] getCursor() {
            @NotNull String @NotNull [] split = this.text.split("\n", -1);
            int cursor = this.editor.getCursor();
            int cursorLine = 0;
            for (int i = 0; i < split.length; ++i) {
                if (cursor - (split[i].length() + 1) < 0) {
                    cursorLine = i;
                    break;
                }
                cursor -= split[i].length() + 1;
            }
            return new int[]{cursor, cursorLine};
        }
    }
}

