/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.Minecraft;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldTypes;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.weather.Weathers;
import org.jetbrains.annotations.NotNull;

public class PostProcessingManager {
    @NotNull
    private final Minecraft mc;
    @NotNull
    private final PostProcessingConfig oldCurrent = new PostProcessingConfig();
    @NotNull
    private final PostProcessingConfig current = new PostProcessingConfig();
    @NotNull
    public final PostProcessingConfig lerped = new PostProcessingConfig();
    public boolean enabled = true;
    private double lastTemperature = 0.0;
    private double lastHumidity = 0.0;

    public PostProcessingManager(@NotNull Minecraft mc) {
        this.mc = mc;
    }

    public void reset() {
        this.oldCurrent.set(this.current);
        this.current.reset();
    }

    public void tick() {
        double tt;
        double humidity;
        double temperature;
        if (this.mc.currentWorld == null || this.mc.thePlayer == null) {
            return;
        }
        this.reset();
        if (((Float)this.mc.gameSettings.colorCorrection.value).floatValue() == 0.0f) {
            return;
        }
        float y = (float)this.mc.thePlayer.y;
        int maxY = this.mc.currentWorld.getWorldType().getMaxY();
        int minY = this.mc.currentWorld.getWorldType().getMinY();
        int rangeY = maxY - minY;
        int halfY = minY + rangeY / 2;
        int quarterY = minY + rangeY / 4;
        int hToQRange = halfY - quarterY;
        float adjustedY = y - (float)quarterY;
        float surfaceness = adjustedY / (float)hToQRange;
        surfaceness = MathHelper.clamp(surfaceness, 0.0f, 1.0f);
        double t = this.mc.currentWorld.getBlockTemperature((int)this.mc.thePlayer.x, (int)this.mc.thePlayer.z);
        if (t == Double.NEGATIVE_INFINITY) {
            t = this.lastTemperature;
        }
        this.lastTemperature = temperature = t;
        double h = this.mc.currentWorld.getBlockHumidity((int)this.mc.thePlayer.x, (int)this.mc.thePlayer.z);
        if (h == Double.NEGATIVE_INFINITY) {
            h = this.lastHumidity;
        }
        this.lastHumidity = humidity = h;
        if (this.mc.currentWorld.dimension == Dimension.OVERWORLD) {
            this.lastTemperature = temperature;
            tt = temperature * 2.0 - 1.0;
            this.current.saturation += (float)(0.25 * tt * (double)surfaceness);
            this.current.contrast += (float)(-0.1 * tt * (double)surfaceness);
        }
        if (this.mc.currentWorld.dimension == Dimension.NETHER) {
            this.lastTemperature = temperature;
            if (temperature < 0.5) {
                tt = temperature * 2.0;
                this.current.saturation -= (float)(0.5 * (1.0 - tt));
            }
        }
        float seasonProgress = this.mc.currentWorld.getSeasonManager().getSeasonProgress();
        seasonProgress = seasonProgress * 2.0f - 1.0f;
        seasonProgress = Math.abs(seasonProgress);
        seasonProgress = -seasonProgress + 1.0f;
        if (this.mc.currentWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SPRING) {
            this.current.saturation += 0.1f * seasonProgress * surfaceness;
        } else if (this.mc.currentWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SUMMER) {
            this.current.rMod += 0.1f * seasonProgress * surfaceness;
            this.current.gMod += 0.1f * seasonProgress * surfaceness;
        } else if (this.mc.currentWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_FALL) {
            this.current.contrast -= 0.1f * seasonProgress * surfaceness;
            this.current.rMod += 0.1f * seasonProgress * surfaceness;
        } else if (this.mc.currentWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_WINTER) {
            this.current.contrast -= 0.1f * seasonProgress * surfaceness;
            this.current.bMod += 0.1f * seasonProgress * surfaceness;
        }
        Weather activeWeather = this.mc.currentWorld.getCurrentWeather();
        if (activeWeather != null) {
            float intensity = this.mc.currentWorld.weatherManager.getWeatherIntensity() * this.mc.currentWorld.weatherManager.getWeatherIntensity();
            if (activeWeather == Weathers.OVERWORLD_SNOW || activeWeather == Weathers.OVERWORLD_WINTER_SNOW) {
                this.current.contrast += -0.125f * intensity * surfaceness;
                this.current.saturation += -0.25f * intensity * surfaceness;
                this.current.bMod += 0.25f * intensity * surfaceness;
            } else if (activeWeather == Weathers.OVERWORLD_RAIN_BLOOD) {
                this.current.rMod += 0.4f * intensity * surfaceness;
                this.current.gMod += 0.1f * intensity * surfaceness;
                this.current.saturation += 0.125f * intensity * surfaceness;
                this.current.exposure -= 0.125f * intensity * surfaceness;
            } else if (activeWeather == Weathers.OVERWORLD_RAIN) {
                this.current.bMod += 0.1f * intensity * surfaceness;
                this.current.saturation += -0.125f * intensity * surfaceness;
                this.current.brightness += -0.0625f * intensity * surfaceness;
            } else if (activeWeather == Weathers.OVERWORLD_STORM) {
                this.current.bMod += 0.1f * intensity * surfaceness;
                this.current.saturation += -0.2f * intensity * surfaceness;
                this.current.brightness += -0.1f * intensity * surfaceness;
            } else if (activeWeather == Weathers.OVERWORLD_FOG && ((Boolean)this.mc.gameSettings.fog.value).booleanValue()) {
                this.current.saturation += -0.4f * intensity * surfaceness;
                this.current.contrast += -0.25f * intensity * surfaceness;
            }
        }
        if (this.mc.currentWorld.dimension == Dimension.NETHER || this.mc.currentWorld.getWorldType() == WorldTypes.OVERWORLD_HELL) {
            float scale = 1.0f;
            if (this.mc.currentWorld.dimension == Dimension.NETHER && temperature < 0.5) {
                scale = (float)temperature * 2.0f;
            }
            this.current.rMod += 1.2f * scale;
            this.current.gMod += 0.3f * scale;
            this.current.saturation += 0.125f * scale;
            this.current.exposure -= 0.125f;
            this.current.contrast -= 0.05f;
            this.current.brightness -= 0.05f;
            this.current.heatHaze = scale;
        }
        if (this.mc.currentWorld.dimension == Dimension.OVERWORLD && (this.mc.currentWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_SUMMER || this.mc.currentWorld.getSeasonManager().getCurrentSeason() == Seasons.OVERWORLD_FALL) && temperature >= 0.85 && humidity <= 0.15) {
            double tPercentage = (temperature - 0.85) / 0.15;
            double hPercentage = 1.0 - humidity / 0.15;
            double percentage = tPercentage * hPercentage;
            percentage = MathHelper.clamp(percentage, 0.0, 1.0);
            this.current.heatHaze = (float)percentage;
        }
        if (((Float)this.mc.gameSettings.colorCorrection.value).floatValue() != 0.0f) {
            this.current.brightness *= ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.current.contrast *= ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.current.exposure *= ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.current.saturation *= ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.current.rMod = 1.0f - (1.0f - this.current.rMod) * ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.current.gMod = 1.0f - (1.0f - this.current.gMod) * ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
            this.current.bMod = 1.0f - (1.0f - this.current.bMod) * ((Float)this.mc.gameSettings.colorCorrection.value).floatValue();
        }
        this.current.brightness = PostProcessingManager.smoothLerp(this.oldCurrent.brightness, this.current.brightness);
        this.current.contrast = PostProcessingManager.smoothLerp(this.oldCurrent.contrast, this.current.contrast);
        this.current.exposure = PostProcessingManager.smoothLerp(this.oldCurrent.exposure, this.current.exposure);
        this.current.saturation = PostProcessingManager.smoothLerp(this.oldCurrent.saturation, this.current.saturation);
        this.current.rMod = PostProcessingManager.smoothLerp(this.oldCurrent.rMod, this.current.rMod);
        this.current.gMod = PostProcessingManager.smoothLerp(this.oldCurrent.gMod, this.current.gMod);
        this.current.bMod = PostProcessingManager.smoothLerp(this.oldCurrent.bMod, this.current.bMod);
        this.current.heatHaze = PostProcessingManager.smoothLerp(this.oldCurrent.heatHaze, this.current.heatHaze);
    }

    public void render(float partialTick) {
        this.lerped.brightness = this.oldCurrent.brightness + (this.current.brightness - this.oldCurrent.brightness) * partialTick;
        this.lerped.contrast = this.oldCurrent.contrast + (this.current.contrast - this.oldCurrent.contrast) * partialTick;
        this.lerped.exposure = this.oldCurrent.exposure + (this.current.exposure - this.oldCurrent.exposure) * partialTick;
        this.lerped.saturation = this.oldCurrent.saturation + (this.current.saturation - this.oldCurrent.saturation) * partialTick;
        this.lerped.rMod = this.oldCurrent.rMod + (this.current.rMod - this.oldCurrent.rMod) * partialTick;
        this.lerped.gMod = this.oldCurrent.gMod + (this.current.gMod - this.oldCurrent.gMod) * partialTick;
        this.lerped.bMod = this.oldCurrent.bMod + (this.current.bMod - this.oldCurrent.bMod) * partialTick;
        this.lerped.heatHaze = this.oldCurrent.heatHaze + (this.current.heatHaze - this.oldCurrent.heatHaze) * partialTick;
    }

    private static float smoothLerp(float oldValue, float newValue) {
        return oldValue + (newValue - oldValue) * 0.05f;
    }

    public static class PostProcessingConfig {
        public float brightness = 0.0f;
        public float contrast = 0.0f;
        public float exposure = 0.0f;
        public float saturation = 0.0f;
        public float rMod = 1.0f;
        public float gMod = 1.0f;
        public float bMod = 1.0f;
        public float heatHaze = 0.0f;

        public void reset() {
            this.brightness = 0.0f;
            this.contrast = 0.0f;
            this.exposure = 0.0f;
            this.saturation = 0.0f;
            this.rMod = 1.0f;
            this.gMod = 1.0f;
            this.bMod = 1.0f;
            this.heatHaze = 0.0f;
        }

        public void set(@NotNull PostProcessingConfig config) {
            this.brightness = config.brightness;
            this.contrast = config.contrast;
            this.exposure = config.exposure;
            this.saturation = config.saturation;
            this.rMod = config.rMod;
            this.gMod = config.gMod;
            this.bMod = config.bMod;
            this.heatHaze = config.heatHaze;
        }
    }
}

