/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;

public class BlockModelStoneMossy<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected IconCoordinate mossOverlay = TextureRegistry.getTexture("minecraft:block/moss_overlay");

    public BlockModelStoneMossy(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        AABBdc bounds = this.block.getBoundsFromState(worldSource, tilePos);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f);
        BlockModelStoneMossy.renderBlocks.overrideBlockTexture = this.mossOverlay;
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        BlockModelStoneMossy.renderBlocks.overrideBlockTexture = null;
        return true;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        BlockModelStoneMossy.renderBlocks.useInventoryTint = false;
        super.renderStandalone(tessellator, metadata, lightmapCoord);
        BlockModelStoneMossy.renderBlocks.useInventoryTint = true;
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata, 0);
        AABBdc bounds = this.block.getBounds();
        IconCoordinate mossCoord = this.mossOverlay;
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        tessellator.startDrawingQuads();
        tessellator.setColor1i(color);
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, mossCoord);
        tessellator.draw();
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }
}

