/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenPhotoMode;
import net.minecraft.client.option.enums.Colorblindness;
import net.minecraft.client.render.camera.CameraUtil;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.shader.Shader;
import net.minecraft.client.render.tessellator.RenderBuffer;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.ItemStack;
import org.lwjgl.opengl.GL41;

public final class ShaderHelper {
    private static RenderBuffer fullScreenRect = null;
    private static final long startTime = System.currentTimeMillis();
    private static float frameTimeCounter = 0.0f;

    private ShaderHelper() {
    }

    public static void drawFullscreenRect() {
        if (fullScreenRect == null) {
            int vao = GL41.glGenVertexArrays();
            int vbo = GL41.glGenBuffers();
            float[] quadVertices = new float[]{-1.0f, 1.0f, 0.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 0.0f};
            GL41.glBindVertexArray(vao);
            GL41.glBindBuffer(34962, vbo);
            GL41.glBufferData(34962, quadVertices, 35044);
            GL41.glVertexAttribPointer(0, 2, 5126, false, 16, 0L);
            GL41.glVertexAttribPointer(1, 2, 5126, false, 16, 8L);
            GL41.glEnableVertexAttribArray(0);
            GL41.glEnableVertexAttribArray(1);
            GL41.glBindVertexArray(0);
            fullScreenRect = new RenderBuffer(vao, vbo, 0, 6, DrawMode.TRIANGLES);
        }
        GLRenderer.disableState(State.BLEND);
        GLRenderer.disableState(State.DEPTH_TEST);
        GLRenderer.disableState(State.CULL_FACE);
        GLRenderer.disableState(State.SCISSOR_TEST);
        GL41.glBindVertexArray(fullScreenRect.vao());
        GL41.glDrawArrays(5, 0, 4);
        GL41.glBindVertexArray(0);
    }

    public static void setUniforms(Minecraft minecraft, Shader shader, float partialTicks) {
        long now = System.currentTimeMillis();
        int passedTime = (int)(now - startTime);
        frameTimeCounter = (float)passedTime / 1000.0f;
        if (!shader.isEnabled()) {
            return;
        }
        shader.bind();
        shader.uniformFloat("width", minecraft.gameWindow.getWidthPixels());
        shader.uniformFloat("height", minecraft.gameWindow.getHeightPixels());
        shader.uniformFloat("frameTimeCounter", frameTimeCounter);
        shader.uniformFloat("gamma", ((Float)minecraft.gameSettings.gamma.value).floatValue());
        shader.uniformFloat("fxaa", ((Float)minecraft.gameSettings.fxaa.value).floatValue());
        shader.uniformFloat("heatHaze", (Boolean)minecraft.gameSettings.heatHaze.value != false ? minecraft.ppm.lerped.heatHaze : 0.0f);
        shader.uniformInt("bloom", (Integer)minecraft.gameSettings.bloom.value);
        shader.uniformInt("dimension", minecraft.currentWorld != null && minecraft.currentWorld.dimension != null ? minecraft.currentWorld.dimension.id : 0);
        shader.uniformInt("cbCorrectionMode", ((Colorblindness)((Object)minecraft.gameSettings.colorblindnessFix.value)).ordinal());
        ItemStack helmet = minecraft.thePlayer == null ? null : minecraft.thePlayer.getItemInArmorSlot(HumanArmorShape.HEAD);
        shader.uniformInt("shaderEffect", helmet != null && helmet.itemID == Blocks.PUMPKIN_REDSTONE.id() ? 1 : 0);
        int isEyeInLiquid = 0;
        float celestialAngle = 0.0f;
        if (minecraft.thePlayer != null && minecraft.currentWorld != null && minecraft.activeCamera != null) {
            if (CameraUtil.isUnderLiquid(minecraft.activeCamera, minecraft.currentWorld, Materials.LAVA, partialTicks)) {
                isEyeInLiquid = 2;
            } else if (CameraUtil.isUnderLiquid(minecraft.activeCamera, minecraft.currentWorld, Materials.WATER, partialTicks)) {
                isEyeInLiquid = 1;
            }
            celestialAngle = minecraft.currentWorld.getCelestialAngle(partialTicks);
        }
        shader.uniformInt("isEyeInLiquid", isEyeInLiquid);
        shader.uniformFloat("celestialAngle", celestialAngle);
        if (minecraft.ppm.enabled) {
            shader.uniformFloat("brightness", minecraft.ppm.lerped.brightness);
            shader.uniformFloat("contrast", minecraft.ppm.lerped.contrast);
            shader.uniformFloat("exposure", minecraft.ppm.lerped.exposure);
            shader.uniformFloat("saturation", minecraft.ppm.lerped.saturation);
            shader.uniformFloat("rMod", minecraft.ppm.lerped.rMod);
            shader.uniformFloat("gMod", minecraft.ppm.lerped.gMod);
            shader.uniformFloat("bMod", minecraft.ppm.lerped.bMod);
        } else {
            shader.uniformFloat("brightness", 0.0f);
            shader.uniformFloat("contrast", 0.0f);
            shader.uniformFloat("exposure", 0.0f);
            shader.uniformFloat("saturation", 0.0f);
            shader.uniformFloat("rMod", 1.0f);
            shader.uniformFloat("gMod", 1.0f);
            shader.uniformFloat("bMod", 1.0f);
        }
        shader.uniformFloat("photoMode", minecraft.currentScreen instanceof ScreenPhotoMode);
        shader.uniformFloat("guiOpened", minecraft.currentScreen != null);
        Screen screen = minecraft.currentScreen;
        if (screen instanceof ScreenPhotoMode) {
            ScreenPhotoMode screenPhotoMode = (ScreenPhotoMode)screen;
            shader.uniformFloat("intensity", screenPhotoMode.intensityValue);
        } else {
            shader.uniformFloat("intensity", 1.0f);
        }
    }
}

