/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import java.util.Random;
import net.minecraft.core.world.noise.LegacyNoiseType;
import org.jetbrains.annotations.NotNull;

public class ImprovedNoise {
    @NotNull
    private final LegacyNoiseType legacyNoiseType;
    private final int @NotNull [] p;
    public final double xo;
    public final double yo;
    public final double zo;

    public ImprovedNoise(@NotNull Random random) {
        this(random, LegacyNoiseType.DEFAULT);
    }

    public ImprovedNoise(@NotNull Random random, @NotNull LegacyNoiseType legacyNoiseType) {
        int i;
        this.legacyNoiseType = legacyNoiseType;
        this.p = new int[512];
        this.xo = random.nextDouble() * 256.0;
        this.yo = random.nextDouble() * 256.0;
        this.zo = random.nextDouble() * 256.0;
        for (i = 0; i < 256; ++i) {
            this.p[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int newI = random.nextInt(256 - i) + i;
            int temp = this.p[i];
            this.p[i] = this.p[newI];
            this.p[newI] = temp;
            this.p[i + 256] = this.p[i];
        }
    }

    public double getValue(double x, double z) {
        return this.getValue(x, z, 0.0);
    }

    public double getValue(double x, double y, double z) {
        int X = (int)Math.floor(x) & 0xFF;
        int Y = (int)Math.floor(y) & 0xFF;
        int Z = (int)Math.floor(z) & 0xFF;
        x -= Math.floor(x);
        y -= Math.floor(y);
        z -= Math.floor(z);
        double u = this.fade(x);
        double v = this.fade(y);
        double w = this.fade(z);
        int A = this.p[X] + Y;
        int AA = this.p[A] + Z;
        int AB = this.p[A + 1] + Z;
        int B = this.p[X + 1] + Y;
        int BA = this.p[B] + Z;
        int BB = this.p[B + 1] + Z;
        return this.lerp(w, this.lerp(v, this.lerp(u, this.grad(this.p[AA], x, y, z), this.grad(this.p[BA], x - 1.0, y, z)), this.lerp(u, this.grad(this.p[AB], x, y - 1.0, z), this.grad(this.p[BB], x - 1.0, y - 1.0, z))), this.lerp(v, this.lerp(u, this.grad(this.p[AA + 1], x, y, z - 1.0), this.grad(this.p[BA + 1], x - 1.0, y, z - 1.0)), this.lerp(u, this.grad(this.p[AB + 1], x, y - 1.0, z - 1.0), this.grad(this.p[BB + 1], x - 1.0, y - 1.0, z - 1.0))));
    }

    protected double grad2(int hash, double x, double y) {
        int h = hash & 0xF;
        double u = (double)(1 - ((h & 8) >> 3)) * x;
        double v = h < 4 ? 0.0 : (h == 12 || h == 14 ? x : y);
        return ((h & 1) != 0 ? -u : u) + ((h & 2) != 0 ? -v : v);
    }

    protected double fade(double t) {
        return t * t * t * (t * (t * 6.0 - 15.0) + 10.0);
    }

    protected double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    protected double grad(int hash, double x, double y, double z) {
        double u;
        int h = hash & 0xF;
        double d = u = h < 8 ? x : y;
        double v = h < 4 ? y : (h == 12 || h == 14 ? x : z);
        return ((h & 1) == 0 ? u : -u) + ((h & 2) == 0 ? v : -v);
    }

    public void add(double @NotNull [] out, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double amplitude) {
        if (ySize == 1 && this.legacyNoiseType.handleEdgeCaseY) {
            int i = 0;
            for (int xi = 0; xi < xSize; ++xi) {
                double xx = (x + (double)xi) * xScale + this.xo;
                int X = (int)Math.floor(xx) & 0xFF;
                xx -= Math.floor(xx);
                double u = this.fade(xx);
                for (int zi = 0; zi < zSize; ++zi) {
                    double zz = (z + (double)zi) * zScale + this.zo;
                    int Z = (int)Math.floor(zz) & 0xFF;
                    zz -= Math.floor(zz);
                    double w = this.fade(zz);
                    int A = this.p[X];
                    int AA = this.p[A] + Z;
                    int B = this.p[X + 1];
                    int BA = this.p[B] + Z;
                    double value = this.lerp(w, this.lerp(u, this.grad2(this.p[AA], xx, zz), this.grad(this.p[BA], xx - 1.0, 0.0, zz)), this.lerp(u, this.grad(this.p[AA + 1], xx, 0.0, zz - 1.0), this.grad(this.p[BA + 1], xx - 1.0, 0.0, zz - 1.0)));
                    int n = i++;
                    out[n] = out[n] + value * amplitude;
                }
            }
        } else if (zSize == 1 && this.legacyNoiseType.handleEdgeCaseZ) {
            int i = 0;
            for (int xi = 0; xi < xSize; ++xi) {
                double xx = (x + (double)xi) * xScale + this.xo;
                int X = (int)Math.floor(xx) & 0xFF;
                xx -= Math.floor(xx);
                double u = this.fade(xx);
                for (int yi = 0; yi < ySize; ++yi) {
                    double yy = (y + (double)yi) * yScale + this.zo;
                    int Y = (int)Math.floor(yy) & 0xFF;
                    yy -= Math.floor(yy);
                    double v = this.fade(yy);
                    int A = this.p[X];
                    int AA = this.p[A] + Y;
                    int B = this.p[X + 1];
                    int BA = this.p[B] + Y;
                    double value = this.lerp(v, this.lerp(u, this.grad2(this.p[AA], xx, yy), this.grad(this.p[BA], xx - 1.0, 0.0, yy)), this.lerp(u, this.grad(this.p[AA + 1], xx, 0.0, yy - 1.0), this.grad(this.p[BA + 1], xx - 1.0, 0.0, yy - 1.0)));
                    int n = i++;
                    out[n] = out[n] + value * amplitude;
                }
            }
        } else {
            double lerpedX = 0.0;
            double lerpedXNegY = 0.0;
            double lerpedXNegZ = 0.0;
            double lerpedXNegYNegZ = 0.0;
            int i = 0;
            int lastY = -1;
            for (int xi = 0; xi < xSize; ++xi) {
                double xx = (x + (double)xi) * xScale + this.xo;
                int X = (int)Math.floor(xx) & 0xFF;
                xx -= Math.floor(xx);
                double u = this.fade(xx);
                for (int zi = 0; zi < zSize; ++zi) {
                    double zz = (z + (double)zi) * zScale + this.zo;
                    int Z = (int)Math.floor(zz) & 0xFF;
                    zz -= Math.floor(zz);
                    double w = this.fade(zz);
                    for (int yi = 0; yi < ySize; ++yi) {
                        double yy = (y + (double)yi) * yScale + this.yo;
                        int Y = (int)Math.floor(yy) & 0xFF;
                        yy -= Math.floor(yy);
                        double v = this.fade(yy);
                        if (yi == 0 || Y != lastY) {
                            lastY = Y;
                            int A = this.p[X] + Y;
                            int AA = this.p[A] + Z;
                            int AB = this.p[A + 1] + Z;
                            int B = this.p[X + 1] + Y;
                            int BA = this.p[B] + Z;
                            int BB = this.p[B + 1] + Z;
                            lerpedX = this.lerp(u, this.grad(this.p[AA], xx, yy, zz), this.grad(this.p[BA], xx - 1.0, yy, zz));
                            lerpedXNegY = this.lerp(u, this.grad(this.p[AB], xx, yy - 1.0, zz), this.grad(this.p[BB], xx - 1.0, yy - 1.0, zz));
                            lerpedXNegZ = this.lerp(u, this.grad(this.p[AA + 1], xx, yy, zz - 1.0), this.grad(this.p[BA + 1], xx - 1.0, yy, zz - 1.0));
                            lerpedXNegYNegZ = this.lerp(u, this.grad(this.p[AB + 1], xx, yy - 1.0, zz - 1.0), this.grad(this.p[BB + 1], xx - 1.0, yy - 1.0, zz - 1.0));
                        }
                        double lerpedXY = this.lerp(v, lerpedX, lerpedXNegY);
                        double lerpedXYNegZ = this.lerp(v, lerpedXNegZ, lerpedXNegYNegZ);
                        double lerpedXYZ = this.lerp(w, lerpedXY, lerpedXYNegZ);
                        int n = i++;
                        out[n] = out[n] + lerpedXYZ * amplitude;
                    }
                }
            }
        }
    }
}

