/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.hud.component.HudComponent;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.HudComponents;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.gui.hud.component.layout.LayoutAbsolute;
import net.minecraft.client.gui.hud.component.layout.LayoutSnap;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;

public class ScreenHudDesigner
extends Screen {
    private static final int BOTTOM_SPACE = 28;
    private final List<HudComponent> componentsUnderMouse = new ArrayList<HudComponent>();
    private HudComponent heldComponent = null;
    private ComponentAnchor heldAnchor = ComponentAnchor.TOP_LEFT;
    private HudComponent snappedComponent = null;
    private ComponentAnchor snappedAnchor = null;
    private float screenPadding = 0.0f;
    private ButtonElement resetButton;

    public ScreenHudDesigner(Screen parent) {
        super(parent);
    }

    @Override
    public void init() {
        super.init();
        this.screenPadding = ((Float)this.mc.gameSettings.screenPadding.value).floatValue();
        this.mc.gameSettings.screenPadding.set(Float.valueOf(0.0f));
        this.add(new ButtonElement(0, this.width / 2 - 100, this.height - 28 + 4, 178, 20, I18n.getInstance().translateKey("gui.hud_designer.button.done")));
        this.resetButton = new ButtonElement(1, this.width / 2 + 80, this.height - 28 + 4, 20, 20, "").setTextures("minecraft:gui/misc/button_reset", "minecraft:gui/misc/button_reset_highlighted", "minecraft:gui/misc/button_reset");
        this.add(this.resetButton);
    }

    @Override
    public void removed() {
        super.removed();
        this.mc.gameSettings.screenPadding.set(Float.valueOf(this.screenPadding));
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        super.buttonClicked(button);
        if (button.id == 0) {
            this.mc.displayScreen(this.getParentScreen());
        }
        if (button.id == 1) {
            HudComponents.INSTANCE.fromSettingsString(HudComponents.DEFAULT_LAYOUT);
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        HudComponent componentUnderMouse;
        this.updateComponentsUnderMouse(mx, my);
        boolean clickedComponent = false;
        if (buttonNum == 0 && !this.componentsUnderMouse.isEmpty() && (componentUnderMouse = this.componentsUnderMouse.get(this.componentsUnderMouse.size() - 1)) instanceof HudComponentMovable) {
            Layout currentLayout = componentUnderMouse.getLayout();
            ComponentAnchor anchor = this.getClosestAnchor(currentLayout.getComponentX(componentUnderMouse, this.width), currentLayout.getComponentY(componentUnderMouse, this.height - 28), componentUnderMouse, mx, my);
            LayoutAbsolute layout = new LayoutAbsolute(0.0f, 0.0f, anchor);
            ((HudComponentMovable)componentUnderMouse).setLayout(layout);
            this.heldComponent = componentUnderMouse;
            this.heldAnchor = anchor;
            clickedComponent = true;
        }
        if (!clickedComponent) {
            this.heldComponent = null;
            super.mouseClicked(mx, my, buttonNum);
        }
    }

    private void updateHeldComponent(int mouseX, int mouseY) {
        if (this.heldComponent == null) {
            return;
        }
        int xSize = this.heldComponent.getXSize();
        int ySize = this.heldComponent.getYSize();
        int xOffset = this.heldComponent.getAnchorX(this.heldAnchor);
        int yOffset = this.heldComponent.getAnchorY(this.heldAnchor);
        int newX = MathHelper.clamp(mouseX, xOffset, this.width - (xSize - xOffset));
        int newY = MathHelper.clamp(mouseY, yOffset, this.height - 28 - (ySize - yOffset));
        Layout layout = this.heldComponent.getLayout();
        if (layout instanceof LayoutAbsolute) {
            LayoutAbsolute absoluteLayout = (LayoutAbsolute)layout;
            absoluteLayout.setXPosition((float)newX / (float)this.width);
            absoluteLayout.setYPosition((float)newY / (float)(this.height - 28));
        }
        int snapRadius = 10;
        boolean didSnap = false;
        for (HudComponent component : HudComponents.INSTANCE.getComponents()) {
            ComponentAnchor anchor;
            if (component == this.heldComponent || !component.isEnabled()) continue;
            Layout otherLayout = component.getLayout();
            boolean isNested = false;
            Layout nestedLayout = otherLayout;
            for (int i = 0; i < 10 && nestedLayout instanceof LayoutSnap; ++i) {
                LayoutSnap layoutSnap = (LayoutSnap)nestedLayout;
                if (layoutSnap.getParent() == this.heldComponent) {
                    isNested = true;
                    break;
                }
                if (layoutSnap.getParent() == null) break;
                nestedLayout = layoutSnap.getParent().getLayout();
            }
            if (isNested) continue;
            int x = otherLayout.getComponentX(component, this.width);
            int y = otherLayout.getComponentY(component, this.height - 28);
            int mouseDistance = (int)Math.sqrt(Math.pow(mouseX - newX, 2.0) + Math.pow(mouseY - newY, 2.0));
            if (mouseDistance >= 10 || (anchor = this.getAnchorInRadius(x, y, component, newX, newY, snapRadius)) == null || !this.heldAnchor.canConnectTo(anchor)) continue;
            this.snappedComponent = component;
            this.snappedAnchor = anchor;
            LayoutSnap newLayout = new LayoutSnap(component, anchor, this.heldAnchor);
            ((HudComponentMovable)this.heldComponent).setLayout(newLayout);
            didSnap = true;
            break;
        }
        if (!didSnap) {
            Layout newLayout;
            snapRadius = 20;
            ComponentAnchor anchor = this.getScreenAnchorInRadius(0, 0, newX, newY, snapRadius);
            if (anchor != null) {
                this.snappedComponent = null;
                this.snappedAnchor = anchor;
                newLayout = new LayoutSnap(null, this.snappedAnchor, this.heldAnchor);
                ((HudComponentMovable)this.heldComponent).setLayout(newLayout);
                didSnap = true;
            }
            if (!didSnap) {
                newLayout = new LayoutAbsolute((float)newX / (float)this.width, (float)newY / (float)(this.height - 28), this.heldAnchor);
                ((HudComponentMovable)this.heldComponent).setLayout(newLayout);
                this.snappedComponent = null;
                this.snappedAnchor = null;
            }
        }
    }

    private ComponentAnchor getClosestAnchor(int x, int y, HudComponent component, int mouseX, int mouseY) {
        ComponentAnchor anchor = ComponentAnchor.TOP_LEFT;
        int minDistance = Integer.MAX_VALUE;
        for (ComponentAnchor componentAnchor : ComponentAnchor.values()) {
            if (componentAnchor == ComponentAnchor.CENTER) continue;
            int xAnchor = component.getAnchorX(componentAnchor);
            int yAnchor = component.getAnchorY(componentAnchor);
            int distance = (int)Math.sqrt(Math.pow(mouseX - (x + xAnchor), 2.0) + Math.pow(mouseY - (y + yAnchor), 2.0));
            if (distance >= minDistance) continue;
            minDistance = distance;
            anchor = componentAnchor;
        }
        return anchor;
    }

    private ComponentAnchor getAnchorInRadius(int x, int y, HudComponent component, int mouseX, int mouseY, int radius) {
        ComponentAnchor anchor = null;
        int minDistance = Integer.MAX_VALUE;
        for (ComponentAnchor componentAnchor : ComponentAnchor.values()) {
            if (componentAnchor == ComponentAnchor.CENTER) continue;
            int xAnchor = component.getAnchorX(componentAnchor);
            int yAnchor = component.getAnchorY(componentAnchor);
            int distance = (int)Math.sqrt(Math.pow(mouseX - (x + xAnchor), 2.0) + Math.pow(mouseY - (y + yAnchor), 2.0));
            if (distance >= minDistance || distance > radius) continue;
            minDistance = distance;
            anchor = componentAnchor;
        }
        return anchor;
    }

    private ComponentAnchor getScreenAnchorInRadius(int x, int y, int mouseX, int mouseY, int radius) {
        ComponentAnchor anchor = null;
        int minDistance = Integer.MAX_VALUE;
        for (ComponentAnchor componentAnchor : ComponentAnchor.values()) {
            if (componentAnchor == ComponentAnchor.CENTER) continue;
            int xAnchor = (int)(componentAnchor.xPosition * (float)this.width);
            int yAnchor = (int)(componentAnchor.yPosition * (float)(this.height - 28));
            int distance = (int)Math.sqrt(Math.pow(mouseX - (x + xAnchor), 2.0) + Math.pow(mouseY - (y + yAnchor), 2.0));
            if (distance >= minDistance || distance > radius) continue;
            minDistance = distance;
            anchor = componentAnchor;
        }
        return anchor;
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        if (buttonNum == 0) {
            this.heldComponent = null;
            this.heldAnchor = null;
            this.snappedComponent = null;
            this.snappedAnchor = null;
        }
        super.mouseReleased(mx, my, buttonNum);
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        this.updateComponentsUnderMouse(mx, my);
        if (this.heldComponent != null) {
            this.updateHeldComponent(mx, my);
        }
        this.renderTexturedBackground();
        this.drawHudComponents(mx, my);
        TessellatorShader tessellator = GLRenderer.getTessellator();
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.COLOR);
        GLRenderer.disableState(State.DEPTH_TEST);
        tessellator.startDrawingQuads();
        tessellator.setColor2i(0, 255);
        tessellator.addVertexWithUV(0.0, this.height - 28 + 1, 0.0, 0.0, 1.0);
        tessellator.addVertexWithUV(this.width, this.height - 28 + 1, 0.0, 1.0, 1.0);
        tessellator.addVertexWithUV(this.width, this.height - 28, 0.0, 1.0, 0.0);
        tessellator.addVertexWithUV(0.0, this.height - 28, 0.0, 0.0, 0.0);
        tessellator.draw();
        GLRenderer.popFrame();
        if (this.heldComponent != null) {
            for (ComponentAnchor anchor : ComponentAnchor.values()) {
                if (anchor == ComponentAnchor.CENTER) continue;
                this.drawAnchor(0, 0, (int)((float)this.width * anchor.xPosition), (int)((float)(this.height - 28) * anchor.yPosition), anchor);
            }
        }
        super.render(mx, my, partialTick);
    }

    @Override
    public void renderTexturedBackground() {
        super.renderTexturedBackground();
        GLRenderer.globalSetLightEnabled(false);
        TessellatorShader tessellator = GLRenderer.getTessellator();
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/designer_bg.png").bind();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        float scale = 32.0f;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(0.0, this.height - 28, 0.0, 0.0, (float)(this.height - 28) / scale);
        tessellator.addVertexWithUV(this.width, this.height - 28, 0.0, (float)this.width / scale, (float)(this.height - 28) / scale);
        tessellator.addVertexWithUV(this.width, 0.0, 0.0, (float)this.width / scale, 0.0);
        tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
        tessellator.draw();
    }

    private void drawHudComponents(int mouseX, int mouseY) {
        Layout layout;
        HudComponent lastComponent = null;
        if (!this.componentsUnderMouse.isEmpty()) {
            lastComponent = this.componentsUnderMouse.get(this.componentsUnderMouse.size() - 1);
        }
        for (HudComponent component : HudComponents.INSTANCE.getComponents()) {
            if (component == this.heldComponent || !component.isEnabled()) continue;
            Layout layout2 = component.getLayout();
            GLRenderer.pushFrame();
            component.renderPreview(this, layout2, this.width, this.height - 28);
            GLRenderer.popFrame();
            if (this.heldComponent != null || this.componentsUnderMouse.isEmpty() || component != lastComponent) continue;
            int x = layout2.getComponentX(component, this.width);
            int y = layout2.getComponentY(component, this.height - 28);
            int xSize = component.getXSize();
            int ySize = component.getYSize();
            this.drawBox(x, y, x + xSize, y + ySize, -16711936, 1);
            ComponentAnchor anchor = this.getClosestAnchor(x, y, component, mouseX, mouseY);
            int xAnchor = component.getAnchorX(anchor);
            int yAnchor = component.getAnchorY(anchor);
            this.drawAnchor(x, y, xAnchor, yAnchor, anchor);
        }
        if (this.heldComponent != null) {
            layout = this.heldComponent.getLayout();
            GLRenderer.pushFrame();
            this.heldComponent.renderPreview(this, layout, this.width, this.height - 28);
            GLRenderer.popFrame();
            int x = layout.getComponentX(this.heldComponent, this.width);
            int y = layout.getComponentY(this.heldComponent, this.height - 28);
            int xSize = this.heldComponent.getXSize();
            int ySize = this.heldComponent.getYSize();
            int xAnchor = this.heldComponent.getAnchorX(this.heldAnchor);
            int yAnchor = this.heldComponent.getAnchorY(this.heldAnchor);
            this.drawBox(x, y, x + xSize, y + ySize, -65536, 1);
            this.drawAnchor(x, y, xAnchor, yAnchor, this.heldAnchor);
        }
        if (this.snappedComponent != null && this.snappedAnchor != null) {
            layout = this.snappedComponent.getLayout();
            int x = layout.getComponentX(this.snappedComponent, this.width);
            int y = layout.getComponentY(this.snappedComponent, this.height - 28);
            int xAnchor = this.snappedComponent.getAnchorX(this.snappedAnchor);
            int yAnchor = this.snappedComponent.getAnchorY(this.snappedAnchor);
            this.drawAnchor(x, y, xAnchor, yAnchor, this.snappedAnchor);
        }
    }

    private void drawAnchor(int x, int y, int xAnchor, int yAnchor, ComponentAnchor anchor) {
        int color = -16776961;
        int lineLength = 5;
        GLRenderer.pushFrame();
        GLRenderer.disableState(State.DEPTH_TEST);
        switch (anchor) {
            case TOP_LEFT: {
                this.drawRect(x + xAnchor, y + yAnchor, x + xAnchor + lineLength, y + yAnchor + 1, color);
                this.drawRect(x + xAnchor, y + yAnchor, x + xAnchor + 1, y + yAnchor + lineLength, color);
                break;
            }
            case TOP_CENTER: {
                this.drawRect(x + xAnchor - lineLength, y + yAnchor, x + xAnchor + lineLength, y + yAnchor + 1, color);
                this.drawRect(x + xAnchor, y + yAnchor, x + xAnchor + 1, y + yAnchor + lineLength, color);
                break;
            }
            case TOP_RIGHT: {
                this.drawRect(x + xAnchor - lineLength, y + yAnchor, x + xAnchor, y + yAnchor + 1, color);
                this.drawRect(x + xAnchor - 1, y + yAnchor, x + xAnchor, y + yAnchor + lineLength, color);
                break;
            }
            case CENTER_LEFT: {
                this.drawRect(x + xAnchor, y + yAnchor, x + xAnchor + lineLength, y + yAnchor + 1, color);
                this.drawRect(x + xAnchor, y + yAnchor - lineLength, x + xAnchor + 1, y + yAnchor + lineLength, color);
                break;
            }
            case CENTER_RIGHT: {
                this.drawRect(x + xAnchor - lineLength, y + yAnchor, x + xAnchor, y + yAnchor + 1, color);
                this.drawRect(x + xAnchor - 1, y + yAnchor - lineLength, x + xAnchor, y + yAnchor + lineLength, color);
                break;
            }
            case BOTTOM_LEFT: {
                this.drawRect(x + xAnchor, y + yAnchor - 1, x + xAnchor + lineLength, y + yAnchor, color);
                this.drawRect(x + xAnchor, y + yAnchor - lineLength, x + xAnchor + 1, y + yAnchor, color);
                break;
            }
            case BOTTOM_CENTER: {
                this.drawRect(x + xAnchor - lineLength, y + yAnchor - 1, x + xAnchor + lineLength, y + yAnchor, color);
                this.drawRect(x + xAnchor, y + yAnchor - lineLength, x + xAnchor + 1, y + yAnchor, color);
                break;
            }
            case BOTTOM_RIGHT: {
                this.drawRect(x + xAnchor - lineLength, y + yAnchor - 1, x + xAnchor, y + yAnchor, color);
                this.drawRect(x + xAnchor - 1, y + yAnchor - lineLength, x + xAnchor, y + yAnchor, color);
            }
        }
        GLRenderer.popFrame();
        this.zLevel = 0.0f;
    }

    private void updateComponentsUnderMouse(int mouseX, int mouseY) {
        this.componentsUnderMouse.clear();
        for (HudComponent component : HudComponents.INSTANCE.getComponents()) {
            if (!component.isEnabled()) continue;
            Layout layout = component.getLayout();
            int cx = layout.getComponentX(component, this.width);
            int cy = layout.getComponentY(component, this.height - 28);
            int cXSize = component.getXSize();
            int cYSize = component.getYSize();
            if (mouseX < cx || mouseX >= cx + cXSize || mouseY < cy || mouseY >= cy + cYSize) continue;
            this.componentsUnderMouse.add(component);
        }
    }
}

