/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.crypto.Cipher;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ClickableLabelElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenCredits;
import net.minecraft.client.gui.ScreenPause;
import net.minecraft.client.gui.ScreenSelectWorld;
import net.minecraft.client.gui.error.ScreenMissingJCE;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.HudIngameDoom;
import net.minecraft.client.gui.options.ScreenOptions;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.gui.server.ScreenSelectServer;
import net.minecraft.client.holiday.Holidays;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.CullFace;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.util.helper.UrlHelper;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL41;
import org.slf4j.Logger;

public class ScreenMainMenu
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Block<?>[] BLOCKS_TO_DRAW = new Block[]{Blocks.STONE, Blocks.DIRT, Blocks.PLANKS_OAK, Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY, Blocks.BASALT, Blocks.LIMESTONE, Blocks.GRANITE, Blocks.BRICK_CLAY, Blocks.ICE, Blocks.WOOL, Blocks.BLOCK_SNOW, Blocks.OBSIDIAN, Blocks.COBBLE_NETHERRACK};
    private static String[] logoBlockLayers = null;
    private static final int[] KEY_CHAIN = new int[]{Keyboard.KEY_I, Keyboard.KEY_D, Keyboard.KEY_S, Keyboard.KEY_P, Keyboard.KEY_I, Keyboard.KEY_S, Keyboard.KEY_P, Keyboard.KEY_O, Keyboard.KEY_P, Keyboard.KEY_D, Keyboard.KEY_RETURN};
    private static final Random rand = new Random();
    private String splashText = "missingno";
    private ButtonElement multiplayerButton;
    private LogoBlock[][] logoBlocks;
    private final Snowflake[] snowflakes = new Snowflake[50];
    private int logoClickCounter = 0;
    private int indexToDraw = 0;
    private int codeProgress = 0;
    private boolean showBuildTime = false;
    private final String buildTimeString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(1755565009044L));

    public ScreenMainMenu() {
        ScreenPause.photoModeDisabled = false;
        try (InputStream stream = Minecraft.getMinecraft().texturePackList.getResourceAsStream("/assets/minecraft/textures/gui/title/splashes.txt");){
            String line;
            if (stream == null) {
                LOGGER.error("Could not locate 'splashes.txt'! Does the file exist!?");
                return;
            }
            ArrayList<String> allSplashes = new ArrayList<String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                allSplashes.add(line);
            }
            this.splashText = (String)allSplashes.get(rand.nextInt(allSplashes.size()));
        }
        catch (Exception e) {
            LOGGER.error("Failed to load splash texts!", e);
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (eventKey == KEY_CHAIN[this.codeProgress]) {
            ++this.codeProgress;
            if (this.codeProgress == KEY_CHAIN.length) {
                this.mc.hudIngame = this.mc.hudIngame instanceof HudIngameDoom ? new HudIngame(this.mc) : new HudIngameDoom(this.mc);
                this.mc.sndManager.playSound("mob.pig", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                this.codeProgress = 0;
            }
        } else if (eventKey != -1) {
            this.codeProgress = 0;
        }
    }

    @Override
    public void init() {
        int i;
        I18n i18n = I18n.getInstance();
        for (i = 0; i < this.snowflakes.length; ++i) {
            this.snowflakes[i] = new Snowflake(rand.nextInt(this.width), rand.nextInt(this.height), 1 + rand.nextInt(4), this.height);
        }
        if (Holidays.ANNIVERSARY_JONKADELIC.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.jonkadelic_birthday");
        } else if (Holidays.ANNIVERSARY_MAGGANDGEEZ.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.maggandgeez_birthday");
        } else if (Holidays.ANNIVERSARY_MINECRAFT.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.minecraft_birthday");
        } else if (Holidays.ANNIVERSARY_BTA.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.bta_birthday");
        } else if (Holidays.XMAS.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.xmas");
        } else if (Holidays.NEW_YEAR.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.new_year");
        } else if (Holidays.HALLOWEEN.isActive()) {
            this.splashText = i18n.translateKey("gui.main_menu.label.splash.halloween");
        }
        i = this.height / 4 + 48;
        this.buttons.add(new ButtonElement(1, this.width / 2 - 100, i, i18n.translateKey("gui.main_menu.button.singleplayer")));
        this.multiplayerButton = new ButtonElement(2, this.width / 2 - 100, i + 24, i18n.translateKey("gui.main_menu.button.multiplayer"));
        this.buttons.add(this.multiplayerButton);
        this.buttons.add(new ButtonElement(3, this.width / 2 - 100, i + 48, i18n.translateKey("gui.main_menu.button.asset_packs")));
        if (this.mc.hideQuitButton) {
            this.buttons.add(new ButtonElement(0, this.width / 2 - 100, i + 72, i18n.translateKey("gui.main_menu.button.options")));
        } else {
            this.buttons.add(new ButtonElement(0, this.width / 2 - 100, i + 72 + 12, 98, 20, i18n.translateKey("gui.main_menu.button.options")));
            this.buttons.add(new ButtonElement(4, this.width / 2 + 2, i + 72 + 12, 98, 20, i18n.translateKey("gui.main_menu.button.quit_game")));
        }
        int d = 1;
        this.buttons.add(new ClickableLabelElement(5, d, this.height - 48 - d, i18n.translateKey("gui.main_menu.button.credits"), -6316129, "minecraft:gui/screen/main_menu/icon_credits"));
        this.buttons.add(new ClickableLabelElement(6, d, this.height - 36 - d, i18n.translateKey("gui.main_menu.button.website"), -10835656, "minecraft:gui/screen/main_menu/icon_website"));
        this.buttons.add(new ClickableLabelElement(7, d, this.height - 24 - d, i18n.translateKey("gui.main_menu.button.discord"), -10983950, "minecraft:gui/screen/main_menu/icon_discord"));
        this.buttons.add(new ClickableLabelElement(8, d, this.height - 12 - d, i18n.translateKey("gui.main_menu.button.youtube"), -65536, "minecraft:gui/screen/main_menu/icon_youtube"));
        this.buttons.add(new ButtonElement(9, this.width / 2 + 104, i + 72 + 12, 20, 20, "").setTextures("minecraft:gui/misc/button_language", "minecraft:gui/misc/button_language_highlighted", "minecraft:gui/misc/button_language"));
        ButtonElement debugButton = new ButtonElement(10, this.width - 8, this.height - 8, 8, 8, "");
        debugButton.visible = false;
        this.buttons.add(debugButton);
        this.buttons.add(new ButtonElement(11, this.width / 2 - 104 - 20, i + 72 + 12, 20, 20, "").setTextures("minecraft:gui/misc/button_support", "minecraft:gui/misc/button_support_highlighted", "minecraft:gui/misc/button_support"));
        if (this.mc.session == null) {
            this.multiplayerButton.enabled = false;
        }
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        switch (button.id) {
            case 0: {
                this.mc.displayScreen(new ScreenOptions(this));
                break;
            }
            case 1: {
                this.mc.displayScreen(new ScreenSelectWorld(this));
                break;
            }
            case 2: {
                boolean hasJCE;
                try {
                    hasJCE = Cipher.getMaxAllowedKeyLength("AES") > 128;
                }
                catch (Exception ignored) {
                    hasJCE = false;
                }
                if (!hasJCE && ((Boolean)this.mc.gameSettings.doJCECheck.value).booleanValue()) {
                    this.mc.displayScreen(new ScreenMissingJCE(this, new ScreenSelectServer(this)));
                    break;
                }
                this.mc.displayScreen(new ScreenSelectServer(this));
                break;
            }
            case 3: {
                this.mc.displayScreen(new ScreenOptions(this, OptionsPages.ASSET_PACKS));
                break;
            }
            case 4: {
                this.mc.shutdown();
                break;
            }
            case 5: {
                this.mc.displayScreen(new ScreenCredits(this));
                break;
            }
            case 6: {
                UrlHelper.openURL("https://betterthanadventure.net");
                break;
            }
            case 7: {
                UrlHelper.openURL("https://betterthanadventure.net/discord");
                break;
            }
            case 8: {
                UrlHelper.openURL("https://www.youtube.com/channel/UC_GT4t8Io87-UTzaGNnsuMg");
                break;
            }
            case 11: {
                UrlHelper.openURL("https://bugs.betterthanadventure.net/");
                break;
            }
            case 9: {
                this.mc.displayScreen(new ScreenOptions(this, OptionsPages.LANGUAGE));
                break;
            }
            case 10: {
                this.mc.displayScreen(new ScreenOptions(this, OptionsPages.DEBUG));
            }
        }
    }

    @Override
    public void renderTexturedBackground() {
        if (this.mc.mainMenuBackground.isEnabled() && !((Boolean)this.mc.gameSettings.alphaMenu.value).booleanValue()) {
            this.mc.mainMenuBackground.draw();
        } else {
            super.renderTexturedBackground();
        }
    }

    @Override
    public void tick() {
        for (Snowflake snowflake : this.snowflakes) {
            snowflake.updateEffects();
        }
        if (this.logoBlocks != null) {
            Snowflake[] snowflakeArray = this.logoBlocks;
            int n = snowflakeArray.length;
            for (int i = 0; i < n; ++i) {
                Snowflake logoBlock;
                for (Snowflake block : logoBlock = snowflakeArray[i]) {
                    ((LogoBlock)((Object)block)).updateLogoEffects();
                }
            }
        }
        if (((Boolean)this.mc.gameSettings.playTitleScreenMusic.value).booleanValue()) {
            this.mc.sndManager.playTitleScreenMusic();
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        super.mouseClicked(mx, my, buttonNum);
        int logoWidth = 274;
        int logoX = this.width / 2 - logoWidth / 2;
        int logoHeight = 30;
        int p = 8;
        if (mx >= logoX + p && mx <= logoX + 270 - p && my >= logoHeight + p && my <= logoHeight + 48 - p) {
            if (this.logoClickCounter >= 0) {
                this.indexToDraw = rand.nextInt(BLOCKS_TO_DRAW.length);
                this.mc.gameSettings.alphaMenu.toggle();
                if (((Boolean)this.mc.gameSettings.alphaMenu.value).booleanValue()) {
                    this.logoBlocks = null;
                }
                this.logoClickCounter = 0;
            } else {
                ++this.logoClickCounter;
            }
        }
        if (my >= 2 && my <= 12 && mx >= 2 && mx <= 40) {
            this.showBuildTime = !this.showBuildTime;
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        int versionTextColor;
        I18n i18n = I18n.getInstance();
        this.renderBackground();
        int c = 274;
        int k = this.width / 2 - c / 2;
        int byte0 = 30;
        if (!((Boolean)this.mc.gameSettings.alphaMenu.value).booleanValue()) {
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/title/mclogo.png").bind();
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.drawTexturedModalRect(k, byte0, 0, 0, 274, 50, 0.0036496350364963502, 0.02);
        } else {
            this.drawLogo(partialTick);
        }
        this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/title/snowflake.png").bind();
        GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        if (Holidays.getCurrentThemedHoliday() == Holidays.XMAS) {
            for (Snowflake snowflake : this.snowflakes) {
                this.drawTexturedModalRectDouble(snowflake.flakeX, snowflake.flakeY, 0.0, 4 * snowflake.texIndex, 4.0, 4.0, 0.25, 0.0625);
            }
        }
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate(this.width / 2 + 140, 80.0f, 0.0f);
        GLRenderer.modelM4f().rotateZ(org.joml.Math.toRadians(-20.0f));
        float scalar = 1.8f - MathHelper.abs(MathHelper.sin((float)(System.currentTimeMillis() % 1000L) / 1000.0f * (float)Math.PI * 2.0f) * 0.1f);
        scalar = scalar * 100.0f / (float)(this.fontRenderer.stringWidthDouble(this.splashText) + 32.0);
        GLRenderer.modelM4f().scale(scalar, scalar, scalar);
        this.drawStringCenteredShadow(this.fontRenderer, this.splashText, 0, -8, 0xFFFF00);
        GLRenderer.popFrame();
        int n = versionTextColor = (Boolean)this.mc.gameSettings.alphaMenu.value != false || !this.mc.mainMenuBackground.isEnabled() ? 0x505050 : 0xFFFFFF;
        if (this.showBuildTime) {
            this.drawStringShadow(this.fontRenderer, this.buildTimeString, 2, 2, versionTextColor);
        } else {
            this.drawStringShadow(this.fontRenderer, "Better than Adventure! " + Minecraft.VERSION, 2, 2, versionTextColor);
        }
        String disclaimer1 = i18n.translateKey("gui.main_menu.label.disclaimer.1");
        this.drawStringShadow(this.fontRenderer, disclaimer1, this.width - MathHelper.ceil(this.fontRenderer.stringWidthDouble(disclaimer1)) - 2, this.height - 20, 0xFFFFFF);
        String disclaimer2 = i18n.translateKey("gui.main_menu.label.disclaimer.2");
        this.drawStringShadow(this.fontRenderer, disclaimer2, this.width - MathHelper.ceil(this.fontRenderer.stringWidthDouble(disclaimer2)) - 2, this.height - 10, 0xFFFFFF);
        super.render(mx, my, partialTick);
    }

    private void drawLogo(float partialTick) {
        if (this.logoBlocks == null) {
            this.logoBlocks = new LogoBlock[logoBlockLayers[0].length()][logoBlockLayers.length];
            for (int x = 0; x < this.logoBlocks.length; ++x) {
                for (int y = 0; y < this.logoBlocks[x].length; ++y) {
                    this.logoBlocks[x][y] = new LogoBlock(x, y);
                }
            }
        }
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.WORLD);
        int delta = this.mc.gameWindow.getWidthPixels() / this.mc.resolution.getScaledWidthScreenCoords();
        int var3 = 120 * delta;
        GLRenderer.projectionM4f().identity().perspective(70.0f, (float)this.mc.gameWindow.getWidthPixels() / (float)var3, 0.05f, 100.0f);
        GLRenderer.viewM4f().identity();
        GL41.glViewport(0, this.mc.gameWindow.getHeightPixels() - var3, this.mc.gameWindow.getWidthPixels(), var3);
        GLRenderer.modelM4f().identity();
        GLRenderer.disableState(State.CULL_FACE);
        GLRenderer.setCullFace(CullFace.BACK);
        GLRenderer.setDepthMask(true);
        GLRenderer.enableState(State.DEPTH_TEST);
        Lighting.enableLight(0.5f, 0.16f);
        for (int renderPass = 0; renderPass < 3; ++renderPass) {
            GLRenderer.pushFrame();
            GLRenderer.modelM4f().translate(0.4f, 0.6f, -12.0f);
            switch (renderPass) {
                case 0: {
                    GL41.glClear(256);
                    GLRenderer.modelM4f().translate(0.0f, -0.4f, 0.0f);
                    GLRenderer.modelM4f().scale(0.98f, 1.0f, 1.0f);
                    GLRenderer.enableState(State.BLEND);
                    GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
                    break;
                }
                case 1: {
                    GLRenderer.disableState(State.BLEND);
                    GL41.glClear(256);
                    break;
                }
                case 2: {
                    GLRenderer.enableState(State.BLEND);
                    GLRenderer.setBlendFunc(BlendFactor.SRC_COLOR, BlendFactor.ONE);
                }
            }
            GLRenderer.modelM4f().scale(1.0f, -1.0f, 1.0f);
            GLRenderer.modelM4f().rotateX(org.joml.Math.toRadians(15.0f));
            GLRenderer.modelM4f().scale(0.89f, 1.0f, 0.4f);
            GLRenderer.modelM4f().translate((float)(-logoBlockLayers[0].length()) * 0.5f, (float)(-logoBlockLayers.length) * 0.5f, 0.0f);
            TextureRegistry.worldAtlas.bind();
            if (renderPass == 0) {
                this.mc.textureManager.loadTexture("/title/black.png").bind();
            }
            for (int y = 0; y < logoBlockLayers.length; ++y) {
                for (int x = 0; x < logoBlockLayers[y].length(); ++x) {
                    char c = logoBlockLayers[y].charAt(x);
                    if (c == ' ') continue;
                    GLRenderer.pushFrame();
                    LogoBlock logoBlock = this.logoBlocks[x][y];
                    float z = (float)(logoBlock.prevHeight + (logoBlock.height - logoBlock.prevHeight) * (double)partialTick);
                    float scale = 1.0f;
                    float alpha = 1.0f;
                    if (renderPass == 0) {
                        scale = z * 0.04f + 1.0f;
                        alpha = 1.0f / scale;
                        z = 0.0f;
                    }
                    GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, alpha);
                    GLRenderer.modelM4f().translate(x, y, z);
                    GLRenderer.modelM4f().scale(scale, scale, scale);
                    ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(BLOCKS_TO_DRAW[this.indexToDraw])).renderStandalone(GLRenderer.getTessellator(), 0, LightmapHelper.getLightmapCoord(15, 15));
                    GLRenderer.popFrame();
                }
            }
            GLRenderer.popFrame();
        }
        Lighting.disable();
        GLRenderer.popFrame();
        GL41.glViewport(0, 0, this.mc.gameWindow.getWidthPixels(), this.mc.gameWindow.getHeightPixels());
    }

    public static void loadLogo() {
        try {
            InputStream inputStream = ScreenMainMenu.class.getResourceAsStream("/assets/minecraft/textures/gui/title/retrologo.png");
            BufferedImage image = ImageIO.read(inputStream);
            inputStream.close();
            logoBlockLayers = new String[image.getHeight()];
            for (int i = 0; i < image.getHeight(); ++i) {
                StringBuilder builder = new StringBuilder();
                for (int j = 0; j < image.getWidth(); ++j) {
                    int rgb = image.getRGB(j, i);
                    if ((rgb >> 16 & 0xFF) > 128) {
                        builder.append('*');
                        continue;
                    }
                    builder.append(' ');
                }
                ScreenMainMenu.logoBlockLayers[i] = builder.toString();
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while loading retro logo!", e);
        }
    }

    static {
        ScreenMainMenu.loadLogo();
    }

    static class Snowflake {
        public double flakeX;
        private final double flakeXO;
        public double flakeY = -1.0;
        public double dropSpeed;
        public int maxHeight;
        private final double verticalSpeed;
        private final int texIndex;

        public Snowflake(int flakeX, int flakeY, int dropSpeed, int maxHeight) {
            this.flakeX = flakeX;
            this.flakeY = flakeY;
            this.flakeXO = flakeX;
            this.dropSpeed = dropSpeed;
            this.maxHeight = maxHeight;
            this.verticalSpeed = (double)rand.nextFloat() - 0.5;
            this.texIndex = rand.nextInt(4);
        }

        public void updateEffects() {
            this.flakeY += this.dropSpeed * (double)0.3f;
            this.flakeX += this.verticalSpeed * 1.5;
            if (this.flakeY > (double)this.maxHeight) {
                this.flakeY = 0.0;
                this.flakeX = this.flakeXO;
            }
        }
    }

    static class LogoBlock {
        public double height;
        public double prevHeight;
        public double dropSpeed;

        public LogoBlock(int x, int y) {
            this.height = this.prevHeight = (double)(10 + y) + rand.nextDouble() * 32.0 + (double)x;
        }

        public void updateLogoEffects() {
            this.prevHeight = this.height;
            if (this.height > 0.0) {
                this.dropSpeed -= 0.6;
            }
            this.height += this.dropSpeed;
            this.dropSpeed *= 0.9;
            if (this.height < 0.0) {
                this.height = 0.0;
                this.dropSpeed = 0.0;
            }
        }
    }
}

