/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.options;

import java.util.Objects;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.options.components.KeyBindingComponent;
import net.minecraft.client.gui.options.components.OptionsComponent;
import net.minecraft.client.gui.options.data.OptionsPage;
import net.minecraft.client.gui.options.data.OptionsPageRegistry;
import net.minecraft.client.gui.options.data.OptionsPages;
import net.minecraft.client.input.InputDevice;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.option.KeyBinding;
import net.minecraft.client.render.Scissor;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.sound.SoundCategory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class ScreenOptions
extends Screen {
    private static final int TOP_SPACING = 24;
    private static final int BUTTON_SPACING = 4;
    private static final int SEPARATOR_WIDTH = 8;
    private static final int PADDING = 8;
    private static final int PAGE_BUTTON_HEIGHT = 20;
    public static KeyBinding pickingKeyBinding = null;
    public static KeyBindingComponent pickingKeyBindingComponent = null;
    public static boolean queueReload = false;
    private float optionsScrollAmount = 0.0f;
    private float pagesListScrollAmount = 0.0f;
    public int top;
    public int bottom;
    public int optionsScrollRegionHeight;
    public int pagesListScrollRegionHeight;
    public int pageWidth;
    public int pagesListWidth;
    private Float oldOptionsScrollAmount;
    private Float oldPagesListScrollAmount;
    private Integer clickX;
    private Integer clickY;
    private OptionsPage selectedPage;
    private OptionsComponent clickedComponent;
    private int clickedComponentY;
    private ItemElement renderItem = null;
    private final boolean doOptionsScroll = true;
    private final boolean doPagesListScroll = true;
    @Nullable
    private TooltipElement tooltip = null;

    public ScreenOptions(Screen parent) {
        this(parent, OptionsPages.GENERAL);
    }

    public ScreenOptions(Screen parent, OptionsPage selectedPage) {
        super(parent);
        this.selectedPage = selectedPage;
        queueReload = false;
    }

    @Override
    public void init() {
        super.init();
        this.buttons.add(new ButtonElement(0, this.width / 2 - 100, this.height - 24, 200, 20, I18n.getInstance().translateKey("gui.options.button.done")));
        this.top = 24;
        this.bottom = this.height - 28;
        this.optionsScrollRegionHeight = this.bottom - this.top;
        this.pagesListScrollRegionHeight = this.bottom - this.top;
        this.renderItem = new ItemElement(this.mc);
        this.selectedPage.initComponents(this.mc);
        this.tooltip = new TooltipElement(this.mc);
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
        if (pickingKeyBinding != null && pickingKeyBindingComponent != null) {
            if (eventKey == Keyboard.KEY_ESCAPE) {
                pickingKeyBinding = null;
                pickingKeyBindingComponent = null;
                return;
            }
            pickingKeyBinding.bind(InputDevice.keyboard, eventKey);
            pickingKeyBindingComponent.update();
            pickingKeyBinding = null;
            pickingKeyBindingComponent = null;
            return;
        }
        if (eventKey == Keyboard.KEY_ESCAPE) {
            this.mc.texturePackList.refreshIfReady();
            this.reloadIfReady();
            this.mc.displayScreen(this.getParentScreen());
        } else {
            for (OptionsComponent component : this.selectedPage.getComponents()) {
                component.onKeyPress(eventKey, eventCharacter);
            }
        }
    }

    private void drawPageItems(int x, int y, int width, int mouseX, int mouseY) {
        int y2 = y;
        for (OptionsComponent component : this.selectedPage.getComponents()) {
            if (y2 + component.getHeight() >= this.top && y2 <= this.bottom) {
                component.render(this, x, y2, width, mouseX - x, mouseY - y2);
            }
            y2 += component.getHeight();
        }
    }

    private void drawPagesListItems(int x, int y, int width, int mouseX, int mouseY) {
        int y2 = y;
        for (OptionsPage page : OptionsPageRegistry.getInstance().getPages()) {
            if (!page.isVisible(this.mc)) continue;
            String translated = I18n.getInstance().translateKey(page.getTranslationKey());
            int textColor = -8421505;
            if (page == this.selectedPage) {
                textColor = -1;
            }
            if (mouseX >= x && mouseX < x + width && mouseY >= y2 && mouseY < y2 + 20) {
                textColor = -96;
            }
            this.renderItem.render(page.getIcon(), x, y2 + 10 - 9);
            this.drawStringShadow(this.fontRenderer, translated, x + 19, y2 + 10 - 4, textColor);
            y2 += 20;
        }
    }

    @Override
    public void tick() {
        for (OptionsComponent component : this.selectedPage.getComponents()) {
            component.tick();
        }
    }

    @Override
    protected void buttonClicked(@NotNull ButtonElement button) {
        super.buttonClicked(button);
        if (button.id == 0) {
            this.mc.displayScreen(this.getParentScreen());
            this.mc.texturePackList.refreshIfReady();
            this.reloadIfReady();
        }
    }

    @Override
    public void removed() {
        for (OptionsComponent component : this.selectedPage.getComponents()) {
            component.onClose();
        }
        super.removed();
        this.mc.gameSettings.saveOptions();
        this.mc.texturePackList.refreshIfReady();
        this.reloadIfReady();
    }

    private void scrollOptions(float amount) {
        if (amount == 0.0f) {
            return;
        }
        this.optionsScrollAmount += amount;
        this.onScrollOptions();
    }

    private void onScrollOptions() {
        int totalPageHeight = this.getTotalPageHeight();
        if (this.optionsScrollAmount < 0.0f || this.optionsScrollRegionHeight > totalPageHeight) {
            this.optionsScrollAmount = 0.0f;
        } else if (this.optionsScrollAmount > (float)(totalPageHeight - this.optionsScrollRegionHeight)) {
            this.optionsScrollAmount = totalPageHeight - this.optionsScrollRegionHeight;
        }
    }

    private void scrollPagesList(float amount) {
        if (amount == 0.0f) {
            return;
        }
        this.pagesListScrollAmount += amount;
        this.onScrollPagesList();
    }

    private void onScrollPagesList() {
        int totalPagesListHeight = this.getTotalPagesListHeight();
        if (this.pagesListScrollAmount < 0.0f || this.pagesListScrollRegionHeight > totalPagesListHeight) {
            this.pagesListScrollAmount = 0.0f;
        } else if (this.pagesListScrollAmount > (float)(totalPagesListHeight - this.pagesListScrollRegionHeight)) {
            this.pagesListScrollAmount = totalPagesListHeight - this.pagesListScrollRegionHeight;
        }
    }

    private int getTotalPageHeight() {
        int totalPageHeight = 0;
        for (OptionsComponent component : this.selectedPage.getComponents()) {
            totalPageHeight += component.getHeight();
        }
        return totalPageHeight;
    }

    private int getTotalPagesListHeight() {
        int acc = 0;
        for (OptionsPage page : OptionsPageRegistry.getInstance().getPages()) {
            if (!page.isVisible(this.mc)) continue;
            ++acc;
        }
        return 20 * acc;
    }

    @Override
    public void render(int mx, int my, float renderPartialTicks) {
        if (pickingKeyBinding != null && pickingKeyBindingComponent != null) {
            mx = -1;
            my = -1;
        } else {
            Objects.requireNonNull(this);
            if (mx > this.pagesListWidth + 8 + 8 && mx < this.width) {
                if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL)) {
                    this.scrollOptions((float)Mouse.getDWheel() / -0.01f);
                } else {
                    this.scrollOptions((float)Mouse.getDWheel() / -0.05f);
                }
                this.onScrollOptions();
            } else {
                Objects.requireNonNull(this);
                if (mx >= 0 && mx <= this.pagesListWidth) {
                    if (Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL)) {
                        this.scrollPagesList((float)Mouse.getDWheel() / -0.01f);
                    } else {
                        this.scrollPagesList((float)Mouse.getDWheel() / -0.05f);
                    }
                    this.onScrollPagesList();
                }
            }
        }
        if (pickingKeyBinding == null && pickingKeyBindingComponent == null && this.mc.controllerInput != null) {
            int xc = (int)this.mc.controllerInput.cursorX;
            Objects.requireNonNull(this);
            if (xc > this.pagesListWidth + 8 + 8 && xc < this.width) {
                this.scrollOptions(this.mc.controllerInput.joyRight.getY() / 0.2f);
                this.onScrollOptions();
            } else {
                Objects.requireNonNull(this);
                if (xc >= 0 && xc <= this.pagesListWidth) {
                    this.scrollPagesList(this.mc.controllerInput.joyRight.getY() / 0.2f);
                    this.onScrollPagesList();
                }
            }
        }
        this.pagesListWidth = (int)((float)this.width * 0.25f);
        this.pageWidth = this.width - (this.pagesListWidth + 8 + 16);
        I18n i18n = I18n.getInstance();
        this.renderBackground();
        this.overlayBackground(0, this.width, 0, this.top);
        this.overlayBackground(0, this.width, this.bottom, this.height);
        Scissor.enable(0, this.top, this.width, this.bottom - this.top);
        if (my >= this.top && my <= this.bottom) {
            this.drawPageItems(this.pagesListWidth + 8 + 8, this.top - (int)this.optionsScrollAmount, this.pageWidth - 8, mx, my);
        } else {
            this.drawPageItems(this.pagesListWidth + 8 + 8, this.top - (int)this.optionsScrollAmount, this.pageWidth - 8, -1, -1);
        }
        Scissor.disable();
        Scissor.enable(0, this.top, this.pagesListWidth, this.bottom - this.top);
        int pagesListHeight = this.getTotalPagesListHeight();
        int pagesListY = this.top - (int)this.pagesListScrollAmount;
        if (pagesListHeight < this.bottom - this.top) {
            pagesListY = this.top + (this.bottom - this.top - pagesListHeight) / 2;
        }
        if (my >= this.top && my <= this.bottom) {
            this.drawPagesListItems(4, pagesListY, this.pagesListWidth - 8, mx, my);
        } else {
            this.drawPagesListItems(4, pagesListY, this.pagesListWidth - 8, -1, -1);
        }
        Scissor.disable();
        if (this.mc.currentWorld == null) {
            int shadowSize = 4;
            GLRenderer.pushFrame();
            GLRenderer.setShader(Shaders.COLOR);
            GLRenderer.enableState(State.DEPTH_TEST);
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            TessellatorShader tessellator = GLRenderer.getTessellator();
            tessellator.startDrawingQuads();
            tessellator.setColor2i(0, 0);
            tessellator.addVertexWithUV(0.0, this.top + shadowSize, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.width, this.top + shadowSize, 0.0, 1.0, 1.0);
            tessellator.setColor2i(0, 255);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, 0.0);
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setColor2i(0, 255);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, 1.0);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, 1.0, 1.0);
            tessellator.setColor2i(0, 0);
            tessellator.addVertexWithUV(this.width, this.bottom - shadowSize, 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(0.0, this.bottom - shadowSize, 0.0, 0.0, 0.0);
            tessellator.draw();
            GLRenderer.popFrame();
        }
        this.overlayBackground(this.pagesListWidth, this.pagesListWidth + 8, this.top, this.bottom);
        String titleLanguageKey = "gui.options.title";
        this.drawStringCenteredShadow(this.fontRenderer, i18n.translateKey(titleLanguageKey), this.width / 2, 5, 0xFFFFFF);
        this.drawOptionsScrollBar(mx, my);
        this.drawPagesListScrollBar(mx, my);
        super.render(mx, my, renderPartialTicks);
        if (this.tooltip != null) {
            String tooltipTranslationKey = null;
            for (OptionsComponent component : this.selectedPage.getComponents()) {
                @Nullable String componentTooltip = component.getTooltipTranslationKey();
                if (componentTooltip == null) continue;
                tooltipTranslationKey = componentTooltip;
                break;
            }
            if (tooltipTranslationKey != null) {
                this.tooltip.render(i18n.translateKey(tooltipTranslationKey), mx, my, 0, 0);
            }
        }
        if (pickingKeyBinding != null && pickingKeyBindingComponent != null) {
            this.drawRect(0, 0, this.width, this.height, -1610612736);
            this.drawStringCenteredNoShadow(this.fontRenderer, i18n.translateKeyAndFormat("gui.options.label.picking_keybinding", i18n.translateKey(pickingKeyBinding.getId())), this.width / 2, this.height / 2 - 4, 0xFFFFFF);
        }
    }

    protected void drawOptionsScrollBar(int mouseX, int mouseY) {
        float totalPageHeight = this.getTotalPageHeight();
        float scrollBarHeightPercent = (float)this.optionsScrollRegionHeight / totalPageHeight;
        if (scrollBarHeightPercent > 1.0f) {
            return;
        }
        int scrollBarX = this.width - 6;
        int scrollBarHeightPx = (int)(scrollBarHeightPercent * (float)this.optionsScrollRegionHeight);
        if (scrollBarHeightPx < 32) {
            scrollBarHeightPx = 32;
        }
        float scrollPercent = this.optionsScrollAmount / (totalPageHeight - (float)this.optionsScrollRegionHeight);
        int scrollBarY = (int)((float)this.top + (float)(this.optionsScrollRegionHeight - scrollBarHeightPx) * scrollPercent);
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.COLOR);
        TessellatorShader t = GLRenderer.getTessellator();
        t.startDrawingQuads();
        t.setColorOpaque3i(0, 0, 0);
        t.drawRectangle(scrollBarX, this.top, 6, this.optionsScrollRegionHeight);
        t.setColor2i(0x808080, 255);
        t.drawRectangle(scrollBarX, scrollBarY, 6, scrollBarHeightPx);
        t.setColor2i(0xC0C0C0, 255);
        t.drawRectangle(scrollBarX + 1, scrollBarY, 5, scrollBarHeightPx - 1);
        t.draw();
        GLRenderer.popFrame();
        if (this.clickX != null && this.clickY != null) {
            if (this.clickX >= scrollBarX && this.clickY >= this.top && this.clickX <= scrollBarX + 6 && this.clickY < this.bottom) {
                if (this.oldOptionsScrollAmount == null) {
                    this.oldOptionsScrollAmount = Float.valueOf(this.optionsScrollAmount);
                }
                this.optionsScrollAmount = this.oldOptionsScrollAmount.floatValue() + (float)(this.clickY - mouseY) * (1.0f / scrollBarHeightPercent) * -1.0f;
                this.onScrollOptions();
            }
        } else {
            this.oldOptionsScrollAmount = null;
        }
    }

    protected void drawPagesListScrollBar(int mouseX, int mouseY) {
        float totalPagesListHeight = this.getTotalPagesListHeight();
        float scrollBarHeightPercent = (float)this.pagesListScrollRegionHeight / totalPagesListHeight;
        if (scrollBarHeightPercent > 1.0f) {
            return;
        }
        int scrollBarX = this.pagesListWidth - 6;
        int scrollBarHeightPx = (int)(scrollBarHeightPercent * (float)this.pagesListScrollRegionHeight);
        if (scrollBarHeightPx < 32) {
            scrollBarHeightPx = 32;
        }
        float scrollPercent = this.pagesListScrollAmount / (totalPagesListHeight - (float)this.pagesListScrollRegionHeight);
        int scrollBarY = (int)((float)this.top + (float)(this.pagesListScrollRegionHeight - scrollBarHeightPx) * scrollPercent);
        GLRenderer.pushFrame();
        GLRenderer.setShader(Shaders.COLOR);
        TessellatorShader t = GLRenderer.getTessellator();
        t.startDrawingQuads();
        t.setColorOpaque3i(0, 0, 0);
        t.drawRectangle(scrollBarX, this.top, 6, this.pagesListScrollRegionHeight);
        t.setColor2i(0x808080, 255);
        t.drawRectangle(scrollBarX, scrollBarY, 6, scrollBarHeightPx);
        t.setColor2i(0xC0C0C0, 255);
        t.drawRectangle(scrollBarX + 1, scrollBarY, 5, scrollBarHeightPx - 1);
        t.draw();
        GLRenderer.popFrame();
        if (this.clickX != null && this.clickY != null) {
            if (this.clickX >= scrollBarX && this.clickY >= this.top && this.clickX <= scrollBarX + 6 && this.clickY < this.bottom) {
                if (this.oldPagesListScrollAmount == null) {
                    this.oldPagesListScrollAmount = Float.valueOf(this.pagesListScrollAmount);
                }
                this.pagesListScrollAmount = this.oldPagesListScrollAmount.floatValue() + (float)(this.clickY - mouseY) * (1.0f / scrollBarHeightPercent) * -1.0f;
                this.onScrollOptions();
            }
        } else {
            this.oldPagesListScrollAmount = null;
        }
    }

    @Override
    public void mouseClicked(int mx, int my, int buttonNum) {
        if (pickingKeyBinding != null && pickingKeyBindingComponent != null) {
            pickingKeyBinding.bind(InputDevice.mouse, buttonNum);
            pickingKeyBindingComponent.update();
            pickingKeyBinding = null;
            pickingKeyBindingComponent = null;
            return;
        }
        super.mouseClicked(mx, my, buttonNum);
        int left = this.pagesListWidth + 8 + 8;
        if (mx >= this.pagesListWidth + 8 && my >= this.top && my <= this.bottom) {
            int componentY = this.top - (int)this.optionsScrollAmount;
            for (OptionsComponent component : this.selectedPage.getComponents()) {
                if (mx >= left && mx <= left + this.pageWidth - 8 && my >= componentY && my <= componentY + component.getHeight()) {
                    component.onMouseClick(buttonNum, left, componentY, this.pageWidth - 8, mx - left, my - componentY);
                    this.clickedComponent = component;
                    this.clickedComponentY = componentY;
                    break;
                }
                componentY += component.getHeight();
            }
        } else if (mx >= 0 && mx <= this.pagesListWidth && my >= this.top && my <= this.bottom) {
            int pagesListHeight = this.getTotalPagesListHeight();
            int pagesListY = this.top - (int)this.pagesListScrollAmount;
            if (pagesListHeight < this.bottom - this.top) {
                pagesListY = this.top + (this.bottom - this.top - pagesListHeight) / 2;
            }
            for (OptionsPage page : OptionsPageRegistry.getInstance().getPages()) {
                if (!page.isVisible(this.mc)) continue;
                if (mx >= 0 && mx <= this.pagesListWidth && my >= pagesListY && my <= pagesListY + 20) {
                    for (OptionsComponent component : this.selectedPage.getComponents()) {
                        component.onClose();
                    }
                    this.optionsScrollAmount = 0.0f;
                    this.selectedPage = page;
                    this.selectedPage.initComponents(this.mc);
                    this.mc.sndManager.playSound("random.click", SoundCategory.GUI_SOUNDS, 1.0f, 1.0f);
                    this.mc.texturePackList.refreshIfReady();
                    this.reloadIfReady();
                    break;
                }
                pagesListY += 20;
            }
        }
        this.clickX = mx;
        this.clickY = my;
    }

    @Override
    public void mouseReleased(int mx, int my, int buttonNum) {
        if (pickingKeyBinding != null && pickingKeyBindingComponent != null) {
            return;
        }
        super.mouseReleased(mx, my, buttonNum);
        int left = this.pagesListWidth + 8 + 8;
        if (my >= this.top && my <= this.bottom && this.clickedComponent != null) {
            if (buttonNum >= 0) {
                this.clickedComponent.onMouseRelease(buttonNum, left, this.clickedComponentY, this.pageWidth, mx - left, my - this.clickedComponentY);
                this.clickedComponent = null;
            } else {
                this.clickedComponent.onMouseMove(left, this.clickedComponentY, this.pageWidth, mx - left, my - this.clickedComponentY);
            }
        }
        if (buttonNum >= 0) {
            this.clickX = null;
            this.clickY = null;
        }
    }

    @Override
    public void renderBackground() {
        super.renderBackground();
        if (this.mc.currentWorld == null) {
            TessellatorShader tessellator = GLRenderer.getTessellator();
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque1i(0x202020);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)(this.bottom + (int)this.optionsScrollAmount) / scale);
            tessellator.addVertexWithUV(this.width, this.bottom, 0.0, (float)this.width / scale, (float)(this.bottom + (int)this.optionsScrollAmount) / scale);
            tessellator.addVertexWithUV(this.width, this.top, 0.0, (float)this.width / scale, (float)(this.top + (int)this.optionsScrollAmount) / scale);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)(this.top + (int)this.optionsScrollAmount) / scale);
            tessellator.addVertexWithUV(0.0, this.bottom, 0.0, 0.0, (float)(this.bottom + (int)this.pagesListScrollAmount) / scale);
            tessellator.addVertexWithUV(this.pagesListWidth, this.bottom, 0.0, (float)this.pagesListWidth / scale, (float)(this.bottom + (int)this.pagesListScrollAmount) / scale);
            tessellator.addVertexWithUV(this.pagesListWidth, this.top, 0.0, (float)this.pagesListWidth / scale, (float)(this.top + (int)this.pagesListScrollAmount) / scale);
            tessellator.addVertexWithUV(0.0, this.top, 0.0, 0.0, (float)(this.top + (int)this.pagesListScrollAmount) / scale);
            tessellator.draw();
        } else {
            this.drawRect(0, 0, this.width, this.top, 0x5F000000);
            this.drawRect(0, this.bottom, this.width, this.height, 0x5F000000);
            this.drawRect(this.pagesListWidth, this.top, this.pagesListWidth + 8, this.bottom, 0x5F000000);
        }
    }

    private void overlayBackground(int minX, int maxX, int minY, int maxY) {
        if (this.mc.currentWorld == null) {
            TessellatorShader tessellator = GLRenderer.getTessellator();
            this.mc.textureManager.loadTexture("/assets/minecraft/textures/gui/background.png").bind();
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            float scale = 32.0f;
            tessellator.startDrawingQuads();
            tessellator.setColorOpaque1i(0x404040);
            tessellator.addVertexWithUV(minX, maxY, 0.0, (float)minX / scale, (float)maxY / scale);
            tessellator.addVertexWithUV(maxX, maxY, 0.0, (float)maxX / scale, (float)maxY / scale);
            tessellator.setColorOpaque1i(0x404040);
            tessellator.addVertexWithUV(maxX, minY, 0.0, (float)maxX / scale, (float)minY / scale);
            tessellator.addVertexWithUV(minX, minY, 0.0, (float)minX / scale, (float)minY / scale);
            tessellator.draw();
        }
    }

    @Override
    public void guiSpecificControllerInput(@NotNull ControllerInput controller) {
        if (controller.buttonStart.pressedThisFrame()) {
            this.keyPressed('\u0000', Keyboard.KEY_ESCAPE, -1, -1);
        }
        if (controller.buttonA.pressedThisFrame()) {
            this.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 0);
        }
        if (controller.buttonA.releasedThisFrame()) {
            this.mouseReleased((int)controller.cursorX, (int)controller.cursorY, 0);
        }
        if (controller.buttonY.pressedThisFrame()) {
            this.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 1);
        }
        if (controller.buttonY.releasedThisFrame()) {
            this.mouseReleased((int)controller.cursorX, (int)controller.cursorY, 1);
        }
        if (controller.buttonX.pressedThisFrame()) {
            this.mouseClicked((int)controller.cursorX, (int)controller.cursorY, 10);
        }
        if (controller.buttonB.pressedThisFrame()) {
            this.mc.displayScreen(this.getParentScreen());
        }
    }

    private void reloadIfReady() {
        if (queueReload) {
            this.mc.renderGlobal.allChanged();
            queueReload = false;
        }
    }
}

