/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import net.minecraft.client.render.renderer.GLRenderer;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3f;
import org.joml.Vector4f;

public final class Lighting {
    private Lighting() {
    }

    public static void disable() {
        GLRenderer.globalSetLightEnabled(false);
        GLRenderer.globalGetLight0().enabled = false;
        GLRenderer.globalGetLight1().enabled = false;
    }

    public static void enableInventoryLight() {
        Lighting.enableLight(0.4f, 0.5f);
        GLRenderer.globalGetNormalTransformMatrix().rotateY(Math.toRadians(-30.0f)).rotateX(Math.toRadians(155.0f)).invert();
    }

    public static void enableLight() {
        Lighting.enableLight(0.4f, 0.6f);
    }

    public static void enableLight(float ambientBrightness, float lightBrightness) {
        GLRenderer.globalGetNormalTransformMatrix().identity();
        GLRenderer.globalSetLightEnabled(true);
        GLRenderer.globalGetLight0().enabled = true;
        GLRenderer.globalGetLight1().enabled = true;
        GLRenderer.globalGetLight0().position.set(0.2f, 1.0f, -0.7f).normalize();
        GLRenderer.globalGetLight0().diffuse.set(lightBrightness, lightBrightness, lightBrightness, 1.0f);
        GLRenderer.globalGetLight0().ambient.set(0.0f, 0.0f, 0.0f, 1.0f);
        GLRenderer.globalGetLight0().specular.set(0.0f, 0.0f, 0.0f, 1.0f);
        GLRenderer.globalGetLight1().position.set(-0.2f, 1.0f, 0.7f).normalize();
        GLRenderer.globalGetLight1().diffuse.set(lightBrightness, lightBrightness, lightBrightness, 1.0f);
        GLRenderer.globalGetLight1().ambient.set(0.0f, 0.0f, 0.0f, 1.0f);
        GLRenderer.globalGetLight1().specular.set(0.0f, 0.0f, 0.0f, 1.0f);
        GLRenderer.globalGetLightModelAmbient().set(ambientBrightness, ambientBrightness, ambientBrightness, 1.0f);
    }

    public static class LightSource {
        public boolean enabled = false;
        @NotNull
        public final Vector4f ambient = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        @NotNull
        public final Vector4f diffuse = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        @NotNull
        public final Vector4f specular = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        @NotNull
        public final Vector4f position = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
        @NotNull
        public final Vector3f spotDirection = new Vector3f(0.0f, 0.0f, -1.0f);
        public float spotExponent = 0.0f;
        public float spotCutoff = 180.0f;
        public float constantAttenuation = 1.0f;
        public float linearAttenuation = 0.0f;
        public float quadraticAttenuation = 0.0f;

        public LightSource() {
            this.reset();
        }

        @NotNull
        public LightSource set(@NotNull LightSource source) {
            this.ambient.set(source.ambient);
            this.diffuse.set(source.diffuse);
            this.specular.set(source.specular);
            this.position.set(source.position);
            this.spotDirection.set(source.spotDirection);
            this.spotExponent = source.spotExponent;
            this.spotCutoff = source.spotCutoff;
            this.constantAttenuation = source.constantAttenuation;
            this.linearAttenuation = source.linearAttenuation;
            this.quadraticAttenuation = source.quadraticAttenuation;
            return this;
        }

        public void reset() {
            this.ambient.set(0.0f, 0.0f, 0.0f, 1.0f);
            this.diffuse.set(0.0f, 0.0f, 0.0f, 1.0f);
            this.specular.set(0.0f, 0.0f, 0.0f, 1.0f);
            this.position.set(0.0f, 0.0f, 1.0f, 0.0f);
            this.spotDirection.set(0.0f, 0.0f, -1.0f);
            this.spotExponent = 0.0f;
            this.spotCutoff = 180.0f;
            this.constantAttenuation = 1.0f;
            this.linearAttenuation = 0.0f;
            this.quadraticAttenuation = 0.0f;
        }
    }
}

