/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBdc;

public class BlockModelAlgae<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelAlgae(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        AABBdc bounds = this.block.getBoundsFromState(worldSource, tilePos);
        tessellator.setLightmapCoord1i(this.block.getLightmapCoord(worldSource, tilePos));
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(worldSource, tilePos, 0);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorOpaque3f(red, green, blue);
        IconCoordinate tex = this.getBlockTextureFromSideAndMetadata(Side.TOP, worldSource.getBlockData(tilePos));
        renderBlocks.renderTopFace(tessellator, bounds, tilePos.x(), (double)tilePos.y() - 0.1125, tilePos.z(), tex);
        renderBlocks.renderBottomFace(tessellator, bounds, tilePos.x(), (double)tilePos.y() + 0.0125, tilePos.z(), tex);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @NotNull Side side) {
        if (side == Side.TOP) {
            return true;
        }
        return super.shouldSideBeRendered(source, bounds, tilePos, side);
    }
}

