/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelFire;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicBrazier;
import net.minecraft.core.block.BlockLogicFire;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockModelBrazier<T extends BlockLogicBrazier>
extends BlockModelStandard<T> {
    protected IconCoordinate sideTexture = TextureRegistry.getTexture("minecraft:block/brazier/side");
    protected IconCoordinate baseTexture = TextureRegistry.getTexture("minecraft:block/brazier/base");
    protected BlockModelStandard<?> fireModel = new BlockModelFire<BlockLogicFire>(Blocks.FIRE, true).setAllTextures(0, "minecraft:block/fire");

    public BlockModelBrazier(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos();
        tessellator.setColorOpaque1i(0xFFFFFF);
        BlockModelBrazier.renderBlocks.enableAO = true;
        BlockModelBrazier.renderBlocks.cache.setupCache(this.block, worldSource, tilePos);
        AABBd bounds = new AABBd(this.block.getBounds());
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f, Side.NORTH, 0);
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f, Side.SOUTH, 0);
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f, Side.EAST, 0);
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f, Side.WEST, 0);
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos, 1.0f, 1.0f, 1.0f, Side.BOTTOM, 0);
        double zFightOffset = 0.005;
        bounds.setMin(-0.005, -0.005, -0.005).setMax(1.005, 1.005, 1.005);
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos.south(queryPos), 0.0f, 0.0f, 0.0f, Side.NORTH, 0);
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos.north(queryPos), 0.0f, 0.0f, 0.0f, Side.SOUTH, 0);
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos.west(queryPos), 0.0f, 0.0f, 0.0f, Side.EAST, 0);
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos.east(queryPos), 0.0f, 0.0f, 0.0f, Side.WEST, 0);
        renderBlocks.renderSide(tessellator, worldSource, this, bounds, tilePos.down(queryPos), 0.0f, 0.0f, 0.0f, Side.TOP, 0);
        BlockModelBrazier.renderBlocks.enableAO = false;
        if (((BlockLogicBrazier)this.block.getLogic()).isBurning()) {
            this.fireModel.render(tessellator, worldSource, tilePos);
        }
        return true;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        AABBdc bounds = this.block.getBounds();
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.baseTexture);
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderTopFace(tessellator, bounds, 0.0, -1.0, 0.0, this.baseTexture);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 1.0, this.sideTexture);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, -1.0, this.sideTexture);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        renderBlocks.renderWestFace(tessellator, bounds, 1.0, 0.0, 0.0, this.sideTexture);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        renderBlocks.renderEastFace(tessellator, bounds, -1.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }

    @Override
    public boolean shouldSideBeRendered(@NotNull WorldSource source, @NotNull AABBdc bounds, @NotNull TilePosc tilePos, @NotNull Side side) {
        return true;
    }
}

