/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockModelCactus<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelCactus(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        float sidesOffset = 0.0625f;
        AABBd bounds = new AABBd(this.block.getBounds());
        bounds.setMin(0.0625, 0.0, 0.0).setMax(0.9375, 1.0, 1.0);
        renderBlocks.setRenderSide(Side.SOUTH, false);
        renderBlocks.setRenderSide(Side.NORTH, false);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        BlockModelCactus.renderBlocks.renderBitMask = (byte)63;
        bounds.setMin(0.0, 0.0, 0.0625).setMax(1.0, 1.0, 0.9375);
        renderBlocks.setRenderSide(Side.SOUTH, true);
        renderBlocks.setRenderSide(Side.NORTH, true);
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        BlockModelCactus.renderBlocks.renderBitMask = 0;
        return true;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        AABBdc bounds = this.getBlockBoundsForItemRender();
        float sidesOffset = 0.0625f;
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        tessellator.startDrawingQuads();
        tessellator.setColor1i(this.getStandaloneTintColor(metadata));
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        tessellator.offsetTranslation(0.0, 0.0, 0.0625);
        renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
        tessellator.offsetTranslation(0.0, 0.0, -0.0625);
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        tessellator.offsetTranslation(0.0, 0.0, -0.0625);
        renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
        tessellator.offsetTranslation(0.0, 0.0, 0.0625);
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        tessellator.offsetTranslation(0.0625, 0.0, 0.0);
        renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
        tessellator.offsetTranslation(-0.0625, 0.0, 0.0);
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        tessellator.offsetTranslation(-0.0625, 0.0, 0.0);
        renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        tessellator.offsetTranslation(0.0625, 0.0, 0.0);
        tessellator.draw();
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }
}

