/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicWireRedstone;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Color;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockModelWireRedstone<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected final IconCoordinate wireStraight = TextureRegistry.getTexture("minecraft:block/wire_redstone_straight");
    protected final IconCoordinate wireCross = TextureRegistry.getTexture("minecraft:block/wire_redstone_cross");

    public BlockModelWireRedstone(Block<T> block) {
        super(block);
        this.setAllTextures(0, "minecraft:block/wire_redstone_cross");
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        int meta = worldSource.getBlockData(tilePos);
        IconCoordinate straight = this.wireStraight;
        IconCoordinate cross = this.wireCross;
        if (BlockModelWireRedstone.renderBlocks.overrideBlockTexture != null) {
            cross = BlockModelWireRedstone.renderBlocks.overrideBlockTexture;
        }
        float brightness = 1.0f;
        int lmc = LightmapHelper.getLightmapCoord(worldSource.getSavedLightValue(LightLayer.Sky, tilePos), Math.max(worldSource.getSavedLightValue(LightLayer.Block, tilePos), meta & 0xF));
        tessellator.setLightmapCoord1i(lmc);
        tessellator.setColorOpaque3f(brightness, brightness, brightness);
        Color color = Colors.allRedstoneColors[meta & 0xF];
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        TilePos queryPos = new TilePos();
        tessellator.setColorOpaque3f(brightness * red, brightness * green, brightness * blue);
        boolean west = BlockLogicWireRedstone.shouldConnectTo(worldSource, tilePos.west(queryPos), Side.WEST) || !worldSource.isBlockNormalCube(tilePos.west(queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, tilePos.add(-1, -1, 0, queryPos), Side.NONE, Side.BOTTOM);
        boolean east = BlockLogicWireRedstone.shouldConnectTo(worldSource, tilePos.east(queryPos), Side.EAST) || !worldSource.isBlockNormalCube(tilePos.east(queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, tilePos.add(1, -1, 0, queryPos), Side.NONE, Side.BOTTOM);
        boolean north = BlockLogicWireRedstone.shouldConnectTo(worldSource, tilePos.north(queryPos), Side.NORTH) || !worldSource.isBlockNormalCube(tilePos.north(queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, tilePos.add(0, -1, -1, queryPos), Side.NONE, Side.BOTTOM);
        boolean south = BlockLogicWireRedstone.shouldConnectTo(worldSource, tilePos.south(queryPos), Side.SOUTH) || !worldSource.isBlockNormalCube(tilePos.south(queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, tilePos.add(0, -1, 1, queryPos), Side.NONE, Side.BOTTOM);
        boolean westUp = false;
        boolean eastUp = false;
        boolean northUp = false;
        boolean southUp = false;
        if (!worldSource.isBlockOpaqueCube(tilePos.up(queryPos))) {
            if (worldSource.isBlockNormalCube(tilePos.west(queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, tilePos.add(-1, 1, 0, queryPos), Side.NONE, Side.TOP)) {
                west = true;
                westUp = true;
            }
            if (worldSource.isBlockNormalCube(tilePos.east(queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, tilePos.add(1, 1, 0, queryPos), Side.NONE, Side.TOP)) {
                east = true;
                eastUp = true;
            }
            if (worldSource.isBlockNormalCube(tilePos.north(queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, tilePos.add(0, 1, -1, queryPos), Side.NONE, Side.TOP)) {
                north = true;
                northUp = true;
            }
            if (worldSource.isBlockNormalCube(tilePos.south(queryPos)) && BlockLogicWireRedstone.shouldConnectToDiagonal(worldSource, tilePos.add(0, 1, 1, queryPos), Side.NONE, Side.TOP)) {
                south = true;
                southUp = true;
            }
        }
        int x = tilePos.x();
        int y = tilePos.y();
        int z = tilePos.z();
        float xMin = x;
        float xMax = x + 1;
        float zMin = z;
        float zMax = z + 1;
        float onePix = 0.0625f;
        float renderOffset = 0.015625f;
        int type = 0;
        if ((west || east) && !north && !south) {
            type = 1;
        }
        if ((north || south) && !east && !west) {
            type = 2;
        }
        int amount = 0;
        if (west) {
            amount = (byte)(amount + 1);
        }
        if (east) {
            amount = (byte)(amount + 1);
        }
        if (north) {
            amount = (byte)(amount + 1);
        }
        if (south) {
            amount = (byte)(amount + 1);
        }
        if (type == 0) {
            if (amount != 0) {
                float w = west ? 0.0f : 0.3125f;
                float e = east ? 0.0f : 0.3125f;
                float s = south ? 0.0f : 0.3125f;
                float n = north ? 0.0f : 0.3125f;
                tessellator.addVertexWithUV(xMax - e, (float)y + 0.015625f, zMax - s, cross.getSubIconU(1.0f - e), cross.getSubIconV(1.0f - s));
                tessellator.addVertexWithUV(xMax - e, (float)y + 0.015625f, zMin + n, cross.getSubIconU(1.0f - e), cross.getSubIconV(n));
                tessellator.addVertexWithUV(xMin + w, (float)y + 0.015625f, zMin + n, cross.getSubIconU(w), cross.getSubIconV(n));
                tessellator.addVertexWithUV(xMin + w, (float)y + 0.015625f, zMax - s, cross.getSubIconU(w), cross.getSubIconV(1.0f - s));
                tessellator.addVertexWithUV(xMax - e, (float)y + 0.015625f, zMax - s, cross.getSubIconU(1.0f - e), cross.getSubIconV(1.0f - s));
                tessellator.addVertexWithUV(xMin + w, (float)y + 0.015625f, zMax - s, cross.getSubIconU(w), cross.getSubIconV(1.0f - s));
                tessellator.addVertexWithUV(xMin + w, (float)y + 0.015625f, zMin + n, cross.getSubIconU(w), cross.getSubIconV(n));
                tessellator.addVertexWithUV(xMax - e, (float)y + 0.015625f, zMin + n, cross.getSubIconU(1.0f - e), cross.getSubIconV(n));
            } else {
                tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMax, cross.getIconUMax(), cross.getIconVMax());
                tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMin, cross.getIconUMax(), cross.getIconVMin());
                tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMin, cross.getIconUMin(), cross.getIconVMin());
                tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMax, cross.getIconUMin(), cross.getIconVMax());
                tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMax, cross.getIconUMax(), cross.getIconVMax());
                tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMax, cross.getIconUMin(), cross.getIconVMax());
                tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMin, cross.getIconUMin(), cross.getIconVMin());
                tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMin, cross.getIconUMax(), cross.getIconVMin());
            }
        } else if (type == 1) {
            tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMax, straight.getIconUMax(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMin, straight.getIconUMax(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMin, straight.getIconUMin(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMax, straight.getIconUMin(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMax, straight.getIconUMax(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMax, straight.getIconUMin(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMin, straight.getIconUMin(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMin, straight.getIconUMax(), straight.getIconVMin());
        } else {
            tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMax, straight.getIconUMax(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMin, straight.getIconUMin(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMin, straight.getIconUMin(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMax, straight.getIconUMax(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMax, straight.getIconUMax(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMax, straight.getIconUMax(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMin, (float)y + 0.015625f, zMin, straight.getIconUMin(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMax, (float)y + 0.015625f, zMin, straight.getIconUMin(), straight.getIconVMax());
        }
        if (northUp) {
            tessellator.addVertexWithUV(xMin, (float)y + 1.0f, (float)z + 0.015625f, straight.getIconUMin(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMin, y, (float)z + 0.015625f, straight.getIconUMax(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMax, y, (float)z + 0.015625f, straight.getIconUMax(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMax, (float)y + 1.0f, (float)z + 0.015625f, straight.getIconUMin(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMin, (float)y + 1.0f, (float)z + 0.015625f, straight.getIconUMin(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMax, (float)y + 1.0f, (float)z + 0.015625f, straight.getIconUMin(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMax, y, (float)z + 0.015625f, straight.getIconUMax(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMin, y, (float)z + 0.015625f, straight.getIconUMax(), straight.getIconVMin());
        }
        if (southUp) {
            tessellator.addVertexWithUV(xMax, (float)y + 1.0f, (float)(z + 1) - 0.015625f, straight.getIconUMin(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMax, y, (float)(z + 1) - 0.015625f, straight.getIconUMax(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMin, y, (float)(z + 1) - 0.015625f, straight.getIconUMax(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMin, (float)y + 1.0f, (float)(z + 1) - 0.015625f, straight.getIconUMin(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMax, (float)y + 1.0f, (float)(z + 1) - 0.015625f, straight.getIconUMin(), straight.getIconVMax());
            tessellator.addVertexWithUV(xMin, (float)y + 1.0f, (float)(z + 1) - 0.015625f, straight.getIconUMin(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMin, y, (float)(z + 1) - 0.015625f, straight.getIconUMax(), straight.getIconVMin());
            tessellator.addVertexWithUV(xMax, y, (float)(z + 1) - 0.015625f, straight.getIconUMax(), straight.getIconVMax());
        }
        if (eastUp) {
            tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, (float)y + 1.0f, zMin, straight.getIconUMin(), straight.getIconVMax());
            tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, y, zMin, straight.getIconUMax(), straight.getIconVMax());
            tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, y, zMax, straight.getIconUMax(), straight.getIconVMin());
            tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, (float)y + 1.0f, zMax, straight.getIconUMin(), straight.getIconVMin());
            tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, (float)y + 1.0f, zMin, straight.getIconUMin(), straight.getIconVMax());
            tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, (float)y + 1.0f, zMax, straight.getIconUMin(), straight.getIconVMin());
            tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, y, zMax, straight.getIconUMax(), straight.getIconVMin());
            tessellator.addVertexWithUV((float)(x + 1) - 0.015625f, y, zMin, straight.getIconUMax(), straight.getIconVMax());
        }
        if (westUp) {
            tessellator.addVertexWithUV((float)x + 0.015625f, (float)y + 1.0f, zMin, straight.getIconUMin(), straight.getIconVMax());
            tessellator.addVertexWithUV((float)x + 0.015625f, (float)y + 1.0f, zMax, straight.getIconUMin(), straight.getIconVMin());
            tessellator.addVertexWithUV((float)x + 0.015625f, y, zMax, straight.getIconUMax(), straight.getIconVMin());
            tessellator.addVertexWithUV((float)x + 0.015625f, y, zMin, straight.getIconUMax(), straight.getIconVMax());
            tessellator.addVertexWithUV((float)x + 0.015625f, (float)y + 1.0f, zMin, straight.getIconUMin(), straight.getIconVMax());
            tessellator.addVertexWithUV((float)x + 0.015625f, y, zMin, straight.getIconUMax(), straight.getIconVMax());
            tessellator.addVertexWithUV((float)x + 0.015625f, y, zMax, straight.getIconUMax(), straight.getIconVMin());
            tessellator.addVertexWithUV((float)x + 0.015625f, (float)y + 1.0f, zMax, straight.getIconUMin(), straight.getIconVMin());
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

