/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import java.util.Random;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.tessellator.TessellatorShader;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.EntityPainting;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class EntityRendererPainting
extends EntityRenderer<EntityPainting> {
    private static final IconCoordinate paintingBack = TextureRegistry.getTexture("minecraft:art/backing");
    private final Random rand = new Random();

    private void renderArt(TessellatorGeneral tessellator, EntityPainting entity, int sizeX, int sizeY, IconCoordinate iconCoordinate) {
        iconCoordinate.parentAtlas.bind();
        float negCenterX = (float)(-sizeX) / 2.0f;
        float negCenterY = (float)(-sizeY) / 2.0f;
        float minZ = -0.5f;
        float maxZ = 0.5f;
        int tilesX = sizeX / 16;
        int tilesY = sizeY / 16;
        for (int x = 0; x < tilesX; ++x) {
            for (int y = 0; y < tilesY; ++y) {
                double subU;
                double subV;
                float maxX = negCenterX + (float)((x + 1) * 16);
                float minX = negCenterX + (float)(x * 16);
                float maxY = negCenterY + (float)((y + 1) * 16);
                float minY = negCenterY + (float)(y * 16);
                this.setupPaintingBrightness(entity, (maxX + minX) / 2.0f, (maxY + minY) / 2.0f);
                double frontMinU = iconCoordinate.getSubIconU((float)(tilesX - x) / ((float)sizeX / 16.0f));
                double frontMaxU = iconCoordinate.getSubIconU((float)(tilesX - x - 1) / ((float)sizeX / 16.0f));
                double frontMinV = iconCoordinate.getSubIconV((float)(tilesY - y) / ((float)sizeY / 16.0f));
                double frontMaxV = iconCoordinate.getSubIconV((float)(tilesY - y - 1) / ((float)sizeY / 16.0f));
                double backMinU = paintingBack.getIconUMin();
                double backMaxU = paintingBack.getIconUMax();
                double backMinV = paintingBack.getIconVMin();
                double backMaxV = paintingBack.getIconVMax();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, -1.0f);
                tessellator.addVertexWithUV(maxX, minY, -0.5, frontMaxU, frontMinV);
                tessellator.addVertexWithUV(minX, minY, -0.5, frontMinU, frontMinV);
                tessellator.addVertexWithUV(minX, maxY, -0.5, frontMinU, frontMaxV);
                tessellator.addVertexWithUV(maxX, maxY, -0.5, frontMaxU, frontMaxV);
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                tessellator.addVertexWithUV(maxX, maxY, 0.5, backMinU, backMinV);
                tessellator.addVertexWithUV(minX, maxY, 0.5, backMaxU, backMinV);
                tessellator.addVertexWithUV(minX, minY, 0.5, backMaxU, backMaxV);
                tessellator.addVertexWithUV(maxX, minY, 0.5, backMinU, backMaxV);
                if (y == tilesY - 1) {
                    tessellator.setNormal(0.0f, 1.0f, 0.0f);
                    subV = paintingBack.getSubIconV(0.0625);
                    tessellator.addVertexWithUV(minX, maxY, -0.5, backMaxU, backMinV);
                    tessellator.addVertexWithUV(minX, maxY, 0.5, backMaxU, subV);
                    tessellator.addVertexWithUV(maxX, maxY, 0.5, backMinU, subV);
                    tessellator.addVertexWithUV(maxX, maxY, -0.5, backMinU, backMinV);
                }
                if (y == 0) {
                    tessellator.setNormal(0.0f, -1.0f, 0.0f);
                    subV = paintingBack.getSubIconV(0.9375);
                    tessellator.addVertexWithUV(minX, minY, -0.5, backMaxU, subV);
                    tessellator.addVertexWithUV(maxX, minY, -0.5, backMinU, subV);
                    tessellator.addVertexWithUV(maxX, minY, 0.5, backMinU, backMaxV);
                    tessellator.addVertexWithUV(minX, minY, 0.5, backMaxU, backMaxV);
                }
                if (x == tilesX - 1) {
                    tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                    subU = paintingBack.getSubIconU(0.0625);
                    tessellator.addVertexWithUV(maxX, maxY, 0.5, backMinU, backMinV);
                    tessellator.addVertexWithUV(maxX, minY, 0.5, backMinU, backMaxV);
                    tessellator.addVertexWithUV(maxX, minY, -0.5, subU, backMaxV);
                    tessellator.addVertexWithUV(maxX, maxY, -0.5, subU, backMinV);
                }
                if (x == 0) {
                    tessellator.setNormal(1.0f, 0.0f, 0.0f);
                    subU = paintingBack.getSubIconU(0.9375);
                    tessellator.addVertexWithUV(minX, maxY, 0.5, subU, backMinV);
                    tessellator.addVertexWithUV(minX, maxY, -0.5, backMaxU, backMinV);
                    tessellator.addVertexWithUV(minX, minY, -0.5, backMaxU, backMaxV);
                    tessellator.addVertexWithUV(minX, minY, 0.5, subU, backMaxV);
                }
                tessellator.draw();
            }
        }
    }

    private void setupPaintingBrightness(EntityPainting entity, float centerX, float centerY) {
        int worldX = MathHelper.floor(entity.x);
        int worldY = MathHelper.floor(entity.y + (double)(centerY / 16.0f));
        int worldZ = MathHelper.floor(entity.z);
        if (entity.direction == 0) {
            worldX = MathHelper.floor(entity.x + (double)(centerX / 16.0f));
        }
        if (entity.direction == 1) {
            worldZ = MathHelper.floor(entity.z - (double)(centerX / 16.0f));
        }
        if (entity.direction == 2) {
            worldX = MathHelper.floor(entity.x - (double)(centerX / 16.0f));
        }
        if (entity.direction == 3) {
            worldZ = MathHelper.floor(entity.z + (double)(centerX / 16.0f));
        }
        GLRenderer.setLightmapCoord1i(entity.world.getLightmapCoord(worldX, worldY, worldZ, entity.world.getBlockLightValue(worldX, worldY, worldZ)));
        GLRenderer.setColor3f(1.0f, 1.0f, 1.0f);
    }

    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @NotNull EntityPainting entity, double x, double y, double z, float yaw, float partialTick) {
        this.rand.setSeed(187L);
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate((float)x, (float)y, (float)z);
        GLRenderer.modelM4f().rotateY(Math.toRadians(yaw));
        ArtType art = entity.art;
        float scale = 0.0625f;
        GLRenderer.modelM4f().scale(scale, scale, scale);
        this.renderArt(tessellator, entity, art.sizeX, art.sizeY, TextureRegistry.getTexture(art.texture));
        ItemStack borderStack = entity.getBorderStack();
        if (borderStack != null) {
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            this.bindTexture(EntityPainting.getBorder(borderStack));
            this.renderBorder(entity, entity.art.sizeX, entity.art.sizeY);
            GLRenderer.disableState(State.BLEND);
        }
        GLRenderer.popFrame();
    }

    private void renderBorder(EntityPainting entity, int sizeX, int sizeY) {
        float negCenterX = (float)(-sizeX) / 2.0f;
        float negCenterY = (float)(-sizeY) / 2.0f;
        float minZ = -0.6f;
        float maxZ = 0.5f;
        int width = sizeX / 16;
        int height = sizeY / 16;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                float maxX = negCenterX + (float)((x + 1) * 16);
                float minX = negCenterX + (float)(x * 16);
                float maxY = negCenterY + (float)((y + 1) * 16);
                float minY = negCenterY + (float)(y * 16);
                if (x == width - 1) {
                    maxX += 0.1f;
                }
                if (x == 0) {
                    minX -= 0.1f;
                }
                if (y == height - 1) {
                    maxY += 0.1f;
                }
                if (y == 0) {
                    minY -= 0.1f;
                }
                this.setupPaintingBrightness(entity, (maxX + minX) / 2.0f, (maxY + minY) / 2.0f);
                int index = this.getIndex(width - x - 1, height - y - 1, width, height);
                float u = (float)(index % 4) / 4.0f;
                float v = (float)(index / 4) / 4.0f;
                float minU = u + 0.25f;
                float maxU = u;
                float minV = v + 0.25f;
                float maxV = v;
                TessellatorShader tessellator = GLRenderer.getTessellator();
                tessellator.startDrawingQuads();
                tessellator.setNormal(0.0f, 0.0f, 1.0f);
                tessellator.addVertexWithUV(maxX, minY, minZ, maxU, minV);
                tessellator.addVertexWithUV(minX, minY, minZ, minU, minV);
                tessellator.addVertexWithUV(minX, maxY, minZ, minU, maxV);
                tessellator.addVertexWithUV(maxX, maxY, minZ, maxU, maxV);
                float f = 0.015625f;
                if (y == 0) {
                    minU = u;
                    maxU = u + 0.25f;
                    minV = v + 0.25f - f;
                    maxV = v + 0.25f;
                    tessellator.setNormal(0.0f, -1.0f, 0.0f);
                    tessellator.addVertexWithUV(maxX, minY, maxZ, minU, minV);
                    tessellator.addVertexWithUV(minX, minY, maxZ, maxU, minV);
                    tessellator.addVertexWithUV(minX, minY, minZ, maxU, maxV);
                    tessellator.addVertexWithUV(maxX, minY, minZ, minU, maxV);
                }
                if (y == height - 1) {
                    minU = u;
                    maxU = u + 0.25f;
                    minV = v + f;
                    maxV = v;
                    tessellator.setNormal(0.0f, 1.0f, 0.0f);
                    tessellator.addVertexWithUV(maxX, maxY, minZ, minU, minV);
                    tessellator.addVertexWithUV(minX, maxY, minZ, maxU, minV);
                    tessellator.addVertexWithUV(minX, maxY, maxZ, maxU, maxV);
                    tessellator.addVertexWithUV(maxX, maxY, maxZ, minU, maxV);
                }
                if (x == 0) {
                    minU = u + 0.25f - f;
                    maxU = u + 0.25f;
                    minV = v;
                    maxV = v + 0.25f;
                    tessellator.setNormal(1.0f, 0.0f, 0.0f);
                    tessellator.addVertexWithUV(minX, maxY, minZ, maxU, minV);
                    tessellator.addVertexWithUV(minX, minY, minZ, maxU, maxV);
                    tessellator.addVertexWithUV(minX, minY, maxZ, minU, maxV);
                    tessellator.addVertexWithUV(minX, maxY, maxZ, minU, minV);
                }
                if (x == width - 1) {
                    minU = u + f;
                    maxU = u;
                    minV = v;
                    maxV = v + 0.25f;
                    tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                    tessellator.addVertexWithUV(maxX, maxY, maxZ, maxU, minV);
                    tessellator.addVertexWithUV(maxX, minY, maxZ, maxU, maxV);
                    tessellator.addVertexWithUV(maxX, minY, minZ, minU, maxV);
                    tessellator.addVertexWithUV(maxX, maxY, minZ, minU, minV);
                }
                tessellator.draw();
            }
        }
    }

    private int getIndex(int x, int y, int width, int height) {
        if (width == 1 && height == 1) {
            return 15;
        }
        if (width == 1) {
            if (y == 0) {
                return 3;
            }
            if (y == height - 1) {
                return 11;
            }
            return 7;
        }
        if (height == 1) {
            if (x == 0) {
                return 12;
            }
            if (x == width - 1) {
                return 14;
            }
            return 13;
        }
        if (x == 0 && y == 0) {
            return 0;
        }
        if (x == 0 && y == height - 1) {
            return 8;
        }
        if (x == width - 1 && y == 0) {
            return 2;
        }
        if (x == width - 1 && y == height - 1) {
            return 10;
        }
        if (x == 0) {
            return 4;
        }
        if (x == width - 1) {
            return 6;
        }
        if (y == 0) {
            return 1;
        }
        if (y == height - 1) {
            return 9;
        }
        return 5;
    }
}

