/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.terrain;

import com.b100.json.element.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.render.renderer.DrawMode;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.terrain.VertexAttribute;
import net.minecraft.client.render.terrain.VertexConfig;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opengl.GL41;

public class VertexConfigStandard
implements VertexConfig<VertexConfigStandard> {
    @NotNull
    public DrawMode drawMode = DrawMode.TRIANGLES;
    public boolean enableColor = false;
    public boolean enableTexture = false;
    public boolean enableNormal = false;
    public boolean enableLightmap = false;
    public final List<VertexAttribute> attributes = new ArrayList<VertexAttribute>();

    @Override
    @NotNull
    public DrawMode drawmode() {
        return this.drawMode;
    }

    @Override
    public void enable(int vao, int vbo) {
        GL41.glBindVertexArray(vao);
        GL41.glBindBuffer(34962, vbo);
        int vertexSize = this.getVertexSize();
        int offset = 0;
        GL41.glVertexAttribPointer(0, 3, 5126, false, vertexSize, offset);
        offset += 12;
        GL41.glEnableVertexAttribArray(0);
        if (this.enableColor) {
            GL41.glVertexAttribPointer(1, 4, 5121, true, vertexSize, offset);
            offset += 4;
            GL41.glEnableVertexAttribArray(1);
        } else {
            GL41.glVertexAttrib4f(1, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.enableTexture) {
            GL41.glVertexAttribPointer(2, 2, 5126, false, vertexSize, offset);
            offset += 8;
            GL41.glEnableVertexAttribArray(2);
        }
        if (this.enableLightmap) {
            GL41.glVertexAttribPointer(3, 2, 5121, true, vertexSize, offset);
            offset += 2;
            GL41.glEnableVertexAttribArray(3);
        } else {
            GL41.glVertexAttrib2f(3, GLRenderer.getLightmapBlock(), GLRenderer.getLightmapSky());
        }
        if (this.enableNormal) {
            GL41.glVertexAttribPointer(4, 3, 5120, true, vertexSize, offset);
            offset += 3;
            GL41.glEnableVertexAttribArray(4);
        } else {
            GL41.glVertexAttrib3f(4, 0.0f, -1.0f, 0.0f);
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            VertexAttribute attrib = this.attributes.get(i);
            GL41.glEnableVertexAttribArray(attrib.id);
            GL41.glVertexAttribPointer(attrib.id, attrib.getSize(), attrib.type, false, vertexSize, offset);
            offset += attrib.getTypeSize();
        }
    }

    @Override
    public void disable() {
        GL41.glDisableVertexAttribArray(0);
        GL41.glDisableVertexAttribArray(1);
        GL41.glDisableVertexAttribArray(2);
        GL41.glDisableVertexAttribArray(3);
        GL41.glDisableVertexAttribArray(4);
        for (int i = 0; i < this.attributes.size(); ++i) {
            VertexAttribute attrib = this.attributes.get(i);
            GL41.glDisableVertexAttribArray(attrib.id);
        }
        GL41.glBindBuffer(34962, 0);
        GL41.glBindVertexArray(0);
    }

    @Override
    public int getVertexSize() {
        int size = 12;
        if (this.enableColor) {
            size += 4;
        }
        if (this.enableTexture) {
            size += 8;
        }
        if (this.enableNormal) {
            size += 3;
        }
        if (this.enableLightmap) {
            size += 2;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            size += this.attributes.get(i).getTypeSize();
        }
        return size;
    }

    @Override
    @NotNull
    public VertexConfigStandard copy() {
        VertexConfigStandard copy = new VertexConfigStandard();
        copy.drawMode = this.drawMode;
        copy.enableColor = this.enableColor;
        copy.enableTexture = this.enableTexture;
        copy.enableNormal = this.enableNormal;
        copy.enableLightmap = this.enableLightmap;
        copy.attributes.addAll(this.attributes);
        return copy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof VertexConfigStandard) {
            return VertexConfigStandard.compare(this, (VertexConfigStandard)obj) == 0;
        }
        return false;
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.set("drawMode", this.drawMode.name());
        object.set("enableColor", this.enableColor);
        object.set("enableTexcoord", this.enableTexture);
        object.set("enableNormal", this.enableNormal);
        object.set("enableLightmap", this.enableLightmap);
        if (!this.attributes.isEmpty()) {
            JsonObject attribsJson = new JsonObject();
            attribsJson.set("size", this.attributes.size());
            for (int i = 0; i < this.attributes.size(); ++i) {
                VertexAttribute attribute = this.attributes.get(i);
                JsonObject attribObject = new JsonObject();
                attribObject.set("id", attribute.id);
                attribObject.set("type", attribute.type);
                attribsJson.set(attribute.name, attribObject);
            }
            object.set("attribs", attribsJson);
        }
        return object;
    }

    public static int compare(VertexConfigStandard c1, VertexConfigStandard c2) {
        if (c1.drawMode != c2.drawMode) {
            return 1;
        }
        if (c1.enableColor != c2.enableColor) {
            return 2;
        }
        if (c1.enableTexture != c2.enableTexture) {
            return 3;
        }
        if (c1.enableNormal != c2.enableNormal) {
            return 4;
        }
        if (c1.enableLightmap != c2.enableLightmap) {
            return 4;
        }
        if (c1.attributes.size() != c2.attributes.size()) {
            return 5;
        }
        for (int i = 0; i < c1.attributes.size(); ++i) {
            VertexAttribute attrib2;
            VertexAttribute attrib1 = c1.attributes.get(i);
            int compare = VertexAttribute.compare(attrib1, attrib2 = c2.attributes.get(i));
            if (compare == 0) continue;
            return (6 + i) * 1000 + compare;
        }
        return 0;
    }

    public static void compareThrow(VertexConfig<?> config1, VertexConfig<?> config2) {
        if (!config1.equals(config2)) {
            System.err.println("VertexConfig Mismatch:\n" + String.valueOf(config1) + "\n!=\n" + String.valueOf(config2));
            throw new RuntimeException("VertexConfig mismatch " + String.valueOf(config1) + " " + String.valueOf(config2) + "!");
        }
    }

    public String toString() {
        return this.toJson().toString();
    }
}

