/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.world.chunk.provider;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.pos.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChunkProviderStatic
implements IChunkProvider {
    public static final int CHUNK_RADIUS = 32;
    public static final int CHUNK_MASK = 63;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Chunk blankChunk;
    public ChunkGenerator chunkGenerator;
    private final IChunkLoader chunkLoader;
    private final Chunk[] chunks = new Chunk[4096];
    private final World worldObj;
    int lastQueriedChunkXPos = Integer.MIN_VALUE;
    int lastQueriedChunkZPos = Integer.MIN_VALUE;
    private Chunk lastQueriedChunk;
    private int curChunkX;
    private int curChunkY;

    public ChunkProviderStatic(World world, IChunkLoader ichunkloader, ChunkGenerator chunkGenerator) {
        this.blankChunk = new EmptyChunk(world, 0, 0);
        this.worldObj = world;
        this.chunkLoader = ichunkloader;
        this.chunkGenerator = chunkGenerator;
    }

    @Override
    public void setCurrentChunkOver(@NotNull ChunkPos chunkPos) {
        this.curChunkX = chunkPos.x;
        this.curChunkY = chunkPos.z;
    }

    public boolean canChunkExist(@NotNull ChunkPos chunkPos) {
        int byte0 = 31;
        return chunkPos.x >= this.curChunkX - byte0 && chunkPos.z >= this.curChunkY - byte0 && chunkPos.x <= this.curChunkX + byte0 && chunkPos.z <= this.curChunkY + byte0;
    }

    @Override
    public void regenerateChunk(@NotNull ChunkPos chunkPos) {
        int k = chunkPos.x & 0x3F;
        int l = chunkPos.z & 0x3F;
        int i1 = k + l * 32 * 2;
        if (this.chunkGenerator == null) {
            return;
        }
        Chunk newChunk = this.chunkGenerator.generate(chunkPos.x, chunkPos.z);
        newChunk.fixMissingBlocks();
        this.chunks[i1] = newChunk;
        if (!this.chunks[i1].isTerrainPopulated && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z)) {
            this.populate(this, chunkPos.x, chunkPos.z);
        }
        if (this.isChunkLoaded(chunkPos.x - 1, chunkPos.z) && !this.provideChunk((int)(chunkPos.x - 1), (int)chunkPos.z).isTerrainPopulated && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z)) {
            this.populate(this, chunkPos.x - 1, chunkPos.z);
        }
        if (this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && !this.provideChunk((int)chunkPos.x, (int)(chunkPos.z - 1)).isTerrainPopulated && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z)) {
            this.populate(this, chunkPos.x, chunkPos.z - 1);
        }
        if (this.isChunkLoaded(chunkPos.x - 1, chunkPos.z - 1) && !this.provideChunk((int)(chunkPos.x - 1), (int)(chunkPos.z - 1)).isTerrainPopulated && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z)) {
            this.populate(this, chunkPos.x - 1, chunkPos.z - 1);
        }
    }

    @Override
    public boolean isChunkLoaded(@NotNull ChunkPos chunkPos) {
        if (!this.canChunkExist(chunkPos)) {
            return false;
        }
        if (chunkPos.x == this.lastQueriedChunkXPos && chunkPos.z == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return true;
        }
        int k = chunkPos.x & 0x3F;
        int l = chunkPos.z & 0x3F;
        int chunkIndex = k + l * 32 * 2;
        return this.chunks[chunkIndex] == this.blankChunk || this.chunks[chunkIndex] != null && this.chunks[chunkIndex].isAtLocation(chunkPos.x, chunkPos.z);
    }

    @Override
    @NotNull
    public Chunk prepareChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        return this.provideChunk(chunkPos.x, chunkPos.z);
    }

    @Override
    @NotNull
    public Chunk provideChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        if (chunkPos.x == this.lastQueriedChunkXPos && chunkPos.z == this.lastQueriedChunkZPos && this.lastQueriedChunk != null) {
            return this.lastQueriedChunk;
        }
        if (!this.worldObj.findingSpawnPoint && !this.canChunkExist(chunkPos)) {
            return this.blankChunk;
        }
        int k = chunkPos.x & 0x3F;
        int l = chunkPos.z & 0x3F;
        int i1 = k + l * 32 * 2;
        if (!this.isChunkLoaded(chunkPos.x, chunkPos.z)) {
            Chunk chunk;
            if (this.chunks[i1] != null) {
                this.saveChunk(this.chunks[i1]);
                this.chunks[i1].onUnload();
            }
            if ((chunk = this.loadChunk(chunkPos)) == null) {
                if (this.chunkGenerator != null) {
                    chunk = this.chunkGenerator.generate(chunkPos.x, chunkPos.z);
                    chunk.fixMissingBlocks();
                } else {
                    chunk = this.blankChunk;
                }
            }
            this.chunks[i1] = chunk;
            if (this.chunks[i1] != null) {
                this.chunks[i1].checkForLightGaps();
                this.chunks[i1].onLoad();
            }
            if (!this.chunks[i1].isTerrainPopulated && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z)) {
                this.populate(this, chunkPos.x, chunkPos.z);
            }
            if (this.isChunkLoaded(chunkPos.x - 1, chunkPos.z) && !this.provideChunk((int)(chunkPos.x - 1), (int)chunkPos.z).isTerrainPopulated && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z)) {
                this.populate(this, chunkPos.x - 1, chunkPos.z);
            }
            if (this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && !this.provideChunk((int)chunkPos.x, (int)(chunkPos.z - 1)).isTerrainPopulated && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z)) {
                this.populate(this, chunkPos.x, chunkPos.z - 1);
            }
            if (this.isChunkLoaded(chunkPos.x - 1, chunkPos.z - 1) && !this.provideChunk((int)(chunkPos.x - 1), (int)(chunkPos.z - 1)).isTerrainPopulated && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z)) {
                this.populate(this, chunkPos.x - 1, chunkPos.z - 1);
            }
            if (this.worldObj.getCurrentWeather() != null) {
                this.worldObj.getCurrentWeather().doChunkLoadEffect(this.worldObj, chunk);
            }
        }
        this.lastQueriedChunkXPos = chunkPos.x;
        this.lastQueriedChunkZPos = chunkPos.z;
        this.lastQueriedChunk = this.chunks[i1];
        return this.chunks[i1];
    }

    private Chunk loadChunk(@NotNull ChunkPos chunkPos) {
        if (this.chunkLoader == null) {
            return this.blankChunk;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.worldObj, chunkPos.x, chunkPos.z);
            if (chunk != null) {
                chunk.lastSaveTime = this.worldObj.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            LOGGER.error("Error loading chunk at X:{}, Z:{}", chunkPos.x, chunkPos.z, exception);
            return this.blankChunk;
        }
    }

    private void saveChunk(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.worldObj.getWorldTime();
            this.chunkLoader.saveChunk(this.worldObj, chunk);
        }
        catch (IOException e) {
            LOGGER.error("Error saving chunk at X:{}, Z:{}", chunk.pos.x, chunk.pos.x, e);
        }
    }

    @Override
    public void populate(@NotNull ChunkPos chunkPos) {
        Chunk chunk = this.provideChunk(chunkPos, true);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkGenerator != null) {
                this.chunkGenerator.decorate(chunk);
                chunk.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, @Nullable ProgressListener progressListener) {
        int i = 0;
        int j = 0;
        if (progressListener != null) {
            for (int k = 0; k < this.chunks.length; ++k) {
                if (this.chunks[k] == null || !this.chunks[k].needsSaving(saveImmediately)) continue;
                ++j;
            }
        }
        int l = 0;
        for (int i1 = 0; i1 < this.chunks.length; ++i1) {
            if (this.chunks[i1] == null || !this.chunks[i1].needsSaving(saveImmediately)) continue;
            this.saveChunk(this.chunks[i1]);
            this.chunks[i1].isModified = false;
            if (++i == 2 && !saveImmediately) {
                return false;
            }
            if (progressListener == null || ++l % 10 != 0) continue;
            progressListener.progressStagePercentage(l * 100 / j);
        }
        return true;
    }

    @Override
    public boolean tick() {
        return false;
    }

    @Override
    public void unloadAllChunks() {
        for (Chunk chunk : this.chunks) {
            if (chunk == null) continue;
            chunk.onUnload();
        }
        Arrays.fill(this.chunks, null);
        this.chunkGenerator = null;
        System.gc();
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    @NotNull
    public String getInfoString() {
        return "ChunkCache: " + this.chunks.length;
    }

    public IChunkLoader getChunkLoader() {
        return this.chunkLoader;
    }
}

