/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicNetherrackIgneous
extends BlockLogic {
    public BlockLogicNetherrackIgneous(@NotNull Block<?> block) {
        super(block, Materials.NETHERRACK);
        block.setTicking(true);
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        float f = 0.125f;
        return new AABBd(tilePos.x(), tilePos.y(), tilePos.z(), tilePos.x() + 1, (float)(tilePos.y() + 1) - f, tilePos.z() + 1);
    }

    @Override
    public void onEntityCollision(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Entity entity) {
        if (entity instanceof EntityItem) {
            return;
        }
        entity.fireHurt();
    }

    @Override
    public int tickDelay() {
        return 20;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay() + world.rand.nextInt(5) - world.rand.nextInt(5));
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        world.scheduleBlockUpdate(tilePos, this.block.id(), this.tickDelay() + world.rand.nextInt(5) - world.rand.nextInt(5));
    }

    public boolean canMelt(@NotNull World world, @NotNull TilePosc tilePos) {
        boolean canMelt = false;
        TilePos queryPos = new TilePos();
        for (Direction dir : Direction.directions) {
            Material adjacentMaterial;
            Block<?> block = world.getBlock(tilePos.add(dir, queryPos));
            Material material = adjacentMaterial = block == null ? Materials.AIR : block.getMaterial();
            if (adjacentMaterial == Materials.WATER) {
                return false;
            }
            canMelt |= adjacentMaterial == Materials.LAVA;
        }
        return canMelt;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        if (this.canMelt(world, tilePos)) {
            world.setBlockIdNotify(tilePos, Blocks.FLUID_LAVA_FLOWING.id());
        }
    }
}

