/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicPlanksPainted
extends BlockLogic
implements IPainted {
    public BlockLogicPlanksPainted(@NotNull Block<?> block) {
        super(block, Materials.WOOD);
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        return itemStack.getMetadata();
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(this, 1, data)};
    }

    @Override
    @NotNull
    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta(meta & 0xF);
    }

    @Override
    public int toMetadata(@NotNull DyeColor color) {
        return color.blockMeta;
    }

    @Override
    public int stripColorFromMetadata(int meta) {
        return 0;
    }

    @Override
    public void removeDye(@NotNull World world, @NotNull TilePosc tilePos) {
        world.setBlockIdNotify(tilePos, Blocks.PLANKS_OAK.id());
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePosc tilePos, @NotNull DyeColor color) {
        IPainted.super.setColor(world, tilePos, color);
    }
}

