/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicSlab;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicSlabPainted
extends BlockLogicSlab
implements IPainted {
    public BlockLogicSlabPainted(Block<?> block, Block<?> modelBlock) {
        super(block, modelBlock);
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        return itemStack.getMetadata();
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        int meta = mob.getVerticalPlacementDirection(side, yHit) == Direction.UP ? 2 : 0;
        world.setBlockDataNotify(tilePos, meta | world.getBlockData(tilePos) & 0xF0);
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        int meta = side == Side.TOP ? 2 : 0;
        world.setBlockDataNotify(tilePos, meta | world.getBlockData(tilePos) & 0xF0);
    }

    @Override
    @NotNull
    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta((meta & 0xF0) >> 4);
    }

    @Override
    public int toMetadata(@NotNull DyeColor color) {
        return color.blockMeta << 4;
    }

    @Override
    public int stripColorFromMetadata(int meta) {
        return meta & 0xF;
    }

    @Override
    public void removeDye(@NotNull World world, @NotNull TilePosc tilePos) {
        int meta = world.getBlockData(tilePos);
        world.setBlockIdDataNotify(tilePos, Blocks.PLANKS_OAK.id(), meta & 0xF);
    }

    @Override
    public void setColor(@NotNull World world, @NotNull TilePosc tilePos, @NotNull DyeColor color) {
        IPainted.super.setColor(world, tilePos, color);
    }

    @Override
    @NotNull
    public String getLanguageKey(int data) {
        return super.getLanguageKey(data) + "." + this.fromMetadata((int)data).colorID;
    }
}

