/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import net.minecraft.core.world.noise.Noise2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FractalNoise2D<T extends Noise2D>
implements Noise2D {
    public static final double DEFAULT_LACUNARITY = 0.5;
    public static final double DEFAULT_PERSISTENCE = 2.0;
    @NotNull
    protected final @NotNull T @NotNull [] octaves;
    protected double lacunarity = 0.5;
    protected double persistence = 2.0;

    public FractalNoise2D(@NotNull @NotNull T @NotNull [] octaves) {
        this.octaves = octaves;
    }

    @NotNull
    public final FractalNoise2D<T> setLacunarity(double lacunarity) {
        this.lacunarity = lacunarity;
        return this;
    }

    @NotNull
    public final FractalNoise2D<T> setPersistence(double persistence) {
        this.persistence = persistence;
        return this;
    }

    @Override
    public double getValue(double x, double z) {
        double out = 0.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        for (T octave : this.octaves) {
            out += octave.getValue(x * frequency, z * frequency) * amplitude;
            frequency *= this.lacunarity;
            amplitude *= this.persistence;
        }
        return out;
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double amplitude) {
        if (out == null || out.length < xSize * zSize) {
            out = new double[xSize * zSize];
        }
        double frequency = 1.0;
        for (T octave : this.octaves) {
            octave.addRegion(out, x, z, xSize, zSize, xScale * frequency, zScale * frequency, amplitude);
            frequency *= this.lacunarity;
            amplitude *= this.persistence;
        }
        return out;
    }
}

