/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import java.util.Random;
import net.minecraft.core.world.noise.Noise2D;
import net.minecraft.core.world.noise.Noise3D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplexNoise
implements Noise2D,
Noise3D {
    private static final int @NotNull [] @NotNull [] GRAD = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}};
    private static final double F2 = 0.5 * (Math.sqrt(3.0) - 1.0);
    private static final double G2 = (3.0 - Math.sqrt(3.0)) / 6.0;
    private static final double F3 = 0.3333333333333333;
    private static final double G3 = 0.16666666666666666;
    private final int @NotNull [] p = new int[512];
    public final double xo;
    public final double yo;
    public final double zo;

    @NotNull
    public static @NotNull SimplexNoise @NotNull [] genOctaves(long seed, int numOctaves) {
        return SimplexNoise.genOctaves(seed, numOctaves, 0);
    }

    @NotNull
    public static @NotNull SimplexNoise @NotNull [] genOctaves(long seed, int numOctaves, int preOctaves) {
        @NotNull Random random = new Random(seed);
        for (int i = 0; i < preOctaves; ++i) {
            random.nextDouble();
            random.nextDouble();
            random.nextDouble();
            for (int j = 0; j < 256; ++j) {
                random.nextInt(256 - j);
            }
        }
        @NotNull SimplexNoise @NotNull [] octaves = new SimplexNoise[numOctaves];
        for (int i = 0; i < numOctaves; ++i) {
            octaves[i] = new SimplexNoise(random);
        }
        return octaves;
    }

    public SimplexNoise(@NotNull Random random) {
        int i;
        this.xo = random.nextDouble() * 256.0;
        this.yo = random.nextDouble() * 256.0;
        this.zo = random.nextDouble() * 256.0;
        for (i = 0; i < 256; ++i) {
            this.p[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int newI = random.nextInt(256 - i) + i;
            int temp = this.p[i];
            this.p[i] = this.p[newI];
            this.p[newI] = temp;
            this.p[i + 256] = this.p[i];
        }
    }

    private static int fastFloor(double d) {
        return d <= 0.0 ? (int)d - 1 : (int)d;
    }

    private static double dot(int @NotNull [] vec, double x, double y) {
        return (double)vec[0] * x + (double)vec[1] * y;
    }

    private static double dot(int @NotNull [] vec, double x, double y, double z) {
        return (double)vec[0] * x + (double)vec[1] * y + (double)vec[2] * z;
    }

    @Override
    public double getValue(double x, double z) {
        double n2;
        double n1;
        double n0;
        int k1;
        int i1;
        double Z0;
        double z0;
        int k;
        double t;
        double s = (x + z) * F2;
        int i = SimplexNoise.fastFloor(x + s);
        double X0 = (double)i - (t = (double)(i + (k = SimplexNoise.fastFloor(z + s))) * G2);
        double x0 = x - X0;
        if (x0 > (z0 = z - (Z0 = (double)k - t))) {
            i1 = 1;
            k1 = 0;
        } else {
            i1 = 0;
            k1 = 1;
        }
        double x1 = x0 - (double)i1 + G2;
        double z1 = z0 - (double)k1 + G2;
        double x2 = x0 - 1.0 + 2.0 * G2;
        double z2 = z0 - 1.0 + 2.0 * G2;
        int ib = i & 0xFF;
        int kb = k & 0xFF;
        int gi0 = this.p[ib + this.p[kb]] % 12;
        int gi1 = this.p[ib + i1 + this.p[kb + k1]] % 12;
        int gi2 = this.p[ib + 1 + this.p[kb + 1]] % 12;
        double t0 = 0.5 - x0 * x0 - z0 * z0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * SimplexNoise.dot(GRAD[gi0], x0, z0);
        }
        double t1 = 0.5 - x1 * x1 - z1 * z1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * SimplexNoise.dot(GRAD[gi1], x1, z1);
        }
        double t2 = 0.5 - x2 * x2 - z2 * z2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * SimplexNoise.dot(GRAD[gi2], x2, z2);
        }
        return 70.0 * (n0 + n1 + n2);
    }

    @Override
    public double getValue(double x, double y, double z) {
        double n3;
        double n2;
        double n1;
        double n0;
        int k2;
        int j2;
        int i2;
        int k1;
        int j1;
        int i1;
        double s = (x + y + z) * 0.3333333333333333;
        int i = SimplexNoise.fastFloor(x + s);
        int j = SimplexNoise.fastFloor(y + s);
        int k = SimplexNoise.fastFloor(z + s);
        double t = (double)(i + j + k) * 0.16666666666666666;
        double X0 = (double)i - t;
        double Y0 = (double)j - t;
        double Z0 = (double)k - t;
        double x0 = x - X0;
        double y0 = y - Y0;
        double z0 = z - Z0;
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        double x1 = x0 - (double)i1 + 0.16666666666666666;
        double y1 = y0 - (double)j1 + 0.16666666666666666;
        double z1 = z0 - (double)k1 + 0.16666666666666666;
        double x2 = x0 - (double)i2 + 0.3333333333333333;
        double y2 = y0 - (double)j2 + 0.3333333333333333;
        double z2 = z0 - (double)k2 + 0.3333333333333333;
        double x3 = x0 - 1.0 + 0.5;
        double y3 = y0 - 1.0 + 0.5;
        double z3 = z0 - 1.0 + 0.5;
        int ib = i & 0xFF;
        int jb = j & 0xFF;
        int kb = k & 0xFF;
        int gi0 = this.p[ib + this.p[jb + this.p[kb]]] % 12;
        int gi1 = this.p[ib + i1 + this.p[jb + j1 + this.p[kb + k1]]] % 12;
        int gi2 = this.p[ib + i2 + this.p[jb + j2 + this.p[kb + k2]]] % 12;
        int gi3 = this.p[ib + 1 + this.p[jb + 1 + this.p[kb + 1]]] % 12;
        double t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * SimplexNoise.dot(GRAD[gi0], x0, y0, z0);
        }
        double t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * SimplexNoise.dot(GRAD[gi1], x1, y1, z1);
        }
        double t2 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * SimplexNoise.dot(GRAD[gi2], x2, y2, z2);
        }
        double t3 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3;
        if (t3 < 0.0) {
            n3 = 0.0;
        } else {
            t3 *= t3;
            n3 = t3 * t3 * SimplexNoise.dot(GRAD[gi3], x3, y3, z3);
        }
        return 32.0 * (n0 + n1 + n2 + n3);
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double amplitude) {
        if (out == null || out.length != xSize * zSize) {
            out = new double[xSize * zSize];
        }
        xScale /= 1.5;
        zScale /= 1.5;
        amplitude *= 0.55;
        int i = 0;
        for (int xi = 0; xi < xSize; ++xi) {
            double xx = (x + (double)xi) * xScale + this.xo;
            for (int zi = 0; zi < zSize; ++zi) {
                double zz = (z + (double)zi) * zScale + this.yo;
                int n = i++;
                out[n] = out[n] + this.getValue(xx, zz) * amplitude;
            }
        }
        return out;
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double amplitude) {
        if (out == null || out.length != xSize * ySize * zSize) {
            out = new double[xSize * ySize * zSize];
        }
        xScale /= 1.5;
        yScale /= 1.5;
        zScale /= 1.5;
        amplitude *= 0.55;
        int i = 0;
        for (int xi = 0; xi < xSize; ++xi) {
            double xx = (x + (double)xi) * xScale + this.xo;
            for (int zi = 0; zi < zSize; ++zi) {
                double zz = (z + (double)zi) * zScale + this.zo;
                for (int yi = 0; yi < ySize; ++yi) {
                    double yy = (y + (double)yi) * yScale + this.yo;
                    out[i++] = this.getValue(xx, yy, zz) * amplitude;
                }
            }
        }
        return out;
    }
}

