/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise.operator;

import net.minecraft.core.world.noise.Noise3D;
import net.minecraft.core.world.noise.operator.Rotate2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Rotate3D<T extends Noise3D>
extends Rotate2D<T>
implements Noise3D {
    private final double @NotNull [] @NotNull [] rot;

    public Rotate3D(@NotNull T noise, double xRot, double yRot, double zRot) {
        super(noise, yRot);
        double cx = Math.cos(xRot);
        double sx = Math.sin(xRot);
        double cy = Math.cos(yRot);
        double sy = Math.sin(yRot);
        double cz = Math.cos(zRot);
        double sz = Math.sin(zRot);
        this.rot = new double[][]{{cy * cz, -cy * sz, sy}, {sx * sy * cz + cx * sz, -sx * sy * sz + cx * cz, -sx * cy}, {-cx * sy * cz + sx * sz, cx * sy * sz + sx * cz, cx * cy}};
    }

    @Override
    public double getValue(double x, double y, double z) {
        double nx = this.rot[0][0] * x + this.rot[0][1] * y + this.rot[0][2] * z;
        double ny = this.rot[1][0] * x + this.rot[1][1] * y + this.rot[1][2] * z;
        double nz = this.rot[2][0] * x + this.rot[2][1] * y + this.rot[2][2] * z;
        return ((Noise3D)this.noise).getValue(nx, ny, nz);
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double amplitude) {
        throw new UnsupportedOperationException("Not implemented!");
    }
}

