/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelButtonPainted<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected final IconCoordinate[] texCoords = new IconCoordinate[16];

    public BlockModelButtonPainted(Block<T> block) {
        super(block);
        for (DyeColor c : DyeColor.blockOrderedColors()) {
            this.texCoords[c.blockMeta] = TextureRegistry.getTexture("minecraft:block/planks/" + c.colorID);
        }
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int meta) {
        return this.texCoords[meta >> 4 & 0xF];
    }
}

