/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockModelCropsPumpkin<T extends BlockLogic>
extends BlockModelStandard<T> {
    public static final IconCoordinate[] GROWTH_STAGE_TEXTURES_TOP = new IconCoordinate[]{TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage1_top"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage2_top"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage3_top"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage4_top")};
    public static final IconCoordinate[] GROWTH_STAGE_TEXTURES_SIDE = new IconCoordinate[]{TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage1_side"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage2_side"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage3_side"), TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage4_side")};
    public static final IconCoordinate LEAF_TEXTURE = TextureRegistry.getTexture("minecraft:block/crops_pumpkin/stage0");

    public BlockModelCropsPumpkin(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        float brightness = 1.0f;
        tessellator.setLightmapCoord1i(this.block.getLightmapCoord(worldSource, tilePos));
        tessellator.setColorOpaque3f(brightness, brightness, brightness);
        int meta = worldSource.getBlockData(tilePos);
        IconCoordinate leafTexture = LEAF_TEXTURE;
        if (BlockModelCropsPumpkin.renderBlocks.overrideBlockTexture != null) {
            leafTexture = BlockModelCropsPumpkin.renderBlocks.overrideBlockTexture;
        }
        double uMin = leafTexture.getIconUMin();
        double uMax = leafTexture.getIconUMax();
        double vMin = leafTexture.getIconVMin();
        double vMax = leafTexture.getIconVMax();
        double xMin = (double)tilePos.x() + 0.5 - 0.25;
        double xMax = (double)tilePos.x() + 0.5 + 0.25;
        double yMin = (double)tilePos.y() + 0.0;
        double yMax = (double)tilePos.y() + 0.1875;
        double zMin = (double)tilePos.z() + 0.5 - 0.5;
        double zMax = (double)tilePos.z() + 0.5 + 0.5;
        double extra = 0.625;
        tessellator.addVertexWithUV(xMin - extra, yMax, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMin, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMin, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMin - extra, yMax, zMin, uMax, vMin);
        tessellator.addVertexWithUV(xMin - extra, yMax, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMax, yMin, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMax, yMin, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMin - extra, yMax, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMin, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yMin, zMax, uMax, vMax);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMax, uMax, vMin);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMax, uMin, vMin);
        tessellator.addVertexWithUV(xMin, yMin, zMax, uMin, vMax);
        tessellator.addVertexWithUV(xMin, yMin, zMin, uMax, vMax);
        tessellator.addVertexWithUV(xMax + extra, yMax, zMin, uMax, vMin);
        if (meta >= 1) {
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBoundsFromState(worldSource, tilePos), tilePos);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        if (data < 1 || data > 4) {
            data = 1;
        }
        if (side == Side.TOP || side == Side.BOTTOM) {
            return GROWTH_STAGE_TEXTURES_TOP[data - 1];
        }
        return GROWTH_STAGE_TEXTURES_SIDE[data - 1];
    }
}

