/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicStairs;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.useless.dragonfly.DisplayPos;

public class BlockModelStairs<T extends BlockLogicStairs>
extends BlockModelStandard<T> {
    protected static final DisplayPos STAIRS_GUI = new DisplayPos(0.0f, 0.0f, 0.0f, 30.0f, 135.0f, 0.0f, 0.625f, 0.625f, 0.625f);
    protected static final DisplayPos STAIRS_HEAD = new DisplayPos(0.0f, 0.0f, 0.0f, 0.0f, -90.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    protected static final DisplayPos STAIRS_THIRD_PERSON_LEFT_HAND = new DisplayPos(0.0f, 0.15625f, 0.0f, 75.0f, -135.0f, 0.0f, 0.375f, 0.375f, 0.375f);
    protected BlockModelStandard<T> parentModel;

    public BlockModelStairs(Block<T> block) {
        super(block);
        this.parentModel = (BlockModelStandard)BlockModelDispatcher.getInstance().getDispatch(((BlockLogicStairs)this.block.getLogic()).modelBlock);
        this.blockTextures.copy(this.parentModel.blockTextures);
        this.retroBlockTextures.copy(this.parentModel.retroBlockTextures);
        this.setDisplayPos("gui", STAIRS_GUI);
        this.setDisplayPos("head", STAIRS_HEAD);
        this.setDisplayPos("thirdperson_lefthand", STAIRS_THIRD_PERSON_LEFT_HAND);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        int meta = worldSource.getBlockData(tilePos);
        int hRotation = meta & 3;
        int vRotation = meta & 8;
        float stepYOffset = vRotation > 0 ? 0.5f : 0.0f;
        AABBd bounds = new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        if (hRotation == 0) {
            bounds.setMin(0.0, 0.0f + stepYOffset, 0.0).setMax(0.5, 0.5f + stepYOffset, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.5, 0.0, 0.0).setMax(1.0, 1.0, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        } else if (hRotation == 1) {
            bounds.setMin(0.0, 0.0, 0.0).setMax(0.5, 1.0, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.5, 0.0f + stepYOffset, 0.0).setMax(1.0, 0.5f + stepYOffset, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        } else if (hRotation == 2) {
            bounds.setMin(0.0, 0.0f + stepYOffset, 0.0).setMax(1.0, 0.5f + stepYOffset, 0.5);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.0, 0.0, 0.5).setMax(1.0, 1.0, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        } else {
            bounds.setMin(0.0, 0.0, 0.0).setMax(1.0, 1.0, 0.5);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
            bounds.setMin(0.0, 0.0f + stepYOffset, 0.5).setMax(1.0, 0.5f + stepYOffset, 1.0);
            renderBlocks.renderStandardBlock(tessellator, worldSource, this, bounds, tilePos);
        }
        return true;
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        tessellator.startDrawingQuads();
        tessellator.setColor1i(this.getStandaloneTintColor(metadata));
        for (int l = 0; l < 2; ++l) {
            AABBd bounds = l == 0 ? new AABBd(0.0, 0.0, 0.0, 1.0, 0.5, 1.0) : new AABBd(0.5, 0.5, 0.0, 1.0, 1.0, 1.0);
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            renderBlocks.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            renderBlocks.renderTopFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            renderBlocks.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            renderBlocks.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            renderBlocks.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            renderBlocks.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
        }
        tessellator.draw();
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTextureFromSideAndMetadata(@NotNull Side side, int data) {
        return this.parentModel.getBlockTextureFromSideAndMetadata(side, data);
    }

    @Override
    @Nullable
    public IconCoordinate getBlockTexture(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.parentModel.getBlockTexture(source, tilePos, side);
    }

    @Override
    public int renderLayer() {
        return this.parentModel.renderLayer();
    }
}

