/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.Shaders;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.EntityPrimedTNT;
import org.jetbrains.annotations.NotNull;

public class EntityRendererTNT
extends EntityRenderer<EntityPrimedTNT> {
    public EntityRendererTNT() {
        super(0.5f);
    }

    @Override
    public void render(@NotNull TessellatorGeneral tessellator, @NotNull EntityPrimedTNT tnt, double x, double y, double z, float yaw, float partialTick) {
        GLRenderer.pushFrame();
        GLRenderer.modelM4f().translate((float)x, (float)y, (float)z);
        if ((float)tnt.fuse - partialTick + 1.0f < 10.0f) {
            float f2 = 1.0f - ((float)tnt.fuse - partialTick + 1.0f) / 10.0f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            f2 *= f2;
            f2 *= f2;
            float f4 = 1.0f + f2 * 0.3f;
            GLRenderer.modelM4f().scale(f4, f4, f4);
        }
        float f3 = (1.0f - ((float)tnt.fuse - partialTick + 1.0f) / 100.0f) * 0.8f;
        TextureRegistry.worldAtlas.bind();
        BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(Blocks.TNT);
        model.renderStandalone(tessellator, 0, tnt.getLightmap(partialTick));
        if (tnt.fuse / 5 % 2 == 0) {
            GLRenderer.pushFrame();
            GLRenderer.setShader(Shaders.COLOR_WORLD);
            GLRenderer.globalSetLightEnabled(false);
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.DST_ALPHA);
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, f3);
            model.renderStandalone(tessellator, 0, tnt.getLightmap(partialTick));
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLRenderer.disableState(State.BLEND);
            GLRenderer.globalSetLightEnabled(true);
            GLRenderer.popFrame();
        }
        GLRenderer.popFrame();
    }
}

