/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicAxisAligned;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicMatcher
extends BlockLogicAxisAligned {
    public final boolean isActive;

    public BlockLogicMatcher(@NotNull Block<?> block, boolean isActive) {
        super(block, Materials.STONE);
        this.isActive = isActive;
    }

    @Override
    public int tickDelay() {
        return 4;
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.updateState(world, tilePos);
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        Axis axis = mob.getPlacementDirection(side, PlacementMode.FACING).getAxis();
        world.setBlockDataNotify(tilePos, BlockLogicMatcher.axisToMeta(axis));
        world.scheduleBlockUpdate(tilePos, this.id(), this.tickDelay());
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        super.onPlacedByWorld(world, tilePos);
        world.scheduleBlockUpdate(tilePos, this.id(), this.tickDelay());
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        super.onPlacedOnSide(world, tilePos, side, xHit, yHit);
        world.scheduleBlockUpdate(tilePos, this.id(), this.tickDelay());
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, int id) {
        world.scheduleBlockUpdate(tilePos, this.id(), this.tickDelay());
    }

    public void updateState(@NotNull World world, @NotNull TilePosc tilePos) {
        Axis a = BlockLogicAxisAligned.metaToAxis(world.getBlockData(tilePos) & 3);
        TilePos front = new TilePos(tilePos);
        TilePos back = new TilePos(tilePos);
        switch (a) {
            case X: {
                ++front.x;
                --back.x;
                break;
            }
            case Y: {
                ++front.y;
                --back.y;
                break;
            }
            default: {
                ++front.z;
                --back.z;
            }
        }
        Block<?> fBlock = world.getBlock(front);
        boolean backMatchesFront = fBlock == null ? world.getBlock(back) == null : fBlock.isEquivalent(world, front, back);
        if (!this.isActive && backMatchesFront) {
            world.setBlockIdDataNotify(tilePos, Blocks.MATCHER_ACTIVE.id(), world.getBlockData(tilePos));
        } else if (this.isActive && !backMatchesFront) {
            world.setBlockIdDataNotify(tilePos, Blocks.MATCHER.id(), world.getBlockData(tilePos));
        }
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        if (!this.isActive) {
            return;
        }
        int brightness = 10;
        double d = 0.0625;
        for (int i = 0; i < Direction.directions.length; ++i) {
            Direction dir = Direction.directions[i];
            double px = (double)tilePos.x() + (double)rand.nextFloat();
            double py = (double)tilePos.y() + (double)rand.nextFloat();
            double pz = (double)tilePos.z() + (double)rand.nextFloat();
            if (!world.isBlockOpaqueCube(tilePos.add(dir, new TilePos()))) {
                switch (dir) {
                    case UP: {
                        py = (double)(tilePos.y() + 1) + d;
                        break;
                    }
                    case DOWN: {
                        py = (double)tilePos.y() - d;
                        break;
                    }
                    case SOUTH: {
                        pz = (double)(tilePos.z() + 1) + d;
                        break;
                    }
                    case NORTH: {
                        pz = (double)tilePos.z() - d;
                        break;
                    }
                    case EAST: {
                        px = (double)(tilePos.x() + 1) + d;
                        break;
                    }
                    case WEST: {
                        px = (double)tilePos.x() - d;
                    }
                }
            }
            if (!(px < (double)tilePos.x() || px > (double)(tilePos.x() + 1) || py < 0.0 || py > (double)(tilePos.y() + 1) || pz < (double)tilePos.z()) && !(pz > (double)(tilePos.z() + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, 0.0, 0.0, 0.0, 10);
        }
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        return this.isActive && BlockLogicAxisAligned.metaToAxis(source.getBlockData(tilePos)) != side.getAxis();
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        if (dropCause == EnumDropCause.IMPROPER_TOOL) {
            return null;
        }
        return new ItemStack[]{new ItemStack(Blocks.MATCHER)};
    }
}

