/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBoat
extends Item {
    public ItemBoat(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
        this.maxStackSize = 1;
    }

    @Override
    @Nullable
    public ItemStack onUse(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Player player) {
        HitResult rayCast = player.rayCast(player.getGamemode().getBlockReachDistance(), 1.0f, true, false, false);
        if (rayCast == null) {
            return selfStack;
        }
        if (rayCast instanceof HitResult.Tile) {
            HitResult.Tile hitTile = (HitResult.Tile)rayCast;
            TilePos pos = new TilePos(hitTile.tilePos);
            if (!world.isClientSide) {
                if (world.getBlockId(pos) == Blocks.LAYER_SNOW.id()) {
                    --pos.y;
                }
                EntityBoat boat = new EntityBoat(world, (float)pos.x + 0.5f, (float)pos.y + 1.0f, (float)pos.z + 0.5f);
                boat.setRot(player.yRot - 90.0f, 0.0f);
                world.entityJoinedWorld(boat);
            }
            selfStack.consumeItem(player);
        }
        return selfStack;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        double x = (double)blockPos.x() + offX + (double)direction.getOffsetX();
        double y = (double)blockPos.y() + offY + (double)direction.getOffsetY();
        double z = (double)blockPos.z() + offZ + (double)direction.getOffsetZ();
        selfStack.consumeItem(null);
        EntityBoat boat = new EntityBoat(world, x, y, z);
        world.entityJoinedWorld(boat);
    }
}

