/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.TessellatorGeneral;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockModelCrossedSquares<T extends BlockLogic>
extends BlockModelStandard<T> {
    public BlockModelCrossedSquares(Block<T> block) {
        super(block);
    }

    @Override
    public void renderStandalone(@NotNull TessellatorGeneral tessellator, int metadata, int lightmapCoord) {
        float yOffset = 0.0f;
        IconCoordinate texIndex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata);
        if (BlockModelCrossedSquares.renderBlocks.overrideBlockTexture != null) {
            texIndex = BlockModelCrossedSquares.renderBlocks.overrideBlockTexture;
        }
        double minU = texIndex.getIconUMin();
        double maxU = texIndex.getIconUMax();
        double minV = texIndex.getIconVMin();
        double maxV = texIndex.getIconVMax();
        tessellator.offsetTranslation(-0.5, -0.5, -0.5);
        tessellator.startDrawingQuads();
        tessellator.setColor1i(this.getStandaloneTintColor(metadata));
        tessellator.setLightmapCoord1i(lightmapCoord);
        double xd = 0.0;
        double yd = 0.0;
        double zd = 0.0;
        double minX = xd + 0.5 - 0.45;
        double maxX = xd + 0.5 + 0.45;
        double minZ = zd + 0.5 - 0.45;
        double maxZ = zd + 0.5 + 0.45;
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, minZ, minU, minV);
        tessellator.addVertexWithUV(minX, yd + 0.0, minZ, minU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, maxZ, maxU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, maxZ, maxU, minV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, maxZ, minU, minV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, maxZ, minU, maxV);
        tessellator.addVertexWithUV(minX, yd + 0.0, minZ, maxU, maxV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, minZ, maxU, minV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, maxZ, minU, minV);
        tessellator.addVertexWithUV(minX, yd + 0.0, maxZ, minU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, minZ, maxU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, minZ, maxU, minV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, minZ, minU, minV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, minZ, minU, maxV);
        tessellator.addVertexWithUV(minX, yd + 0.0, maxZ, maxU, maxV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, maxZ, maxU, minV);
        tessellator.draw();
        tessellator.offsetTranslation(0.5, 0.5, 0.5);
    }

    @Override
    public boolean render(@NotNull TessellatorGeneral tessellator, @NotNull WorldSource worldSource, @NotNull TilePosc tilePos) {
        tessellator.setLightmapCoord1i(this.block.getLightmapCoord(worldSource, tilePos));
        int color = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getWorldColor(worldSource, tilePos, 0);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.setColorOpaque3f(r, g, b);
        double xd = tilePos.x();
        double yd = tilePos.y();
        double zd = tilePos.z();
        if (this.block == Blocks.TALLGRASS || this.block == Blocks.TALLGRASS_FERN || this.block == Blocks.SPINIFEX) {
            long dRandom = (long)tilePos.x() * 3129871L ^ (long)tilePos.z() * 116129781L ^ (long)tilePos.y();
            dRandom = dRandom * dRandom * 42317861L + dRandom * 11L;
            xd += ((double)((float)(dRandom >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
            yd += ((double)((float)(dRandom >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
            zd += ((double)((float)(dRandom >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        }
        int metadata = worldSource.getBlockData(tilePos);
        IconCoordinate texIndex = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata);
        if (BlockModelCrossedSquares.renderBlocks.overrideBlockTexture != null) {
            texIndex = BlockModelCrossedSquares.renderBlocks.overrideBlockTexture;
        }
        double minU = texIndex.getIconUMin();
        double maxU = texIndex.getIconUMax();
        double minV = texIndex.getIconVMin();
        double maxV = texIndex.getIconVMax();
        float yOffset = 0.0f;
        double minX = xd + 0.5 - 0.45;
        double maxX = xd + 0.5 + 0.45;
        double minZ = zd + 0.5 - 0.45;
        double maxZ = zd + 0.5 + 0.45;
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, minZ, minU, minV);
        tessellator.addVertexWithUV(minX, yd + 0.0, minZ, minU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, maxZ, maxU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, maxZ, maxU, minV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, maxZ, minU, minV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, maxZ, minU, maxV);
        tessellator.addVertexWithUV(minX, yd + 0.0, minZ, maxU, maxV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, minZ, maxU, minV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, maxZ, minU, minV);
        tessellator.addVertexWithUV(minX, yd + 0.0, maxZ, minU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, minZ, maxU, maxV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, minZ, maxU, minV);
        tessellator.addVertexWithUV(maxX, yd + 1.0 + 0.0, minZ, minU, minV);
        tessellator.addVertexWithUV(maxX, yd + 0.0, minZ, minU, maxV);
        tessellator.addVertexWithUV(minX, yd + 0.0, maxZ, maxU, maxV);
        tessellator.addVertexWithUV(minX, yd + 1.0 + 0.0, maxZ, maxU, minV);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }
}

