/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.particle;

import net.minecraft.client.render.particle.Particle;
import net.minecraft.client.render.tessellator.TessellatorParticle;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class ParticleLava
extends Particle {
    private final float oSize;

    public ParticleLava(World world, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.xd *= 0.8;
        this.yd *= 0.8;
        this.zd *= 0.8;
        this.yd = random.nextFloat() * 0.4f + 0.05f;
        this.bCol = 1.0f;
        this.gCol = 1.0f;
        this.rCol = 1.0f;
        this.size *= random.nextFloat() * 2.0f + 0.2f;
        this.oSize = this.size;
        this.lifetime = (int)(16.0 / (Math.random() * 0.8 + 0.2));
        this.noPhysics = false;
        this.tex = TextureRegistry.getTexture("minecraft:particle/bubble_lava");
    }

    @Override
    public float calcBrightness(float partialTick) {
        return 1.0f;
    }

    @Override
    public void render(@NotNull TessellatorParticle t, float partialTick) {
        float l = ((float)this.age + partialTick) / (float)this.lifetime;
        this.size = this.oSize * (1.0f - l * l);
        super.render(t, partialTick);
    }

    @Override
    public void tick() {
        this.cachedLightmapCoord = this.calcLightmap(1.0f);
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        float odds = (float)this.age / (float)this.lifetime;
        if (random.nextFloat() > odds) {
            this.world.spawnParticle("smoke", this.x, this.y, this.z, this.xd, this.yd, this.zd, 0);
        }
        this.yd -= 0.03;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.999;
        this.yd *= 0.999;
        this.zd *= 0.999;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

