/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBed
extends Item {
    public ItemBed(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        TilePosc pos = blockPos;
        if (!world.canPlaceInsideBlock(pos)) {
            pos = pos.add(side.getDirection(), new TilePos());
        }
        Direction dir = player == null ? Direction.NORTH : player.getHorizontalPlacementDirection(null).getOpposite();
        TilePos pos2 = pos.sub(dir, new TilePos());
        if (world.isAirBlock(pos) && world.isAirBlock(pos2) && world.canPlaceOnSurfaceOfBlock(pos.down(new TilePos())) && world.canPlaceOnSurfaceOfBlock(pos2.down(new TilePos())) && world.canBlockIdBePlacedAt(Blocks.BED.id(), pos, false, side) && selfStack.consumeItem(player)) {
            world.playBlockSoundEffect(player, (float)pos.x() + 0.5f, (float)pos.y() + 0.5f, (float)pos.z() + 0.5f, Blocks.BED, EnumBlockSoundEffectType.PLACE);
            world.setBlockIdDataNotify(pos, Blocks.BED.id(), dir.getHorizontalIndex());
            world.setBlockIdDataNotify(pos2, Blocks.BED.id(), dir.getHorizontalIndex() | 8);
            return true;
        }
        return false;
    }
}

