/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome.provider;

import java.util.Set;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.data.BiomeRange;
import net.minecraft.core.world.biome.data.BiomeRangeMap;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.noise.FractalNoise2D;
import net.minecraft.core.world.noise.FractalNoise3D;
import net.minecraft.core.world.noise.Noise3D;
import net.minecraft.core.world.noise.SimplexNoise;
import net.minecraft.core.world.type.WorldType;

public final class BiomeProviderOverworld
extends BiomeProvider {
    private static final BiomeRangeMap brm = new BiomeRangeMap();
    private final FractalNoise2D<?> temperatureMap;
    private final FractalNoise2D<?> humidityMap;
    private final FractalNoise2D<?> varietyMap;
    private final FractalNoise2D<?> noiseMap;
    private double temperatureXScale = 0.0125;
    private double temperatureZScale = 0.0125;
    private double temperatureLacunarity = 0.25;
    private double temperatureNoise = 0.01;
    private double humidityXScale = 0.025;
    private double humidityZScale = 0.025;
    private double humidityLacunarity = 0.3;
    private double humidityNoise = 0.01;
    private double varietyXScale = 0.25;
    private double varietyZScale = 0.25;
    private double varietyLacunarity = 0.3;
    private double varietyNoise = 0.0;
    private double noiseXScale = 0.25;
    private double noiseZScale = 0.25;
    private double noiseLacunarity = 1.0;
    private final WorldType worldType;

    public BiomeProviderOverworld(long seed, WorldType worldType) {
        this.worldType = worldType;
        this.temperatureMap = new FractalNoise3D((Noise3D[])SimplexNoise.genOctaves(seed * 9871L, 4));
        this.humidityMap = new FractalNoise3D((Noise3D[])SimplexNoise.genOctaves(seed * 39811L, 4));
        this.varietyMap = new FractalNoise3D((Noise3D[])SimplexNoise.genOctaves(seed, 4));
        this.noiseMap = new FractalNoise3D((Noise3D[])SimplexNoise.genOctaves(seed * 543321L, 2));
    }

    public BiomeProviderOverworld withTemperatureScales(double xScale, double zScale, double lacunarity, double noise) {
        this.temperatureXScale = xScale;
        this.temperatureZScale = zScale;
        this.temperatureLacunarity = lacunarity;
        this.temperatureNoise = noise;
        return this;
    }

    public BiomeProviderOverworld withHumidityScales(double xScale, double zScale, double lacunarity, double noise) {
        this.humidityXScale = xScale;
        this.humidityZScale = zScale;
        this.humidityLacunarity = lacunarity;
        this.humidityNoise = noise;
        return this;
    }

    public BiomeProviderOverworld withNoiseScales(double xScale, double zScale, double lacunarity) {
        this.noiseXScale = xScale;
        this.noiseZScale = zScale;
        this.noiseLacunarity = lacunarity;
        return this;
    }

    @Override
    public Biome[] getBiomes(Biome[] biomes, double[] temperatures, double[] humidities, double[] varieties, int x, int y, int z, int xSize, int ySize, int zSize) {
        if (biomes == null || biomes.length < xSize * ySize * zSize) {
            biomes = new Biome[xSize * ySize * zSize];
        }
        if (temperatures == null || temperatures.length < xSize * zSize) {
            temperatures = new double[xSize * zSize];
        }
        this.getTemperatures(temperatures, x, z, xSize, zSize);
        if (humidities == null || humidities.length < xSize * zSize) {
            humidities = new double[xSize * zSize];
        }
        this.getHumidities(humidities, x, z, xSize, zSize);
        if (varieties == null || varieties.length < xSize * zSize) {
            varieties = new double[xSize * zSize];
        }
        this.getVarieties(varieties, x, z, xSize, zSize);
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double temperature = temperatures[dx * zSize + dz];
                double humidity = humidities[dx * zSize + dz];
                double variety = varieties[dx * zSize + dz];
                for (int dy = 0; dy < ySize; ++dy) {
                    double altitude = this.worldType.getYPercentage(y + dy << 3);
                    biomes[dy * xSize * zSize + dz * xSize + dx] = this.lookupBiome(temperature, humidity, altitude, variety);
                }
            }
        }
        return biomes;
    }

    @Override
    public double[] getTemperatures(double[] temperatures, int x, int z, int xSize, int zSize) {
        if (temperatures == null || temperatures.length < xSize * zSize) {
            temperatures = new double[xSize * zSize];
        }
        double[] tnResult = this.temperatureMap.setLacunarity(this.temperatureLacunarity).getRegion(null, x, z, xSize, zSize, this.temperatureXScale, this.temperatureZScale);
        double[] fnResult = this.noiseMap.setLacunarity(this.noiseLacunarity).getRegion(null, x, z, xSize, zSize, this.noiseXScale, this.noiseZScale);
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double fuzzPctg = this.temperatureNoise;
                double valPctg = 1.0 - fuzzPctg;
                double fuzziness = fnResult[dx * zSize + dz] * 1.1 + 0.5;
                double temperature = (tnResult[dx * zSize + dz] * 0.15 + 0.7) * valPctg + fuzziness * fuzzPctg;
                if (temperature < 0.0) {
                    temperature = 0.0;
                }
                if (temperature > 1.0) {
                    temperature = 1.0;
                }
                temperatures[dx * zSize + dz] = temperature;
            }
        }
        return temperatures;
    }

    @Override
    public double[] getHumidities(double[] humidities, int x, int z, int xSize, int zSize) {
        if (humidities == null || humidities.length < xSize * zSize) {
            humidities = new double[xSize * zSize];
        }
        double[] hnResult = this.humidityMap.setLacunarity(this.humidityLacunarity).getRegion(null, x, z, xSize, zSize, this.humidityXScale, this.humidityZScale);
        double[] fnResult = this.noiseMap.setLacunarity(this.noiseLacunarity).getRegion(null, x, z, xSize, zSize, this.noiseXScale, this.noiseZScale);
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double fuzzPctg = this.humidityNoise;
                double valPctg = 1.0 - fuzzPctg;
                double fuzziness = fnResult[dx * zSize + dz] * 1.1 + 0.5;
                double humidity = (hnResult[dx * zSize + dz] * 0.15 + 0.5) * valPctg + fuzziness * fuzzPctg;
                if (humidity < 0.0) {
                    humidity = 0.0;
                }
                if (humidity > 1.0) {
                    humidity = 1.0;
                }
                humidities[dx * zSize + dz] = humidity;
            }
        }
        return humidities;
    }

    @Override
    public double[] getVarieties(double[] varieties, int x, int z, int xSize, int zSize) {
        if (varieties == null || varieties.length < xSize * zSize) {
            varieties = new double[xSize * zSize];
        }
        double[] vnResult = this.varietyMap.setLacunarity(this.varietyLacunarity).getRegion(null, x, z, xSize, zSize, this.varietyXScale, this.varietyZScale);
        double[] fnResult = this.noiseMap.setLacunarity(this.noiseLacunarity).getRegion(null, x, z, xSize, zSize, this.noiseXScale, this.noiseZScale);
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double fuzzPctg = this.varietyNoise;
                double valPctg = 1.0 - fuzzPctg;
                double fuzziness = fnResult[dx * zSize + dz] * 1.1 + 0.5;
                double variety = (vnResult[dx * zSize + dz] * 0.15 + 0.5) * valPctg + fuzziness * fuzzPctg;
                if (variety < 0.0) {
                    variety = 0.0;
                }
                if (variety > 1.0) {
                    variety = 1.0;
                }
                varieties[dx * zSize + dz] = variety;
            }
        }
        return varieties;
    }

    @Override
    public double[] getBiomenesses(double[] biomenesses, int x, int y, int z, int xSize, int ySize, int zSize) {
        if (biomenesses == null || biomenesses.length < xSize * ySize * zSize) {
            biomenesses = new double[xSize * ySize * zSize];
        }
        double[] temperatures = this.getTemperatures(null, x, z, xSize, zSize);
        double[] humidities = this.getHumidities(null, x, z, xSize, zSize);
        double[] varieties = this.getVarieties(null, x, z, xSize, zSize);
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dy = 0; dy < ySize; ++dy) {
                for (int dz = 0; dz < zSize; ++dz) {
                    double temperature = MathHelper.clamp(temperatures[dx * zSize + dz], 0.0, 1.0);
                    double humidity = MathHelper.clamp(humidities[dx * zSize + dz], 0.0, 1.0);
                    double altitude = MathHelper.clamp(this.worldType.getYPercentage(y + dy << 3), 0.0, 1.0);
                    double variety = MathHelper.clamp(varieties[dx * zSize + dz], 0.0, 1.0);
                    Biome biome = this.lookupBiome(temperature, humidity, altitude, variety);
                    Set<BiomeRange> ranges = brm.getRanges(biome);
                    humidity *= temperature;
                    double biomeness = 0.0;
                    for (BiomeRange range : ranges) {
                        if (!range.contains(temperature, humidity, variety, altitude)) continue;
                        double newTemperature = temperature;
                        double newHumidity = humidity;
                        double newAltitude = altitude;
                        double newVariety = variety;
                        double temperatureRange = range.getMaxTemperature() - range.getMinTemperature();
                        double humidityRange = range.getMaxHumidity() - range.getMinHumidity();
                        double altitudeRange = range.getMaxAltitude() - range.getMinAltitude();
                        double varietyRange = range.getMaxVariety() - range.getMinVariety();
                        newTemperature = (newTemperature - range.getMinTemperature()) / temperatureRange;
                        newHumidity = (newHumidity - range.getMinHumidity()) / humidityRange;
                        newAltitude = (newAltitude - range.getMinAltitude()) / altitudeRange;
                        newVariety = (newVariety - range.getMinVariety()) / varietyRange;
                        newTemperature = range.getMinTemperature() <= 0.0 && newTemperature <= 0.5 || range.getMaxTemperature() >= 1.0 && newTemperature >= 0.5 ? 1.0 : -Math.abs(newTemperature * 2.0 - 1.0) + 1.0;
                        double newBiomeness = newTemperature * (newHumidity = range.getMinHumidity() <= 0.0 && newHumidity <= 0.5 || range.getMaxHumidity() >= 1.0 && newHumidity >= 0.5 ? 1.0 : -Math.abs(newHumidity * 2.0 - 1.0) + 1.0) * (newAltitude = range.getMinAltitude() <= 0.0 && newAltitude <= 0.5 || range.getMaxAltitude() >= 1.0 && newAltitude >= 0.5 ? 1.0 : -Math.abs(newAltitude * 2.0 - 1.0) + 1.0) * (newVariety = range.getMinVariety() <= 0.0 && newVariety <= 0.5 || range.getMaxVariety() >= 1.0 && newVariety >= 0.5 ? 1.0 : -Math.abs(newVariety * 2.0 - 1.0) + 1.0);
                        if (!(newBiomeness > biomeness)) continue;
                        biomeness = newBiomeness;
                    }
                    biomenesses[dy * xSize * zSize + dz * xSize + dx] = biomeness;
                }
            }
        }
        return biomenesses;
    }

    @Override
    public Biome lookupBiome(double temperature, double humidity, double variety, double altitude) {
        return brm.lookupBiome(temperature, humidity *= temperature, variety, altitude);
    }

    public static void init() {
        brm.clear();
        brm.addRange(Biomes.OVERWORLD_GLACIER, new BiomeRange(0.0, 0.3, 0.0, 0.01, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_TUNDRA, new BiomeRange(0.0, 0.3, 0.01, 0.1, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_TAIGA, new BiomeRange(0.0, 0.3, 0.1, 1.0, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_BOREAL_FOREST, new BiomeRange(0.3, 0.5, 0.05, 1.0, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_GRASSLANDS, new BiomeRange(0.5, 0.98, 0.0, 0.05, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_MEADOW, new BiomeRange(0.3, 0.5, 0.0, 0.05, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_BIRCH_FOREST, new BiomeRange(0.5, 0.75, 0.3, 0.5, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_SHRUBLAND, new BiomeRange(0.5, 0.75, 0.05, 0.3, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_SEASONAL_FOREST, new BiomeRange(0.5, 0.75, 0.5, 1.0, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_SWAMPLAND, new BiomeRange(0.75, 0.95, 0.85, 1.0, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_FOREST, new BiomeRange(0.75, 0.95, 0.4, 0.85, 0.0, 1.0, 0.0, 1.0), new BiomeRange(0.95, 1.0, 0.4, 0.85, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_PLAINS, new BiomeRange(0.75, 1.0, 0.1, 0.4, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_DESERT, new BiomeRange(0.85, 1.0, 0.0, 0.01, 0.0, 1.0, 0.0, 1.0));
        brm.addRange(Biomes.OVERWORLD_OUTBACK, new BiomeRange(0.75, 0.9, 0.0, 0.2, 0.0, 1.0, 0.0, 0.95));
        brm.addRange(Biomes.OVERWORLD_OUTBACK_GRASSY, new BiomeRange(0.75, 0.9, 0.0, 0.2, 0.0, 1.0, 0.95, 1.0));
        brm.addRange(Biomes.OVERWORLD_CAATINGA, new BiomeRange(0.9, 1.0, 0.01, 0.2, 0.0, 1.0, 0.1, 1.0));
        brm.addRange(Biomes.OVERWORLD_CAATINGA_PLAINS, new BiomeRange(0.9, 1.0, 0.01, 0.2, 0.0, 1.0, 0.0, 0.1));
        brm.addRange(Biomes.OVERWORLD_RAINFOREST, new BiomeRange(0.95, 1.0, 0.85, 1.0, 0.0, 1.0, 0.0, 1.0));
        brm.lock();
    }
}

