/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise;

import net.minecraft.core.world.noise.FractalNoise2D;
import net.minecraft.core.world.noise.Noise3D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FractalNoise3D<T extends Noise3D>
extends FractalNoise2D<T>
implements Noise3D {
    public FractalNoise3D(@NotNull @NotNull T @NotNull [] octaves) {
        super(octaves);
    }

    @Override
    public double getValue(double x, double y, double z) {
        double out = 0.0;
        double frequency = 1.0;
        double amplitude = 1.0;
        for (Noise3D octave : (Noise3D[])this.octaves) {
            out += octave.getValue(x * frequency, y * frequency, z * frequency) * amplitude;
            frequency *= this.lacunarity;
            amplitude *= this.persistence;
        }
        return out;
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double amplitude) {
        if (out == null || out.length < xSize * ySize * zSize) {
            out = new double[xSize * ySize * zSize];
        }
        double frequency = 1.0;
        for (Noise3D octave : (Noise3D[])this.octaves) {
            octave.addRegion(out, x, y, z, xSize, ySize, zSize, xScale * frequency, yScale * frequency, zScale * frequency, amplitude);
            frequency *= this.lacunarity;
            amplitude *= this.persistence;
        }
        return out;
    }
}

