/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise.operator;

import net.minecraft.core.world.noise.Noise3D;
import net.minecraft.core.world.noise.operator.Scale2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Scale3D<T extends Noise3D>
extends Scale2D<T>
implements Noise3D {
    protected final double yScale;

    public Scale3D(@NotNull T noise, double xScale, double yScale, double zScale) {
        super(noise, xScale, zScale);
        this.yScale = yScale;
    }

    @Override
    public double getValue(double x, double y, double z) {
        return ((Noise3D)this.noise).getValue(x * this.xScale, y * this.yScale, z * this.zScale);
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double y, double z, int xSize, int ySize, int zSize, double xScale, double yScale, double zScale, double amplitude) {
        return ((Noise3D)this.noise).addRegion(out, x, y, z, xSize, ySize, zSize, xScale * this.xScale, yScale * this.yScale, zScale * this.zScale, amplitude);
    }
}

