/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.option.Option;
import net.minecraft.client.render.renderer.BlendFactor;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.client.render.renderer.State;
import net.minecraft.client.util.helper.Colors;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Time;

public class HeldItemTooltipElement
extends Gui {
    private final Minecraft mc;
    private int lastItemID;
    private int lastSelectedItem;
    private String string;
    private int color;
    private double time = 0.0;
    private final double displayTime = 2.5;
    private final double fadeTime = 0.5;

    public HeldItemTooltipElement(Minecraft mc) {
        this.mc = mc;
    }

    public void updateAndRender(Minecraft mc, int width, int height, int screenPadding) {
        if (((Boolean)mc.gameSettings.heldItemTooltips.value).booleanValue()) {
            ItemStack item = mc.thePlayer.getCurrentEquippedItem();
            int id = this.getItemID(item);
            int i = mc.thePlayer.inventory.getCurrentItemIndex();
            if (id != this.lastItemID || i != this.lastSelectedItem) {
                this.updateString(item);
                this.time = this.displayTime;
                this.lastItemID = id;
                this.lastSelectedItem = i;
            }
        }
        this.render(mc, width, height, screenPadding);
    }

    public void updateAndRender(Minecraft mc, int x, int y) {
        if (((Boolean)mc.gameSettings.heldItemTooltips.value).booleanValue()) {
            ItemStack item = mc.thePlayer.getCurrentEquippedItem();
            int id = this.getItemID(item);
            int i = mc.thePlayer.inventory.getCurrentItemIndex();
            if (id != this.lastItemID || i != this.lastSelectedItem) {
                this.updateString(item);
                this.time = this.displayTime;
                this.lastItemID = id;
                this.lastSelectedItem = i;
            }
        }
        this.render(mc, x, y);
    }

    private void updateString(ItemStack item) {
        if (item == null) {
            this.string = null;
            return;
        }
        this.string = item.getDisplayName();
        this.color = Colors.allChatColors[item.getDisplayColor()].getARGB();
    }

    public void setOptionNameAndValueString(Option<?> option) {
        this.setString(option.getDisplayStringName() + ": " + this.mc.gameSettings.getDisplayString(option));
    }

    public void setString(String string) {
        this.setString(string, 0xFFFFFF);
    }

    public void setString(String string, int color) {
        this.string = string;
        this.color = color;
        this.time = this.displayTime;
    }

    public void render(Minecraft mc, int width, int height, int screenPadding) {
        this.render(mc, width / 2, height - 50 - screenPadding);
    }

    public void render(Minecraft mc, int x, int y) {
        int a;
        if (this.string == null) {
            return;
        }
        if (this.time < 0.0) {
            return;
        }
        double alpha = this.time < this.fadeTime ? this.time / this.fadeTime : 1.0;
        if (!mc.isGamePaused) {
            this.time -= Time.delta;
        }
        if ((a = (int)(alpha * 255.0)) < 1) {
            return;
        }
        int rgb = this.color & 0xFFFFFF | a << 24;
        if (a < 255) {
            GLRenderer.enableState(State.BLEND);
            GLRenderer.setBlendFunc(BlendFactor.SRC_ALPHA, BlendFactor.ONE_MINUS_SRC_ALPHA);
        }
        mc.font.renderCentered(this.string, x, y).setShadow().setColor(rgb).call();
        GLRenderer.disableState(State.BLEND);
    }

    private int getItemID(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        return stack.getItem().id;
    }
}

