/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.crafting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ItemElement;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.guidebook.GuidebookPageManager;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.RecipePage;
import net.minecraft.client.gui.guidebook.ScreenGuidebook;
import net.minecraft.client.gui.guidebook.SlotGuidebook;
import net.minecraft.client.gui.guidebook.crafting.displays.DisplayAdapterDyeing;
import net.minecraft.client.gui.guidebook.crafting.displays.DisplayAdapterLabel;
import net.minecraft.client.gui.guidebook.crafting.displays.DisplayAdapterLabelDye;
import net.minecraft.client.gui.guidebook.crafting.displays.DisplayAdapterMapDuplication;
import net.minecraft.client.gui.guidebook.crafting.displays.DisplayAdapterRepairable;
import net.minecraft.client.gui.guidebook.crafting.displays.DisplayAdapterShaped;
import net.minecraft.client.gui.guidebook.crafting.displays.DisplayAdapterShapeless;
import net.minecraft.client.gui.guidebook.crafting.displays.DisplayAdapterTool;
import net.minecraft.client.gui.guidebook.crafting.displays.DisplayAdapterUndye;
import net.minecraft.client.gui.guidebook.crafting.displays.RecipeDisplayAdapter;
import net.minecraft.client.gui.guidebook.crafting.displays.displayAdapterScrap;
import net.minecraft.client.gui.guidebook.search.GuidebookPageSearch;
import net.minecraft.client.option.enums.DescriptionPromptEnum;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.font.FontRenderer;
import net.minecraft.client.render.renderer.GLRenderer;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCrafting;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShaped;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingShapeless;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingWithTool;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryDyeing;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabel;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryLabelDye;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryMapDuplication;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryRepairable;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryScrap;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryUndyeing;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.player.inventory.slot.Slot;

public class RecipePageCrafting
extends RecipePage<RecipeEntryCrafting<?, ?>> {
    public static final int RECIPES_PER_PAGE = 3;
    public List<SlotGuidebook> slots;
    public Map<RecipeEntryCrafting<?, ?>, List<SlotGuidebook>> map;
    public static Map<Class<? extends RecipeEntryCrafting<?, ?>>, RecipeDisplayAdapter<?>> recipeToDisplayAdapterMap = new HashMap();
    private final TooltipElement tooltipElement;
    private final ItemElement itemElement;
    private static final Minecraft mc;
    private static long ticks;

    public RecipePageCrafting(GuidebookSection section, List<RecipeEntryCrafting<?, ?>> recipes) {
        super(section);
        this.recipes = recipes;
        this.slots = new ArrayList<SlotGuidebook>();
        this.map = new HashMap();
        this.tooltipElement = new TooltipElement(mc);
        this.itemElement = new ItemElement(mc);
        int recipeAmount = 0;
        int xOffset = 32;
        int yOffset = 12;
        for (RecipeEntryCrafting<?, ?> recipe : recipes) {
            if (!recipeToDisplayAdapterMap.containsKey(recipe.getClass())) continue;
            RecipeDisplayAdapter<?> adapter = recipeToDisplayAdapterMap.get(recipe.getClass());
            List<SlotGuidebook> recipeSlots = adapter.getSlots(recipe, recipeAmount, xOffset, yOffset);
            this.map.put(recipe, recipeSlots);
            this.slots.addAll(recipeSlots);
            yOffset += 10;
            ++recipeAmount;
        }
    }

    @Override
    public void onTick() {
        ++ticks;
        for (SlotGuidebook slot : this.slots) {
            if (ticks <= 20L) continue;
            slot.showRandomItem();
            if (this.slots.get(this.slots.size() - 1) != slot) continue;
            ticks = 0L;
        }
    }

    @Override
    protected void renderForeground(TextureManager re, FontRenderer sr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.recipes.isEmpty()) {
            String string = I18n.getInstance().translateKey("guidebook.section.search.error.no_recipes");
            Objects.requireNonNull(this);
            int n = x + 158 / 2;
            Objects.requireNonNull(this);
            this.drawStringCenteredNoShadow(sr, string, n, y + 220 / 2, -8355712);
        }
        SlotGuidebook mouseOverSlot = null;
        for (SlotGuidebook slot : this.slots) {
            if (slot.item != null && !slot.isOutput) {
                slot.item.stackSize = 1;
            }
            this.drawSlot(x + slot.x - 1, y + slot.y - 1, -1);
            if (this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            this.itemElement.render(slot.getItemStack(), x + slot.x, y + slot.y, mouseOverSlot == slot, slot);
        }
    }

    public boolean getIsMouseOverSlot(Slot slot, int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + slot.x - 1 && mouseX < x + slot.x + 16 + 1 && mouseY >= y + slot.y - 1 && mouseY < y + slot.y + 16 + 1;
    }

    @Override
    public boolean keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        super.keyTyped(c, key, x, y, mouseX, mouseY);
        if (RecipePageCrafting.mc.gameSettings.keyShowRecipe.isKeyboardKey(key)) {
            SlotGuidebook hoveringSlot = null;
            for (SlotGuidebook slot : this.slots) {
                if (!this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "r:" + hoveringSlot.getItemStack().getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve(query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        } else if (RecipePageCrafting.mc.gameSettings.keyShowUsage.isKeyboardKey(key)) {
            SlotGuidebook hoveringSlot = null;
            for (SlotGuidebook slot : this.slots) {
                if (!this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "u:" + hoveringSlot.getItemStack().getDisplayName() + "!";
                GuidebookPageManager.searchQuery = SearchQuery.resolve(query);
                GuidebookPageSearch.searchField.setText(query);
                ScreenGuidebook.getPageManager().updatePages();
                ScreenGuidebook.getPageManager().setCurrentPage(ScreenGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
                return true;
            }
        }
        return false;
    }

    @Override
    public void render(TextureManager re, FontRenderer sr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.render(re, sr, x, y, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderBackground(TextureManager re, int x, int y) {
        super.renderBackground(re, x, y);
        re.bindTexture(re.loadTexture("/assets/minecraft/textures/gui/container/guidebook/guidebook.png"));
        for (int i = 1; i <= this.recipes.size(); ++i) {
            RecipeEntryCrafting recipe = (RecipeEntryCrafting)this.recipes.get(i - 1);
            List<SlotGuidebook> list = this.map.get(recipe);
            this.drawTexturedModalRect(x + list.get((int)(list.size() - 1)).x - 25, y + list.get((int)(list.size() - 1)).y, 234, 0, 22, 15);
        }
    }

    @Override
    protected void renderOverlay(TextureManager re, FontRenderer sr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.renderOverlay(re, sr, x, y, mouseX, mouseY, partialTicks);
        SlotGuidebook mouseOverSlot = null;
        for (SlotGuidebook slot : this.slots) {
            if (this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            GLRenderer.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            if (mouseOverSlot == null || !mouseOverSlot.hasItem()) continue;
            boolean showDescription = DescriptionPromptEnum.showDescription(mc);
            String str = this.tooltipElement.getTooltipText(mouseOverSlot.getItemStack(), showDescription, mouseOverSlot);
            if (str.isEmpty()) continue;
            this.tooltipElement.render(str, mouseX, mouseY, 8, -8);
        }
    }

    public static boolean guidebookSupportsRecipe(RecipeEntryBase<?, ?, ?> recipe) {
        return recipeToDisplayAdapterMap.containsKey(recipe.getClass());
    }

    static {
        recipeToDisplayAdapterMap.put(RecipeEntryCraftingShaped.class, new DisplayAdapterShaped());
        recipeToDisplayAdapterMap.put(RecipeEntryCraftingShapeless.class, new DisplayAdapterShapeless());
        recipeToDisplayAdapterMap.put(RecipeEntryCraftingWithTool.class, new DisplayAdapterTool());
        recipeToDisplayAdapterMap.put(RecipeEntryRepairable.class, new DisplayAdapterRepairable());
        recipeToDisplayAdapterMap.put(RecipeEntryScrap.class, new displayAdapterScrap());
        recipeToDisplayAdapterMap.put(RecipeEntryLabel.class, new DisplayAdapterLabel());
        recipeToDisplayAdapterMap.put(RecipeEntryLabelDye.class, new DisplayAdapterLabelDye());
        recipeToDisplayAdapterMap.put(RecipeEntryMapDuplication.class, new DisplayAdapterMapDuplication());
        recipeToDisplayAdapterMap.put(RecipeEntryUndyeing.class, new DisplayAdapterUndye());
        recipeToDisplayAdapterMap.put(RecipeEntryDyeing.class, new DisplayAdapterDyeing());
        mc = Minecraft.getMinecraft();
        ticks = 0L;
    }
}

